/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.UrlModelSource;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.events.TransferListener;

@Deprecated
@Named
@Singleton
public class DefaultMavenProjectBuilder
implements MavenProjectBuilder {
    @Inject
    private ProjectBuilder projectBuilder;
    @Inject
    private RepositorySystem repositorySystem;
    @Inject
    private LegacySupport legacySupport;

    private ProjectBuildingRequest toRequest(ProjectBuilderConfiguration configuration) {
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
        request.setValidationLevel(20);
        request.setResolveDependencies(false);
        request.setLocalRepository(configuration.getLocalRepository());
        request.setBuildStartTime(configuration.getBuildStartTime());
        request.setUserProperties(configuration.getUserProperties());
        request.setSystemProperties(configuration.getExecutionProperties());
        ProfileManager profileManager = configuration.getGlobalProfileManager();
        if (profileManager != null) {
            request.setActiveProfileIds(profileManager.getExplicitlyActivatedIds());
            request.setInactiveProfileIds(profileManager.getExplicitlyDeactivatedIds());
        } else {
            MavenExecutionRequest req;
            MavenSession session = this.legacySupport.getSession();
            if (session != null && (req = session.getRequest()) != null) {
                request.setActiveProfileIds(req.getActiveProfiles());
                request.setInactiveProfileIds(req.getInactiveProfiles());
            }
        }
        return request;
    }

    private ProjectBuildingRequest injectSession(ProjectBuildingRequest request) {
        MavenSession session = this.legacySupport.getSession();
        if (session != null) {
            MavenExecutionRequest req;
            request.setRepositorySession(session.getRepositorySession());
            request.setSystemProperties(session.getSystemProperties());
            if (request.getUserProperties().isEmpty()) {
                request.setUserProperties(session.getUserProperties());
            }
            if ((req = session.getRequest()) != null) {
                request.setRemoteRepositories(req.getRemoteRepositories());
            }
        } else {
            Properties props = new Properties();
            EnvironmentUtils.addEnvVars((Properties)props);
            props.putAll((Map<?, ?>)System.getProperties());
            request.setSystemProperties(props);
        }
        return request;
    }

    private List<ArtifactRepository> normalizeToArtifactRepositories(List<?> repositories, ProjectBuildingRequest request) throws ProjectBuildingException {
        if (repositories != null) {
            boolean normalized = false;
            ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>(repositories.size());
            for (ArtifactRepository repository : repositories) {
                if (repository instanceof Repository) {
                    try {
                        ArtifactRepository repo = this.repositorySystem.buildArtifactRepository((Repository)repository);
                        this.repositorySystem.injectMirror(request.getRepositorySession(), Arrays.asList(repo));
                        this.repositorySystem.injectProxy(request.getRepositorySession(), Arrays.asList(repo));
                        this.repositorySystem.injectAuthentication(request.getRepositorySession(), Arrays.asList(repo));
                        repos.add(repo);
                    }
                    catch (InvalidRepositoryException e) {
                        throw new ProjectBuildingException("", "Invalid remote repository " + repository, (Throwable)e);
                    }
                    normalized = true;
                    continue;
                }
                repos.add(repository);
            }
            if (normalized) {
                return repos;
            }
        }
        return repositories;
    }

    private ProjectBuildingException transformError(ProjectBuildingException e) {
        if (e.getCause() instanceof ModelBuildingException) {
            return new InvalidProjectModelException(e.getProjectId(), e.getMessage(), e.getPomFile());
        }
        return e;
    }

    @Override
    public MavenProject build(File pom, ProjectBuilderConfiguration configuration) throws ProjectBuildingException {
        ProjectBuildingRequest request = this.injectSession(this.toRequest(configuration));
        try {
            return this.projectBuilder.build(pom, request).getProject();
        }
        catch (ProjectBuildingException e) {
            throw this.transformError(e);
        }
    }

    @Override
    public MavenProject build(File pom, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        DefaultProjectBuilderConfiguration configuration = new DefaultProjectBuilderConfiguration();
        configuration.setLocalRepository(localRepository);
        configuration.setGlobalProfileManager(profileManager);
        return this.build(pom, configuration);
    }

    public MavenProject buildFromRepository(Artifact artifact, List<ArtifactRepository> remoteRepositories, ProjectBuilderConfiguration configuration, boolean allowStubModel) throws ProjectBuildingException {
        ProjectBuildingRequest request = this.injectSession(this.toRequest(configuration));
        request.setRemoteRepositories(this.normalizeToArtifactRepositories(remoteRepositories, request));
        request.setProcessPlugins(false);
        request.setValidationLevel(0);
        try {
            return this.projectBuilder.build(artifact, allowStubModel, request).getProject();
        }
        catch (ProjectBuildingException e) {
            throw this.transformError(e);
        }
    }

    @Override
    public MavenProject buildFromRepository(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, boolean allowStubModel) throws ProjectBuildingException {
        DefaultProjectBuilderConfiguration configuration = new DefaultProjectBuilderConfiguration();
        configuration.setLocalRepository(localRepository);
        return this.buildFromRepository(artifact, remoteRepositories, configuration, allowStubModel);
    }

    @Override
    public MavenProject buildFromRepository(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ProjectBuildingException {
        return this.buildFromRepository(artifact, remoteRepositories, localRepository, true);
    }

    @Override
    public MavenProject buildStandaloneSuperProject(ProjectBuilderConfiguration configuration) throws ProjectBuildingException {
        ProjectBuildingRequest request = this.injectSession(this.toRequest(configuration));
        request.setProcessPlugins(false);
        request.setValidationLevel(0);
        UrlModelSource modelSource = new UrlModelSource(this.getClass().getResource("standalone.xml"));
        MavenProject project = this.projectBuilder.build((ModelSource)modelSource, request).getProject();
        project.setExecutionRoot(true);
        return project;
    }

    @Override
    public MavenProject buildStandaloneSuperProject(ArtifactRepository localRepository) throws ProjectBuildingException {
        return this.buildStandaloneSuperProject(localRepository, null);
    }

    @Override
    public MavenProject buildStandaloneSuperProject(ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        DefaultProjectBuilderConfiguration configuration = new DefaultProjectBuilderConfiguration();
        configuration.setLocalRepository(localRepository);
        configuration.setGlobalProfileManager(profileManager);
        return this.buildStandaloneSuperProject(configuration);
    }

    @Override
    public MavenProject buildWithDependencies(File pom, ArtifactRepository localRepository, ProfileManager profileManager, TransferListener transferListener) throws ProjectBuildingException, ArtifactResolutionException, ArtifactNotFoundException {
        DefaultProjectBuilderConfiguration configuration = new DefaultProjectBuilderConfiguration();
        configuration.setLocalRepository(localRepository);
        configuration.setGlobalProfileManager(profileManager);
        ProjectBuildingRequest request = this.injectSession(this.toRequest(configuration));
        request.setResolveDependencies(true);
        try {
            return this.projectBuilder.build(pom, request).getProject();
        }
        catch (ProjectBuildingException e) {
            throw this.transformError(e);
        }
    }

    @Override
    public MavenProject buildWithDependencies(File pom, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException, ArtifactResolutionException, ArtifactNotFoundException {
        return this.buildWithDependencies(pom, localRepository, profileManager, null);
    }
}

