/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.jansi;

import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.cli.jansi.Style;
import org.fusesource.jansi.Ansi;

@Experimental
public class JansiMessageBuilder
implements MessageBuilder {
    private final Ansi ansi;
    private StringBuilder sb;

    public JansiMessageBuilder() {
        this.sb = new StringBuilder(80);
        this.ansi = Ansi.ansi();
    }

    public JansiMessageBuilder(StringBuilder sb) {
        this.sb = sb;
        this.ansi = Ansi.ansi((StringBuilder)sb);
    }

    @Nonnull
    public MessageBuilder trace(Object o) {
        return this.style(Style.TRACE, o);
    }

    @Nonnull
    public MessageBuilder debug(Object o) {
        return this.style(Style.DEBUG, o);
    }

    @Nonnull
    public MessageBuilder info(Object o) {
        return this.style(Style.INFO, o);
    }

    @Nonnull
    public MessageBuilder warning(Object o) {
        return this.style(Style.WARNING, o);
    }

    @Nonnull
    public MessageBuilder error(Object o) {
        return this.style(Style.ERROR, o);
    }

    @Nonnull
    public MessageBuilder success(Object o) {
        return this.style(Style.SUCCESS, o);
    }

    @Nonnull
    public MessageBuilder failure(Object o) {
        return this.style(Style.FAILURE, o);
    }

    @Nonnull
    public MessageBuilder strong(Object o) {
        return this.style(Style.STRONG, o);
    }

    @Nonnull
    public MessageBuilder mojo(Object o) {
        return this.style(Style.MOJO, o);
    }

    @Nonnull
    public MessageBuilder project(Object o) {
        return this.style(Style.PROJECT, o);
    }

    private MessageBuilder style(Style style, Object o) {
        style.apply(this.ansi).a(o).reset();
        return this;
    }

    @Nonnull
    public MessageBuilder a(char[] chars, int i, int i1) {
        this.ansi.a(chars, i, i1);
        return this;
    }

    @Nonnull
    public MessageBuilder a(char[] chars) {
        this.ansi.a(chars);
        return this;
    }

    @Nonnull
    public MessageBuilder a(CharSequence charSequence, int i, int i1) {
        this.ansi.a(charSequence, i, i1);
        return this;
    }

    @Nonnull
    public MessageBuilder a(CharSequence charSequence) {
        this.ansi.a(charSequence);
        return this;
    }

    @Nonnull
    public MessageBuilder a(Object o) {
        this.ansi.a(o);
        return this;
    }

    @Nonnull
    public MessageBuilder newline() {
        this.ansi.newline();
        return this;
    }

    @Nonnull
    public MessageBuilder format(String s, Object ... objects) {
        this.ansi.format(s, objects);
        return this;
    }

    @Nonnull
    public String build() {
        return this.ansi.toString();
    }

    public String toString() {
        return this.build();
    }

    public void setLength(int length) {
        this.sb.setLength(length);
    }
}

