/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ConfigurationContainer;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.ReportSet;
import org.apache.maven.api.xml.XmlNode;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class ReportPlugin
extends ConfigurationContainer
implements Serializable,
InputLocationTracker {
    final String groupId;
    final String artifactId;
    final String version;
    final List<ReportSet> reportSets;
    private Map<String, ReportSet> reportSetMap = null;

    ReportPlugin(String inherited, XmlNode configuration, String groupId, String artifactId, String version, Collection<ReportSet> reportSets, Map<Object, InputLocation> locations) {
        super(inherited, configuration, locations);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.reportSets = ImmutableCollections.copy(reportSets);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    @Nonnull
    public List<ReportSet> getReportSets() {
        return this.reportSets;
    }

    @Override
    @Nonnull
    public Builder with() {
        return ReportPlugin.newBuilder(this);
    }

    @Override
    @Nonnull
    public ReportPlugin withInherited(String inherited) {
        return ReportPlugin.newBuilder(this, true).inherited(inherited).build();
    }

    @Override
    @Nonnull
    public ReportPlugin withConfiguration(XmlNode configuration) {
        return ReportPlugin.newBuilder(this, true).configuration(configuration).build();
    }

    @Nonnull
    public ReportPlugin withGroupId(String groupId) {
        return ReportPlugin.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public ReportPlugin withArtifactId(String artifactId) {
        return ReportPlugin.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public ReportPlugin withVersion(String version) {
        return ReportPlugin.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public ReportPlugin withReportSets(Collection<ReportSet> reportSets) {
        return ReportPlugin.newBuilder(this, true).reportSets(reportSets).build();
    }

    @Nonnull
    public static ReportPlugin newInstance() {
        return ReportPlugin.newInstance(true);
    }

    @Nonnull
    public static ReportPlugin newInstance(boolean withDefaults) {
        return ReportPlugin.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return ReportPlugin.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(ReportPlugin from) {
        return ReportPlugin.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(ReportPlugin from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public void flushReportSetMap() {
        this.reportSetMap = null;
    }

    public Map<String, ReportSet> getReportSetsAsMap() {
        if (this.reportSetMap == null) {
            this.reportSetMap = new LinkedHashMap<String, ReportSet>();
            if (this.getReportSets() != null) {
                for (ReportSet reportSet : this.getReportSets()) {
                    this.reportSetMap.put(reportSet.getId(), reportSet);
                }
            }
        }
        return this.reportSetMap;
    }

    public String getKey() {
        return ReportPlugin.constructKey(this.getGroupId(), this.getArtifactId());
    }

    public static String constructKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    @NotThreadSafe
    public static class Builder
    extends ConfigurationContainer.Builder {
        ReportPlugin base;
        String groupId;
        String artifactId;
        String version;
        Collection<ReportSet> reportSets;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.groupId = "org.apache.maven.plugins";
            }
        }

        Builder(ReportPlugin base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.reportSets = base.reportSets;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder inherited(String inherited) {
            this.inherited = inherited;
            return this;
        }

        @Override
        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder reportSets(Collection<ReportSet> reportSets) {
            this.reportSets = reportSets;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public ReportPlugin build() {
            if (!(this.base == null || this.inherited != null && this.inherited != this.base.inherited || this.configuration != null && this.configuration != this.base.configuration || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.reportSets != null && this.reportSets != this.base.reportSets)) {
                return this.base;
            }
            Map newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("inherited", newlocs.containsKey("inherited") ? (InputLocation)newlocs.get("inherited") : (InputLocation)oldlocs.get("inherited"));
            locations.put("configuration", newlocs.containsKey("configuration") ? (InputLocation)newlocs.get("configuration") : (InputLocation)oldlocs.get("configuration"));
            locations.put("groupId", newlocs.containsKey("groupId") ? (InputLocation)newlocs.get("groupId") : (InputLocation)oldlocs.get("groupId"));
            locations.put("artifactId", newlocs.containsKey("artifactId") ? (InputLocation)newlocs.get("artifactId") : (InputLocation)oldlocs.get("artifactId"));
            locations.put("version", newlocs.containsKey("version") ? (InputLocation)newlocs.get("version") : (InputLocation)oldlocs.get("version"));
            locations.put("reportSets", newlocs.containsKey("reportSets") ? (InputLocation)newlocs.get("reportSets") : (InputLocation)oldlocs.get("reportSets"));
            return new ReportPlugin(this.inherited != null ? this.inherited : (this.base != null ? this.base.inherited : null), (XmlNode)(this.configuration != null ? this.configuration : (this.base != null ? this.base.configuration : null)), this.groupId != null ? this.groupId : (this.base != null ? this.base.groupId : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), this.reportSets != null ? this.reportSets : (this.base != null ? this.base.reportSets : null), locations);
        }
    }
}

