/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Plugin;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PluginContainer
implements Serializable,
InputLocationTracker {
    final List<Plugin> plugins;
    final Map<Object, InputLocation> locations;
    volatile Map<String, Plugin> pluginMap;

    PluginContainer(Collection<Plugin> plugins, Map<Object, InputLocation> locations) {
        this.plugins = ImmutableCollections.copy(plugins);
        this.locations = ImmutableCollections.copy(locations);
    }

    @Nonnull
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return PluginContainer.newBuilder(this);
    }

    @Nonnull
    public PluginContainer withPlugins(Collection<Plugin> plugins) {
        return PluginContainer.newBuilder(this, true).plugins(plugins).build();
    }

    @Nonnull
    public static PluginContainer newInstance() {
        return PluginContainer.newInstance(true);
    }

    @Nonnull
    public static PluginContainer newInstance(boolean withDefaults) {
        return PluginContainer.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PluginContainer.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PluginContainer from) {
        return PluginContainer.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PluginContainer from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Plugin> getPluginsAsMap() {
        if (this.pluginMap == null) {
            PluginContainer pluginContainer = this;
            synchronized (pluginContainer) {
                if (this.pluginMap == null) {
                    this.pluginMap = ImmutableCollections.copy(this.plugins.stream().collect(Collectors.toMap(Plugin::getKey, Function.identity())));
                }
            }
        }
        return this.pluginMap;
    }

    public String toString() {
        return "PluginContainer {}";
    }

    @NotThreadSafe
    public static class Builder {
        PluginContainer base;
        Collection<Plugin> plugins;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(PluginContainer base, boolean forceCopy) {
            if (forceCopy) {
                this.plugins = base.plugins;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public PluginContainer build() {
            if (this.base != null && (this.plugins == null || this.plugins == this.base.plugins)) {
                return this.base;
            }
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("plugins", newlocs.containsKey("plugins") ? (InputLocation)newlocs.get("plugins") : (InputLocation)oldlocs.get("plugins"));
            return new PluginContainer(this.plugins != null ? this.plugins : (this.base != null ? this.base.plugins : null), locations);
        }
    }
}

