/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Path;
import java.util.Optional;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.Source;

public interface ToolchainsBuilderRequest {
    @Nonnull
    public Session getSession();

    @Nonnull
    public Optional<Path> getGlobalToolchainsPath();

    @Nonnull
    public Optional<Source> getGlobalToolchainsSource();

    @Nonnull
    public Optional<Path> getUserToolchainsPath();

    @Nonnull
    public Optional<Source> getUserToolchainsSource();

    @Nonnull
    public static ToolchainsBuilderRequest build(@Nonnull Session session, @Nonnull Source globalToolchainsSource, @Nonnull Source userToolchainsSource) {
        return ToolchainsBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).globalToolchainsSource(BaseRequest.nonNull(globalToolchainsSource, "globalToolchainsSource cannot be null")).userToolchainsSource(BaseRequest.nonNull(userToolchainsSource, "userToolchainsSource cannot be null")).build();
    }

    @Nonnull
    public static ToolchainsBuilderRequest build(@Nonnull Session session, @Nonnull Path globalToolchainsPath, @Nonnull Path userToolchainsPath) {
        return ToolchainsBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).globalToolchainsPath(BaseRequest.nonNull(globalToolchainsPath, "globalToolchainsPath cannot be null")).userToolchainsPath(BaseRequest.nonNull(userToolchainsPath, "userToolchainsPath cannot be null")).build();
    }

    @Nonnull
    public static ToolchainsBuilderRequestBuilder builder() {
        return new ToolchainsBuilderRequestBuilder();
    }

    @NotThreadSafe
    public static class ToolchainsBuilderRequestBuilder {
        Session session;
        Path globalToolchainsPath;
        Source globalToolchainsSource;
        Path userToolchainsPath;
        Source userToolchainsSource;

        public ToolchainsBuilderRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public ToolchainsBuilderRequestBuilder globalToolchainsPath(Path globalToolchainsPath) {
            this.globalToolchainsPath = globalToolchainsPath;
            return this;
        }

        public ToolchainsBuilderRequestBuilder globalToolchainsSource(Source globalToolchainsSource) {
            this.globalToolchainsSource = globalToolchainsSource;
            return this;
        }

        public ToolchainsBuilderRequestBuilder userToolchainsPath(Path userToolchainsPath) {
            this.userToolchainsPath = userToolchainsPath;
            return this;
        }

        public ToolchainsBuilderRequestBuilder userToolchainsSource(Source userToolchainsSource) {
            this.userToolchainsSource = userToolchainsSource;
            return this;
        }

        public ToolchainsBuilderRequest build() {
            return new DefaultToolchainsBuilderRequest(this.session, this.globalToolchainsPath, this.globalToolchainsSource, this.userToolchainsPath, this.userToolchainsSource);
        }

        private static class DefaultToolchainsBuilderRequest
        extends BaseRequest
        implements ToolchainsBuilderRequest {
            private final Path globalToolchainsPath;
            private final Source globalToolchainsSource;
            private final Path userToolchainsPath;
            private final Source userToolchainsSource;

            DefaultToolchainsBuilderRequest(@Nonnull Session session, @Nullable Path globalToolchainsPath, @Nullable Source globalToolchainsSource, @Nullable Path userToolchainsPath, @Nullable Source userToolchainsSource) {
                super(session);
                this.globalToolchainsPath = globalToolchainsPath;
                this.globalToolchainsSource = globalToolchainsSource;
                this.userToolchainsPath = userToolchainsPath;
                this.userToolchainsSource = userToolchainsSource;
            }

            @Override
            @Nonnull
            public Optional<Path> getGlobalToolchainsPath() {
                return Optional.ofNullable(this.globalToolchainsPath);
            }

            @Override
            @Nonnull
            public Optional<Source> getGlobalToolchainsSource() {
                return Optional.ofNullable(this.globalToolchainsSource);
            }

            @Override
            @Nonnull
            public Optional<Path> getUserToolchainsPath() {
                return Optional.ofNullable(this.userToolchainsPath);
            }

            @Override
            @Nonnull
            public Optional<Source> getUserToolchainsSource() {
                return Optional.ofNullable(this.userToolchainsSource);
            }
        }
    }
}

