/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.legacy;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.repository.ArtifactDoesNotExistException;
import org.apache.maven.repository.ArtifactTransferFailedException;
import org.apache.maven.repository.ArtifactTransferListener;
import org.apache.maven.repository.DelegatingLocalArtifactRepository;
import org.apache.maven.repository.LocalArtifactRepository;
import org.apache.maven.repository.MirrorSelector;
import org.apache.maven.repository.Proxy;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.repository.legacy.TransferListenerAdapter;
import org.apache.maven.repository.legacy.WagonManager;
import org.apache.maven.repository.legacy.repository.ArtifactRepositoryFactory;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyUtils;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;

@Named(value="default")
@Singleton
@Deprecated
public class LegacyRepositorySystem
implements RepositorySystem {
    @Inject
    private Logger logger;
    @Inject
    private ArtifactFactory artifactFactory;
    @Inject
    private ArtifactResolver artifactResolver;
    @Inject
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Inject
    private Map<String, ArtifactRepositoryLayout> layouts;
    @Inject
    private WagonManager wagonManager;
    @Inject
    private PlexusContainer plexus;
    @Inject
    private MirrorSelector mirrorSelector;
    @Inject
    private SettingsDecrypter settingsDecrypter;

    @Override
    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type) {
        return this.artifactFactory.createArtifact(groupId, artifactId, version, scope, type);
    }

    @Override
    public Artifact createArtifact(String groupId, String artifactId, String version, String packaging) {
        return this.artifactFactory.createBuildArtifact(groupId, artifactId, version, packaging);
    }

    @Override
    public Artifact createArtifactWithClassifier(String groupId, String artifactId, String version, String type, String classifier) {
        return this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
    }

    @Override
    public Artifact createProjectArtifact(String groupId, String artifactId, String metaVersionId) {
        return this.artifactFactory.createProjectArtifact(groupId, artifactId, metaVersionId);
    }

    @Override
    public Artifact createDependencyArtifact(Dependency d) {
        VersionRange versionRange;
        try {
            versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            this.logger.error(String.format("Invalid version specification '%s' creating dependency artifact '%s'.", d.getVersion(), d), (Throwable)e);
            return null;
        }
        Artifact artifact = this.artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
        if ("system".equals(d.getScope()) && d.getSystemPath() != null) {
            artifact.setFile(new File(d.getSystemPath()));
        }
        if (!d.getExclusions().isEmpty()) {
            ArrayList<String> exclusions = new ArrayList<String>();
            for (Exclusion exclusion : d.getExclusions()) {
                exclusions.add(exclusion.getGroupId() + ':' + exclusion.getArtifactId());
            }
            artifact.setDependencyFilter((ArtifactFilter)new ExcludesArtifactFilter(exclusions));
        }
        return artifact;
    }

    public Artifact createExtensionArtifact(String groupId, String artifactId, String version) {
        VersionRange versionRange;
        try {
            versionRange = VersionRange.createFromVersionSpec((String)version);
        }
        catch (InvalidVersionSpecificationException e) {
            this.logger.error(String.format("Invalid version specification '%s' creating extension artifact '%s:%s:%s'.", version, groupId, artifactId, version), (Throwable)e);
            return null;
        }
        return this.artifactFactory.createExtensionArtifact(groupId, artifactId, versionRange);
    }

    public Artifact createParentArtifact(String groupId, String artifactId, String version) {
        return this.artifactFactory.createParentArtifact(groupId, artifactId, version);
    }

    @Override
    public Artifact createPluginArtifact(Plugin plugin) {
        VersionRange versionRange;
        String version = plugin.getVersion();
        if (version == null || version.isEmpty()) {
            version = "RELEASE";
        }
        try {
            versionRange = VersionRange.createFromVersionSpec((String)version);
        }
        catch (InvalidVersionSpecificationException e) {
            this.logger.error(String.format("Invalid version specification '%s' creating plugin artifact '%s'.", version, plugin), (Throwable)e);
            return null;
        }
        return this.artifactFactory.createPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), versionRange);
    }

    public ArtifactRepositoryPolicy buildArtifactRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String updatePolicy = null;
        String checksumPolicy = null;
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updatePolicy = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksumPolicy = policy.getChecksumPolicy();
            }
        }
        return new ArtifactRepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }

    @Override
    public ArtifactRepository createDefaultLocalRepository() throws InvalidRepositoryException {
        return this.createLocalRepository(RepositorySystem.defaultUserLocalRepository);
    }

    @Override
    public ArtifactRepository createLocalRepository(File localRepository) throws InvalidRepositoryException {
        return this.createRepository("file://" + localRepository.toURI().getRawPath(), "local", true, "always", true, "always", "ignore");
    }

    @Override
    public ArtifactRepository createDefaultRemoteRepository() throws InvalidRepositoryException {
        return this.createRepository("central", "central", true, "daily", false, "daily", "warn");
    }

    public ArtifactRepository createLocalRepository(String url, String repositoryId) throws IOException {
        return this.createRepository(this.canonicalFileUrl(url), repositoryId, true, "always", true, "always", "ignore");
    }

    private String canonicalFileUrl(String url) throws IOException {
        if (!url.startsWith("file:")) {
            url = "file://" + url;
        } else if (url.startsWith("file:") && !url.startsWith("file://")) {
            url = "file://" + url.substring("file:".length());
        }
        File localRepository = new File(url.substring("file://".length()));
        if (!localRepository.isAbsolute()) {
            url = "file://" + localRepository.getCanonicalPath();
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArtifactResolutionResult resolve(ArtifactResolutionRequest request) {
        try {
            LocalArtifactRepository ideWorkspace = (LocalArtifactRepository)((Object)this.plexus.lookup(LocalArtifactRepository.class, "ide-workspace"));
            if (request.getLocalRepository() instanceof DelegatingLocalArtifactRepository) {
                DelegatingLocalArtifactRepository delegatingLocalRepository = (DelegatingLocalArtifactRepository)request.getLocalRepository();
                LocalArtifactRepository orig = delegatingLocalRepository.getIdeWorkspace();
                delegatingLocalRepository.setIdeWorkspace(ideWorkspace);
                try {
                    ArtifactResolutionResult artifactResolutionResult = this.artifactResolver.resolve(request);
                    return artifactResolutionResult;
                }
                finally {
                    delegatingLocalRepository.setIdeWorkspace(orig);
                }
            }
            ArtifactRepository localRepository = request.getLocalRepository();
            DelegatingLocalArtifactRepository delegatingLocalRepository = new DelegatingLocalArtifactRepository(localRepository);
            delegatingLocalRepository.setIdeWorkspace(ideWorkspace);
            request.setLocalRepository((ArtifactRepository)delegatingLocalRepository);
            try {
                ArtifactResolutionResult artifactResolutionResult = this.artifactResolver.resolve(request);
                return artifactResolutionResult;
            }
            finally {
                request.setLocalRepository(localRepository);
            }
        }
        catch (ComponentLookupException componentLookupException) {
            return this.artifactResolver.resolve(request);
        }
    }

    @Override
    public List<ArtifactRepository> getEffectiveRepositories(List<ArtifactRepository> repositories) {
        if (repositories == null) {
            return null;
        }
        LinkedHashMap<String, List> reposByKey = new LinkedHashMap<String, List>();
        for (ArtifactRepository repository : repositories) {
            String key = repository.getId();
            List aliasedRepos = reposByKey.computeIfAbsent(key, k -> new ArrayList());
            aliasedRepos.add(repository);
        }
        ArrayList<ArtifactRepository> effectiveRepositories = new ArrayList<ArtifactRepository>();
        for (List aliasedRepos : reposByKey.values()) {
            ArtifactRepository aliasedRepo3;
            ArrayList mirroredRepos = new ArrayList();
            ArrayList<ArtifactRepositoryPolicy> releasePolicies = new ArrayList<ArtifactRepositoryPolicy>(aliasedRepos.size());
            for (ArtifactRepository aliasedRepo2 : aliasedRepos) {
                releasePolicies.add(aliasedRepo2.getReleases());
                mirroredRepos.addAll(aliasedRepo2.getMirroredRepositories());
            }
            ArtifactRepositoryPolicy releasePolicy = this.getEffectivePolicy(releasePolicies);
            ArrayList<ArtifactRepositoryPolicy> snapshotPolicies = new ArrayList<ArtifactRepositoryPolicy>(aliasedRepos.size());
            for (ArtifactRepository aliasedRepo3 : aliasedRepos) {
                snapshotPolicies.add(aliasedRepo3.getSnapshots());
            }
            ArtifactRepositoryPolicy snapshotPolicy = this.getEffectivePolicy(snapshotPolicies);
            aliasedRepo3 = (ArtifactRepository)aliasedRepos.get(0);
            ArtifactRepository effectiveRepository = this.createArtifactRepository(aliasedRepo3.getId(), aliasedRepo3.getUrl(), aliasedRepo3.getLayout(), snapshotPolicy, releasePolicy);
            effectiveRepository.setAuthentication(aliasedRepo3.getAuthentication());
            effectiveRepository.setProxy(aliasedRepo3.getProxy());
            effectiveRepository.setMirroredRepositories(mirroredRepos);
            effectiveRepository.setBlocked(aliasedRepo3.isBlocked());
            effectiveRepositories.add(effectiveRepository);
        }
        return effectiveRepositories;
    }

    private ArtifactRepositoryPolicy getEffectivePolicy(Collection<ArtifactRepositoryPolicy> policies) {
        ArtifactRepositoryPolicy effectivePolicy = null;
        for (ArtifactRepositoryPolicy policy : policies) {
            if (effectivePolicy == null) {
                effectivePolicy = new ArtifactRepositoryPolicy(policy);
                continue;
            }
            effectivePolicy.merge(policy);
        }
        return effectivePolicy;
    }

    @Override
    public Mirror getMirror(ArtifactRepository repository, List<Mirror> mirrors) {
        return this.mirrorSelector.getMirror(repository, mirrors);
    }

    @Override
    public void injectMirror(List<ArtifactRepository> repositories, List<Mirror> mirrors) {
        if (repositories != null && mirrors != null) {
            for (ArtifactRepository repository : repositories) {
                Mirror mirror = this.getMirror(repository, mirrors);
                this.injectMirror(repository, mirror);
            }
        }
    }

    private Mirror getMirror(RepositorySystemSession session, ArtifactRepository repository) {
        RemoteRepository repo;
        org.eclipse.aether.repository.MirrorSelector selector;
        if (session != null && (selector = session.getMirrorSelector()) != null && (repo = selector.getMirror(RepositoryUtils.toRepo((ArtifactRepository)repository))) != null) {
            Mirror mirror = new Mirror();
            mirror.setId(repo.getId());
            mirror.setUrl(repo.getUrl());
            mirror.setLayout(repo.getContentType());
            mirror.setBlocked(repo.isBlocked());
            return mirror;
        }
        return null;
    }

    @Override
    public void injectMirror(RepositorySystemSession session, List<ArtifactRepository> repositories) {
        if (repositories != null && session != null) {
            for (ArtifactRepository repository : repositories) {
                Mirror mirror = this.getMirror(session, repository);
                this.injectMirror(repository, mirror);
            }
        }
    }

    private void injectMirror(ArtifactRepository repository, Mirror mirror) {
        if (mirror != null) {
            ArtifactRepository original = this.createArtifactRepository(repository.getId(), repository.getUrl(), repository.getLayout(), repository.getSnapshots(), repository.getReleases());
            repository.setMirroredRepositories(Collections.singletonList(original));
            repository.setId(mirror.getId());
            repository.setUrl(mirror.getUrl());
            if (mirror.getLayout() != null && !mirror.getLayout().isEmpty()) {
                repository.setLayout(this.getLayout(mirror.getLayout()));
            }
            repository.setBlocked(mirror.isBlocked());
        }
    }

    @Override
    public void injectAuthentication(List<ArtifactRepository> repositories, List<Server> servers) {
        if (repositories != null) {
            HashMap<String, Server> serversById = new HashMap<String, Server>();
            if (servers != null) {
                for (Server server : servers) {
                    if (serversById.containsKey(server.getId())) continue;
                    serversById.put(server.getId(), server);
                }
            }
            for (ArtifactRepository repository : repositories) {
                Server server = (Server)serversById.get(repository.getId());
                if (server != null) {
                    DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(server);
                    SettingsDecryptionResult result = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)request);
                    server = result.getServer();
                    if (this.logger.isDebugEnabled()) {
                        for (SettingsProblem problem : result.getProblems()) {
                            this.logger.debug(problem.getMessage(), (Throwable)problem.getException());
                        }
                    }
                    org.apache.maven.artifact.repository.Authentication authentication = new org.apache.maven.artifact.repository.Authentication(server.getUsername(), server.getPassword());
                    authentication.setPrivateKey(server.getPrivateKey());
                    authentication.setPassphrase(server.getPassphrase());
                    repository.setAuthentication(authentication);
                    continue;
                }
                repository.setAuthentication(null);
            }
        }
    }

    private org.apache.maven.artifact.repository.Authentication getAuthentication(RepositorySystemSession session, ArtifactRepository repository) {
        RemoteRepository repo;
        Authentication auth;
        AuthenticationSelector selector;
        if (session != null && (selector = session.getAuthenticationSelector()) != null && (auth = selector.getAuthentication(repo = RepositoryUtils.toRepo((ArtifactRepository)repository))) != null) {
            repo = new RemoteRepository.Builder(repo).setAuthentication(auth).build();
            AuthenticationContext authCtx = AuthenticationContext.forRepository((RepositorySystemSession)session, (RemoteRepository)repo);
            org.apache.maven.artifact.repository.Authentication result = new org.apache.maven.artifact.repository.Authentication(authCtx.get("username"), authCtx.get("password"));
            result.setPrivateKey(authCtx.get("privateKey.path"));
            result.setPassphrase(authCtx.get("privateKey.passphrase"));
            authCtx.close();
            return result;
        }
        return null;
    }

    @Override
    public void injectAuthentication(RepositorySystemSession session, List<ArtifactRepository> repositories) {
        if (repositories != null && session != null) {
            for (ArtifactRepository repository : repositories) {
                repository.setAuthentication(this.getAuthentication(session, repository));
            }
        }
    }

    private org.apache.maven.settings.Proxy getProxy(ArtifactRepository repository, List<org.apache.maven.settings.Proxy> proxies) {
        if (proxies != null && repository.getProtocol() != null) {
            for (org.apache.maven.settings.Proxy proxy : proxies) {
                if (!proxy.isActive() || !repository.getProtocol().equalsIgnoreCase(proxy.getProtocol())) continue;
                if (proxy.getNonProxyHosts() != null && !proxy.getNonProxyHosts().isEmpty()) {
                    ProxyInfo pi = new ProxyInfo();
                    pi.setNonProxyHosts(proxy.getNonProxyHosts());
                    Repository repo = new Repository(repository.getId(), repository.getUrl());
                    if (ProxyUtils.validateNonProxyHosts((ProxyInfo)pi, (String)repo.getHost())) continue;
                    return proxy;
                }
                return proxy;
            }
        }
        return null;
    }

    @Override
    public void injectProxy(List<ArtifactRepository> repositories, List<org.apache.maven.settings.Proxy> proxies) {
        if (repositories != null) {
            for (ArtifactRepository repository : repositories) {
                org.apache.maven.settings.Proxy proxy = this.getProxy(repository, proxies);
                if (proxy != null) {
                    DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(proxy);
                    SettingsDecryptionResult result = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)request);
                    proxy = result.getProxy();
                    if (this.logger.isDebugEnabled()) {
                        for (SettingsProblem problem : result.getProblems()) {
                            this.logger.debug(problem.getMessage(), (Throwable)problem.getException());
                        }
                    }
                    Proxy p = new Proxy();
                    p.setHost(proxy.getHost());
                    p.setProtocol(proxy.getProtocol());
                    p.setPort(proxy.getPort());
                    p.setNonProxyHosts(proxy.getNonProxyHosts());
                    p.setUserName(proxy.getUsername());
                    p.setPassword(proxy.getPassword());
                    repository.setProxy(p);
                    continue;
                }
                repository.setProxy(null);
            }
        }
    }

    private Proxy getProxy(RepositorySystemSession session, ArtifactRepository repository) {
        RemoteRepository repo;
        org.eclipse.aether.repository.Proxy proxy;
        ProxySelector selector;
        if (session != null && (selector = session.getProxySelector()) != null && (proxy = selector.getProxy(repo = RepositoryUtils.toRepo((ArtifactRepository)repository))) != null) {
            Proxy p = new Proxy();
            p.setHost(proxy.getHost());
            p.setProtocol(proxy.getType());
            p.setPort(proxy.getPort());
            if (proxy.getAuthentication() != null) {
                repo = new RemoteRepository.Builder(repo).setProxy(proxy).build();
                AuthenticationContext authCtx = AuthenticationContext.forProxy((RepositorySystemSession)session, (RemoteRepository)repo);
                p.setUserName(authCtx.get("username"));
                p.setPassword(authCtx.get("password"));
                p.setNtlmDomain(authCtx.get("ntlm.domain"));
                p.setNtlmHost(authCtx.get("ntlm.workstation"));
                authCtx.close();
            }
            return p;
        }
        return null;
    }

    @Override
    public void injectProxy(RepositorySystemSession session, List<ArtifactRepository> repositories) {
        if (repositories != null && session != null) {
            for (ArtifactRepository repository : repositories) {
                repository.setProxy(this.getProxy(session, repository));
            }
        }
    }

    @Override
    public void retrieve(ArtifactRepository repository, File destination, String remotePath, ArtifactTransferListener transferListener) throws ArtifactTransferFailedException, ArtifactDoesNotExistException {
        try {
            this.wagonManager.getRemoteFile(repository, destination, remotePath, TransferListenerAdapter.newAdapter(transferListener), "warn", true);
        }
        catch (TransferFailedException e) {
            throw new ArtifactTransferFailedException(LegacyRepositorySystem.getMessage(e, "Error transferring artifact."), e);
        }
        catch (ResourceDoesNotExistException e) {
            throw new ArtifactDoesNotExistException(LegacyRepositorySystem.getMessage(e, "Requested artifact does not exist."), e);
        }
    }

    @Override
    public void publish(ArtifactRepository repository, File source, String remotePath, ArtifactTransferListener transferListener) throws ArtifactTransferFailedException {
        try {
            this.wagonManager.putRemoteFile(repository, source, remotePath, TransferListenerAdapter.newAdapter(transferListener));
        }
        catch (TransferFailedException e) {
            throw new ArtifactTransferFailedException(LegacyRepositorySystem.getMessage(e, "Error transferring artifact."), e);
        }
    }

    @Override
    public ArtifactRepository buildArtifactRepository(org.apache.maven.model.Repository repo) throws InvalidRepositoryException {
        if (repo != null) {
            String id = repo.getId();
            if (id == null || id.isEmpty()) {
                throw new InvalidRepositoryException("Repository identifier missing", "");
            }
            String url = repo.getUrl();
            if (url == null || url.isEmpty()) {
                throw new InvalidRepositoryException("URL missing for repository " + id, id);
            }
            ArtifactRepositoryPolicy snapshots = this.buildArtifactRepositoryPolicy(repo.getSnapshots());
            ArtifactRepositoryPolicy releases = this.buildArtifactRepositoryPolicy(repo.getReleases());
            return this.createArtifactRepository(id, url, this.getLayout(repo.getLayout()), snapshots, releases);
        }
        return null;
    }

    private ArtifactRepository createRepository(String url, String repositoryId, boolean releases, String releaseUpdates, boolean snapshots, String snapshotUpdates, String checksumPolicy) {
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(snapshots, snapshotUpdates, checksumPolicy);
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(releases, releaseUpdates, checksumPolicy);
        return this.createArtifactRepository(repositoryId, url, null, snapshotsPolicy, releasesPolicy);
    }

    @Override
    public ArtifactRepository createArtifactRepository(String repositoryId, String url, ArtifactRepositoryLayout repositoryLayout, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) {
        if (repositoryLayout == null) {
            repositoryLayout = this.layouts.get("default");
        }
        return this.artifactRepositoryFactory.createArtifactRepository(repositoryId, url, repositoryLayout, snapshots, releases);
    }

    private static String getMessage(Throwable error, String def) {
        if (error == null) {
            return def;
        }
        String msg = error.getMessage();
        if (msg != null && !msg.isEmpty()) {
            return msg;
        }
        return LegacyRepositorySystem.getMessage(error.getCause(), def);
    }

    private ArtifactRepositoryLayout getLayout(String id) {
        ArtifactRepositoryLayout layout = this.layouts.get(id);
        if (layout == null) {
            layout = new UnknownRepositoryLayout(id, this.layouts.get("default"));
        }
        return layout;
    }

    static class UnknownRepositoryLayout
    implements ArtifactRepositoryLayout {
        private final String id;
        private final ArtifactRepositoryLayout fallback;

        UnknownRepositoryLayout(String id, ArtifactRepositoryLayout fallback) {
            this.id = id;
            this.fallback = fallback;
        }

        public String getId() {
            return this.id;
        }

        public String pathOf(Artifact artifact) {
            return this.fallback.pathOf(artifact);
        }

        public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
            return this.fallback.pathOfLocalRepositoryMetadata(metadata, repository);
        }

        public String pathOfRemoteRepositoryMetadata(ArtifactMetadata metadata) {
            return this.fallback.pathOfRemoteRepositoryMetadata(metadata);
        }

        public String toString() {
            return this.getId();
        }
    }
}

