/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.settings.BaseObject;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.TrackableBase;
import org.apache.maven.settings.WrapperList;

@Generated
public class Settings
extends TrackableBase
implements Serializable,
Cloneable {
    private Proxy activeProxy;
    private Map<String, Profile> profileMap;

    public Settings() {
        this(org.apache.maven.api.settings.Settings.newInstance());
    }

    public Settings(org.apache.maven.api.settings.Settings delegate) {
        this(delegate, (BaseObject)null);
    }

    public Settings(org.apache.maven.api.settings.Settings delegate, BaseObject parent) {
        super((org.apache.maven.api.settings.TrackableBase)delegate, parent);
    }

    @Override
    public Settings clone() {
        return new Settings(this.getDelegate());
    }

    public org.apache.maven.api.settings.Settings getDelegate() {
        return (org.apache.maven.api.settings.Settings)super.getDelegate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Settings)) {
            return false;
        }
        Settings that = (Settings)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public String getModelEncoding() {
        return this.getDelegate().getModelEncoding();
    }

    public String getLocalRepository() {
        return this.getDelegate().getLocalRepository();
    }

    public void setLocalRepository(String localRepository) {
        if (!Objects.equals(localRepository, this.getLocalRepository())) {
            this.update(this.getDelegate().withLocalRepository(localRepository));
        }
    }

    public boolean isInteractiveMode() {
        return this.getDelegate().isInteractiveMode();
    }

    public void setInteractiveMode(boolean interactiveMode) {
        if (!Objects.equals(interactiveMode, this.isInteractiveMode())) {
            this.update(this.getDelegate().withInteractiveMode(interactiveMode));
        }
    }

    public boolean isUsePluginRegistry() {
        return this.getDelegate().isUsePluginRegistry();
    }

    public void setUsePluginRegistry(boolean usePluginRegistry) {
        if (!Objects.equals(usePluginRegistry, this.isUsePluginRegistry())) {
            this.update(this.getDelegate().withUsePluginRegistry(usePluginRegistry));
        }
    }

    public boolean isOffline() {
        return this.getDelegate().isOffline();
    }

    public void setOffline(boolean offline) {
        if (!Objects.equals(offline, this.isOffline())) {
            this.update(this.getDelegate().withOffline(offline));
        }
    }

    @Nonnull
    public List<Proxy> getProxies() {
        return new WrapperList<Proxy, org.apache.maven.api.settings.Proxy>(() -> this.getDelegate().getProxies(), l -> this.update(this.getDelegate().withProxies((Collection)l)), d -> new Proxy((org.apache.maven.api.settings.Proxy)d, (BaseObject)this), Proxy::getDelegate);
    }

    public void setProxies(List<Proxy> proxies) {
        if (proxies == null) {
            proxies = Collections.emptyList();
        }
        if (!Objects.equals(proxies, this.getProxies())) {
            this.update(this.getDelegate().withProxies((Collection)proxies.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            proxies.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addProxy(Proxy proxy) {
        this.update(this.getDelegate().withProxies((Collection)Stream.concat(this.getDelegate().getProxies().stream(), Stream.of(proxy.getDelegate())).collect(Collectors.toList())));
        proxy.childrenTracking = this::replace;
    }

    public void removeProxy(Proxy proxy) {
        this.update(this.getDelegate().withProxies((Collection)this.getDelegate().getProxies().stream().filter(e -> !Objects.equals(e, proxy)).collect(Collectors.toList())));
        proxy.childrenTracking = null;
    }

    @Nonnull
    public List<Server> getServers() {
        return new WrapperList<Server, org.apache.maven.api.settings.Server>(() -> this.getDelegate().getServers(), l -> this.update(this.getDelegate().withServers((Collection)l)), d -> new Server((org.apache.maven.api.settings.Server)d, (BaseObject)this), Server::getDelegate);
    }

    public void setServers(List<Server> servers) {
        if (servers == null) {
            servers = Collections.emptyList();
        }
        if (!Objects.equals(servers, this.getServers())) {
            this.update(this.getDelegate().withServers((Collection)servers.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            servers.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addServer(Server server) {
        this.update(this.getDelegate().withServers((Collection)Stream.concat(this.getDelegate().getServers().stream(), Stream.of(server.getDelegate())).collect(Collectors.toList())));
        server.childrenTracking = this::replace;
    }

    public void removeServer(Server server) {
        this.update(this.getDelegate().withServers((Collection)this.getDelegate().getServers().stream().filter(e -> !Objects.equals(e, server)).collect(Collectors.toList())));
        server.childrenTracking = null;
    }

    @Nonnull
    public List<Mirror> getMirrors() {
        return new WrapperList<Mirror, org.apache.maven.api.settings.Mirror>(() -> this.getDelegate().getMirrors(), l -> this.update(this.getDelegate().withMirrors((Collection)l)), d -> new Mirror((org.apache.maven.api.settings.Mirror)d, (BaseObject)this), Mirror::getDelegate);
    }

    public void setMirrors(List<Mirror> mirrors) {
        if (mirrors == null) {
            mirrors = Collections.emptyList();
        }
        if (!Objects.equals(mirrors, this.getMirrors())) {
            this.update(this.getDelegate().withMirrors((Collection)mirrors.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            mirrors.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addMirror(Mirror mirror) {
        this.update(this.getDelegate().withMirrors((Collection)Stream.concat(this.getDelegate().getMirrors().stream(), Stream.of(mirror.getDelegate())).collect(Collectors.toList())));
        mirror.childrenTracking = this::replace;
    }

    public void removeMirror(Mirror mirror) {
        this.update(this.getDelegate().withMirrors((Collection)this.getDelegate().getMirrors().stream().filter(e -> !Objects.equals(e, mirror)).collect(Collectors.toList())));
        mirror.childrenTracking = null;
    }

    @Nonnull
    public List<Repository> getRepositories() {
        return new WrapperList<Repository, org.apache.maven.api.settings.Repository>(() -> this.getDelegate().getRepositories(), l -> this.update(this.getDelegate().withRepositories((Collection)l)), d -> new Repository((org.apache.maven.api.settings.Repository)d, (BaseObject)this), Repository::getDelegate);
    }

    public void setRepositories(List<Repository> repositories) {
        if (repositories == null) {
            repositories = Collections.emptyList();
        }
        if (!Objects.equals(repositories, this.getRepositories())) {
            this.update(this.getDelegate().withRepositories((Collection)repositories.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            repositories.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addRepository(Repository repository) {
        this.update(this.getDelegate().withRepositories((Collection)Stream.concat(this.getDelegate().getRepositories().stream(), Stream.of(repository.getDelegate())).collect(Collectors.toList())));
        repository.childrenTracking = this::replace;
    }

    public void removeRepository(Repository repository) {
        this.update(this.getDelegate().withRepositories((Collection)this.getDelegate().getRepositories().stream().filter(e -> !Objects.equals(e, repository)).collect(Collectors.toList())));
        repository.childrenTracking = null;
    }

    @Nonnull
    public List<Repository> getPluginRepositories() {
        return new WrapperList<Repository, org.apache.maven.api.settings.Repository>(() -> this.getDelegate().getPluginRepositories(), l -> this.update(this.getDelegate().withPluginRepositories((Collection)l)), d -> new Repository((org.apache.maven.api.settings.Repository)d, (BaseObject)this), Repository::getDelegate);
    }

    public void setPluginRepositories(List<Repository> pluginRepositories) {
        if (pluginRepositories == null) {
            pluginRepositories = Collections.emptyList();
        }
        if (!Objects.equals(pluginRepositories, this.getPluginRepositories())) {
            this.update(this.getDelegate().withPluginRepositories((Collection)pluginRepositories.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            pluginRepositories.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addPluginRepository(Repository pluginRepository) {
        this.update(this.getDelegate().withPluginRepositories((Collection)Stream.concat(this.getDelegate().getPluginRepositories().stream(), Stream.of(pluginRepository.getDelegate())).collect(Collectors.toList())));
        pluginRepository.childrenTracking = this::replace;
    }

    public void removePluginRepository(Repository pluginRepository) {
        this.update(this.getDelegate().withPluginRepositories((Collection)this.getDelegate().getPluginRepositories().stream().filter(e -> !Objects.equals(e, pluginRepository)).collect(Collectors.toList())));
        pluginRepository.childrenTracking = null;
    }

    @Nonnull
    public List<Profile> getProfiles() {
        return new WrapperList<Profile, org.apache.maven.api.settings.Profile>(() -> this.getDelegate().getProfiles(), l -> this.update(this.getDelegate().withProfiles((Collection)l)), d -> new Profile((org.apache.maven.api.settings.Profile)d, (BaseObject)this), Profile::getDelegate);
    }

    public void setProfiles(List<Profile> profiles) {
        if (profiles == null) {
            profiles = Collections.emptyList();
        }
        if (!Objects.equals(profiles, this.getProfiles())) {
            this.update(this.getDelegate().withProfiles((Collection)profiles.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            profiles.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addProfile(Profile profile) {
        this.update(this.getDelegate().withProfiles((Collection)Stream.concat(this.getDelegate().getProfiles().stream(), Stream.of(profile.getDelegate())).collect(Collectors.toList())));
        profile.childrenTracking = this::replace;
    }

    public void removeProfile(Profile profile) {
        this.update(this.getDelegate().withProfiles((Collection)this.getDelegate().getProfiles().stream().filter(e -> !Objects.equals(e, profile)).collect(Collectors.toList())));
        profile.childrenTracking = null;
    }

    @Nonnull
    public List<String> getActiveProfiles() {
        return new WrapperList<String, String>(() -> this.getDelegate().getActiveProfiles(), this::setActiveProfiles, s -> s, s -> s);
    }

    public void setActiveProfiles(List<String> activeProfiles) {
        if (!Objects.equals(activeProfiles, this.getActiveProfiles())) {
            this.update(this.getDelegate().withActiveProfiles(activeProfiles));
        }
    }

    public void addActiveProfile(String activeProfile) {
        this.update(this.getDelegate().withActiveProfiles((Collection)Stream.concat(this.getDelegate().getActiveProfiles().stream(), Stream.of(activeProfile)).collect(Collectors.toList())));
    }

    public void removeActiveProfile(String activeProfile) {
        this.update(this.getDelegate().withActiveProfiles((Collection)this.getDelegate().getActiveProfiles().stream().filter(e -> !Objects.equals(e, activeProfile)).collect(Collectors.toList())));
    }

    @Nonnull
    public List<String> getPluginGroups() {
        return new WrapperList<String, String>(() -> this.getDelegate().getPluginGroups(), this::setPluginGroups, s -> s, s -> s);
    }

    public void setPluginGroups(List<String> pluginGroups) {
        if (!Objects.equals(pluginGroups, this.getPluginGroups())) {
            this.update(this.getDelegate().withPluginGroups(pluginGroups));
        }
    }

    public void addPluginGroup(String pluginGroup) {
        this.update(this.getDelegate().withPluginGroups((Collection)Stream.concat(this.getDelegate().getPluginGroups().stream(), Stream.of(pluginGroup)).collect(Collectors.toList())));
    }

    public void removePluginGroup(String pluginGroup) {
        this.update(this.getDelegate().withPluginGroups((Collection)this.getDelegate().getPluginGroups().stream().filter(e -> !Objects.equals(e, pluginGroup)).collect(Collectors.toList())));
    }

    @Override
    protected boolean replace(Object oldDelegate, Object newDelegate) {
        if (super.replace(oldDelegate, newDelegate)) {
            return true;
        }
        if (this.getDelegate().getProxies().contains(oldDelegate)) {
            ArrayList list = new ArrayList(this.getDelegate().getProxies());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.settings.Proxy)newDelegate : d);
            this.update(this.getDelegate().withProxies(list));
            return true;
        }
        if (this.getDelegate().getServers().contains(oldDelegate)) {
            ArrayList list = new ArrayList(this.getDelegate().getServers());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.settings.Server)newDelegate : d);
            this.update(this.getDelegate().withServers(list));
            return true;
        }
        if (this.getDelegate().getMirrors().contains(oldDelegate)) {
            ArrayList list = new ArrayList(this.getDelegate().getMirrors());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.settings.Mirror)newDelegate : d);
            this.update(this.getDelegate().withMirrors(list));
            return true;
        }
        if (this.getDelegate().getRepositories().contains(oldDelegate)) {
            ArrayList list = new ArrayList(this.getDelegate().getRepositories());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.settings.Repository)newDelegate : d);
            this.update(this.getDelegate().withRepositories(list));
            return true;
        }
        if (this.getDelegate().getPluginRepositories().contains(oldDelegate)) {
            ArrayList list = new ArrayList(this.getDelegate().getPluginRepositories());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.settings.Repository)newDelegate : d);
            this.update(this.getDelegate().withPluginRepositories(list));
            return true;
        }
        if (this.getDelegate().getProfiles().contains(oldDelegate)) {
            ArrayList list = new ArrayList(this.getDelegate().getProfiles());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.settings.Profile)newDelegate : d);
            this.update(this.getDelegate().withProfiles(list));
            return true;
        }
        return false;
    }

    public static List<org.apache.maven.api.settings.Settings> settingsToApiV4(List<Settings> list) {
        return list != null ? new WrapperList<org.apache.maven.api.settings.Settings, Settings>(list, Settings::getDelegate, Settings::new) : null;
    }

    public static List<Settings> settingsToApiV3(List<org.apache.maven.api.settings.Settings> list) {
        return list != null ? new WrapperList<Settings, org.apache.maven.api.settings.Settings>(list, Settings::new, Settings::getDelegate) : null;
    }

    public Boolean getInteractiveMode() {
        return this.isInteractiveMode();
    }

    public void flushActiveProxy() {
        this.activeProxy = null;
    }

    public synchronized Proxy getActiveProxy() {
        List<Proxy> proxies;
        if (this.activeProxy == null && (proxies = this.getProxies()) != null && !proxies.isEmpty()) {
            for (Proxy proxy : proxies) {
                if (!proxy.isActive()) continue;
                this.activeProxy = proxy;
                break;
            }
        }
        return this.activeProxy;
    }

    public Server getServer(String serverId) {
        Server match = null;
        List<Server> servers = this.getServers();
        if (servers != null && serverId != null) {
            for (Server server : servers) {
                if (!serverId.equals(server.getId())) continue;
                match = server;
                break;
            }
        }
        return match;
    }

    @Deprecated
    public Mirror getMirrorOf(String repositoryId) {
        Mirror match = null;
        List<Mirror> mirrors = this.getMirrors();
        if (mirrors != null && repositoryId != null) {
            for (Mirror mirror : mirrors) {
                if (!repositoryId.equals(mirror.getMirrorOf())) continue;
                match = mirror;
                break;
            }
        }
        return match;
    }

    public void flushProfileMap() {
        this.profileMap = null;
    }

    public Map<String, Profile> getProfilesAsMap() {
        if (this.profileMap == null) {
            this.profileMap = new LinkedHashMap<String, Profile>();
            if (this.getProfiles() != null) {
                for (Profile profile : this.getProfiles()) {
                    this.profileMap.put(profile.getId(), profile);
                }
            }
        }
        return this.profileMap;
    }
}

