/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.toolchain.DefaultToolchainManager;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.ToolchainFactory;
import org.apache.maven.toolchain.ToolchainManagerPrivate;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.slf4j.Logger;

@Named
@Singleton
public class DefaultToolchainManagerPrivate
extends DefaultToolchainManager
implements ToolchainManagerPrivate {
    @Inject
    public DefaultToolchainManagerPrivate(Map<String, ToolchainFactory> factories) {
        super(factories);
    }

    DefaultToolchainManagerPrivate(Map<String, ToolchainFactory> factories, Logger logger) {
        super(factories, logger);
    }

    @Override
    public ToolchainPrivate[] getToolchainsForType(String type, MavenSession session) throws MisconfiguredToolchainException {
        ArrayList<ToolchainPrivate> toRet = new ArrayList<ToolchainPrivate>();
        ToolchainFactory fact = (ToolchainFactory)this.factories.get(type);
        if (fact == null) {
            this.logger.error("Missing toolchain factory for type: " + type + ". Possibly caused by misconfigured project.");
        } else {
            ToolchainPrivate tool;
            List availableToolchains = ToolchainModel.toolchainModelToApiV4(session.getRequest().getToolchains().get(type));
            if (availableToolchains != null) {
                for (org.apache.maven.api.toolchain.ToolchainModel toolchainModel : availableToolchains) {
                    ToolchainModel tm = new ToolchainModel(toolchainModel);
                    toRet.add(fact.createToolchain(tm));
                }
            }
            if ((tool = fact.createDefaultToolchain()) != null) {
                toRet.add(tool);
            }
        }
        return toRet.toArray(new ToolchainPrivate[0]);
    }

    @Override
    public void storeToolchainToBuildContext(ToolchainPrivate toolchain, MavenSession session) {
        Map<String, Object> context = this.retrieveContext(session);
        context.put(DefaultToolchainManagerPrivate.getStorageKey(toolchain.getType()), toolchain.getModel());
    }
}

