/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.handler.manager;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;

@Named
@Singleton
public class DefaultArtifactHandlerManager
implements ArtifactHandlerManager {
    private final Map<String, ArtifactHandler> artifactHandlers;
    private final Map<String, ArtifactHandler> allHandlers = new ConcurrentHashMap<String, ArtifactHandler>();

    @Inject
    public DefaultArtifactHandlerManager(Map<String, ArtifactHandler> artifactHandlers) {
        this.artifactHandlers = artifactHandlers;
    }

    @Override
    public ArtifactHandler getArtifactHandler(String type) {
        ArtifactHandler handler = this.allHandlers.get(type);
        if (handler == null) {
            handler = this.artifactHandlers.get(type);
            if (handler == null) {
                handler = new DefaultArtifactHandler(type);
            } else {
                this.allHandlers.put(type, handler);
            }
        }
        return handler;
    }

    @Override
    public void addHandlers(Map<String, ArtifactHandler> handlers) {
        this.allHandlers.putAll(handlers);
    }

    @Deprecated
    public Set<String> getHandlerTypes() {
        return this.artifactHandlers.keySet();
    }
}

