/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.path;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.Reporting;
import org.apache.maven.api.model.Resource;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.path.ModelPathTranslator;
import org.apache.maven.model.path.PathTranslator;

@Named
@Singleton
public class DefaultModelPathTranslator
implements ModelPathTranslator {
    private final PathTranslator pathTranslator;

    @Inject
    public DefaultModelPathTranslator(PathTranslator pathTranslator) {
        this.pathTranslator = pathTranslator;
    }

    @Override
    public void alignToBaseDirectory(Model modelV3, File basedir, ModelBuildingRequest request) {
        if (modelV3 == null || basedir == null) {
            return;
        }
        org.apache.maven.api.model.Model model = modelV3.getDelegate();
        Build build = model.getBuild();
        Build newBuild = null;
        if (build != null) {
            newBuild = Build.newBuilder((Build)build).directory(this.alignToBaseDirectory(build.getDirectory(), basedir)).sourceDirectory(this.alignToBaseDirectory(build.getSourceDirectory(), basedir)).testSourceDirectory(this.alignToBaseDirectory(build.getTestSourceDirectory(), basedir)).scriptSourceDirectory(this.alignToBaseDirectory(build.getScriptSourceDirectory(), basedir)).resources(this.map(build.getResources(), r -> this.alignToBaseDirectory((Resource)r, basedir))).testResources(this.map(build.getTestResources(), r -> this.alignToBaseDirectory((Resource)r, basedir))).filters(this.map(build.getFilters(), s -> this.alignToBaseDirectory((String)s, basedir))).outputDirectory(this.alignToBaseDirectory(build.getOutputDirectory(), basedir)).testOutputDirectory(this.alignToBaseDirectory(build.getTestOutputDirectory(), basedir)).build();
        }
        Reporting reporting = model.getReporting();
        Reporting newReporting = null;
        if (reporting != null) {
            newReporting = Reporting.newBuilder((Reporting)reporting).outputDirectory(this.alignToBaseDirectory(reporting.getOutputDirectory(), basedir)).build();
        }
        if (newBuild != build || newReporting != reporting) {
            modelV3.update((Object)org.apache.maven.api.model.Model.newBuilder((org.apache.maven.api.model.Model)model).build(newBuild).reporting(newReporting).build());
        }
    }

    private <T> List<T> map(List<T> resources, Function<T, T> mapper) {
        ArrayList<T> newResources = null;
        if (resources != null) {
            for (int i = 0; i < resources.size(); ++i) {
                T resource = resources.get(i);
                T newResource = mapper.apply(resource);
                if (newResource == null) continue;
                if (newResources == null) {
                    newResources = new ArrayList<T>(resources);
                }
                newResources.set(i, newResource);
            }
        }
        return newResources;
    }

    private Resource alignToBaseDirectory(Resource resource, File basedir) {
        String newDir;
        if (resource != null && (newDir = this.alignToBaseDirectory(resource.getDirectory(), basedir)) != null) {
            return resource.withDirectory(newDir);
        }
        return resource;
    }

    private String alignToBaseDirectory(String path, File basedir) {
        String newPath = this.pathTranslator.alignToBaseDirectory(path, basedir);
        return Objects.equals(path, newPath) ? null : newPath;
    }
}

