/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.locator;

import java.io.File;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.locator.ModelLocator;

@Named
@Singleton
public class DefaultModelLocator
implements ModelLocator {
    @Override
    public File locatePom(File projectDirectory) {
        return projectDirectory != null ? projectDirectory : new File(".");
    }

    @Override
    public File locateExistingPom(File project) {
        if (project == null || project.isDirectory()) {
            project = this.locatePom(project);
        }
        if (project.isDirectory()) {
            File pom = new File(project, "pom.xml");
            return pom.isFile() ? pom : null;
        }
        if (project.isFile()) {
            return project;
        }
        return null;
    }
}

