/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectExecutionEvent;
import org.apache.maven.execution.ProjectExecutionListener;
import org.apache.maven.internal.transformation.ConsumerPomArtifactTransformer;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.CompoundProjectExecutionListener;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.MojoExecutor;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.session.scope.internal.SessionScope;

@Named
@Singleton
public class LifecycleModuleBuilder {
    private final MojoExecutor mojoExecutor;
    private final BuilderCommon builderCommon;
    private final ExecutionEventCatapult eventCatapult;
    private final ProjectExecutionListener projectExecutionListener;
    private final ConsumerPomArtifactTransformer consumerPomArtifactTransformer;
    private final SessionScope sessionScope;

    @Inject
    public LifecycleModuleBuilder(MojoExecutor mojoExecutor, BuilderCommon builderCommon, ExecutionEventCatapult eventCatapult, List<ProjectExecutionListener> listeners, ConsumerPomArtifactTransformer consumerPomArtifactTransformer, SessionScope sessionScope) {
        this.mojoExecutor = mojoExecutor;
        this.builderCommon = builderCommon;
        this.eventCatapult = eventCatapult;
        this.projectExecutionListener = new CompoundProjectExecutionListener(listeners);
        this.consumerPomArtifactTransformer = consumerPomArtifactTransformer;
        this.sessionScope = sessionScope;
    }

    public void buildProject(MavenSession session, ReactorContext reactorContext, MavenProject currentProject, TaskSegment taskSegment) {
        this.buildProject(session, session, reactorContext, currentProject, taskSegment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildProject(MavenSession session, MavenSession rootSession, ReactorContext reactorContext, MavenProject currentProject, TaskSegment taskSegment) {
        session.setCurrentProject(currentProject);
        long buildStartTime = System.currentTimeMillis();
        try {
            if (reactorContext.getReactorBuildStatus().isHaltedOrBlacklisted(currentProject)) {
                this.eventCatapult.fire(ExecutionEvent.Type.ProjectSkipped, session, null);
                return;
            }
            this.consumerPomArtifactTransformer.injectTransformedArtifacts(currentProject, session.getRepositorySession());
            BuilderCommon.attachToThread(currentProject);
            this.projectExecutionListener.beforeProjectExecution(new ProjectExecutionEvent(session, currentProject));
            this.eventCatapult.fire(ExecutionEvent.Type.ProjectStarted, session, null);
            MavenExecutionPlan executionPlan = this.builderCommon.resolveBuildPlan(session, currentProject, taskSegment, new HashSet<Artifact>());
            List<MojoExecution> mojoExecutions = executionPlan.getMojoExecutions();
            this.projectExecutionListener.beforeProjectLifecycleExecution(new ProjectExecutionEvent(session, currentProject, mojoExecutions));
            this.mojoExecutor.execute(session, mojoExecutions, reactorContext.getProjectIndex());
            long buildEndTime = System.currentTimeMillis();
            this.projectExecutionListener.afterProjectExecutionSuccess(new ProjectExecutionEvent(session, currentProject, mojoExecutions));
            reactorContext.getResult().addBuildSummary(new BuildSuccess(currentProject, buildEndTime - buildStartTime));
            this.eventCatapult.fire(ExecutionEvent.Type.ProjectSucceeded, session, null);
        }
        catch (Throwable t) {
            this.builderCommon.handleBuildError(reactorContext, rootSession, session, currentProject, t, buildStartTime);
            this.projectExecutionListener.afterProjectExecutionFailure(new ProjectExecutionEvent(session, currentProject, t));
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
        }
        finally {
            session.setCurrentProject(null);
            Thread.currentThread().setContextClassLoader(reactorContext.getOriginalContextClassLoader());
        }
    }
}

