/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ProjectSegment;
import org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class LifecycleDebugLogger {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void debug(String s) {
        this.logger.debug(s);
    }

    public void info(String s) {
        this.logger.info(s);
    }

    public void debugReactorPlan(ProjectBuildList projectBuilds) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        this.logger.debug("=== REACTOR BUILD PLAN ================================================");
        Iterator<ProjectSegment> it = projectBuilds.iterator();
        while (it.hasNext()) {
            ProjectSegment projectBuild = it.next();
            this.logger.debug("Project: " + projectBuild.getProject().getId());
            this.logger.debug("Tasks:   " + projectBuild.getTaskSegment().getTasks());
            this.logger.debug("Style:   " + (projectBuild.getTaskSegment().isAggregating() ? "Aggregating" : "Regular"));
            if (!it.hasNext()) continue;
            this.logger.debug("-----------------------------------------------------------------------");
        }
        this.logger.debug("=======================================================================");
    }

    public void debugProjectPlan(MavenProject currentProject, MavenExecutionPlan executionPlan) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        this.logger.debug("=== PROJECT BUILD PLAN ================================================");
        this.logger.debug("Project:       " + BuilderCommon.getKey(currentProject));
        this.debugDependencyRequirements(executionPlan.getMojoExecutions());
        this.logger.debug("Repositories (dependencies): " + currentProject.getRemoteProjectRepositories());
        this.logger.debug("Repositories (plugins)     : " + currentProject.getRemotePluginRepositories());
        for (ExecutionPlanItem mojoExecution : executionPlan) {
            this.debugMojoExecution(mojoExecution.getMojoExecution());
        }
        this.logger.debug("=======================================================================");
    }

    private void debugMojoExecution(MojoExecution mojoExecution) {
        String mojoExecId = mojoExecution.getGroupId() + ':' + mojoExecution.getArtifactId() + ':' + mojoExecution.getVersion() + ':' + mojoExecution.getGoal() + " (" + mojoExecution.getExecutionId() + ')';
        Map<String, List<MojoExecution>> forkedExecutions = mojoExecution.getForkedExecutions();
        if (!forkedExecutions.isEmpty()) {
            for (Map.Entry<String, List<MojoExecution>> fork : forkedExecutions.entrySet()) {
                this.logger.debug("--- init fork of " + fork.getKey() + " for " + mojoExecId + " ---");
                this.debugDependencyRequirements(fork.getValue());
                for (MojoExecution forkedExecution : fork.getValue()) {
                    this.debugMojoExecution(forkedExecution);
                }
                this.logger.debug("--- exit fork of " + fork.getKey() + " for " + mojoExecId + " ---");
            }
        }
        this.logger.debug("-----------------------------------------------------------------------");
        this.logger.debug("Goal:          " + mojoExecId);
        this.logger.debug("Style:         " + (mojoExecution.getMojoDescriptor().isAggregator() ? "Aggregating" : "Regular"));
        this.logger.debug("Configuration: " + mojoExecution.getConfiguration());
    }

    private void debugDependencyRequirements(List<MojoExecution> mojoExecutions) {
        TreeSet<String> scopesToCollect = new TreeSet<String>();
        TreeSet<String> scopesToResolve = new TreeSet<String>();
        for (MojoExecution mojoExecution : mojoExecutions) {
            String scopeToResolve;
            MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
            String scopeToCollect = mojoDescriptor.getDependencyCollectionRequired();
            if (scopeToCollect != null && !scopeToCollect.isEmpty()) {
                scopesToCollect.add(scopeToCollect);
            }
            if ((scopeToResolve = mojoDescriptor.getDependencyResolutionRequired()) == null || scopeToResolve.isEmpty()) continue;
            scopesToResolve.add(scopeToResolve);
        }
        this.logger.debug("Dependencies (collect): " + scopesToCollect);
        this.logger.debug("Dependencies (resolve): " + scopesToResolve);
    }
}

