/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.Type;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.TypeRegistry;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.internal.impl.Utils;

@Named
@Singleton
public class DefaultTypeRegistry
implements TypeRegistry {
    private final ArtifactHandlerManager manager;

    @Inject
    public DefaultTypeRegistry(ArtifactHandlerManager manager) {
        this.manager = Utils.nonNull(manager, "artifactHandlerManager");
    }

    @Nonnull
    public Type getType(final String id) {
        ArtifactHandler handler = this.manager.getArtifactHandler(Utils.nonNull(id, "id"));
        final String extension = handler.getExtension();
        final String classifier = handler.getClassifier();
        final boolean includeDependencies = handler.isIncludesDependencies();
        final boolean addedToClasspath = handler.isAddedToClasspath();
        return new Type(){

            public String getId() {
                return id;
            }

            public String getExtension() {
                return extension;
            }

            public String getClassifier() {
                return classifier;
            }

            public boolean isIncludesDependencies() {
                return includeDependencies;
            }

            public boolean isAddedToClasspath() {
                return addedToClasspath;
            }
        };
    }
}

