/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.nio.file.Path;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.services.LocalRepositoryManager;
import org.apache.maven.internal.impl.DefaultSession;
import org.eclipse.aether.repository.LocalRepository;

@Named
@Singleton
public class DefaultLocalRepositoryManager
implements LocalRepositoryManager {
    public Path getPathForLocalArtifact(Session session, org.apache.maven.api.LocalRepository local, Artifact artifact) {
        DefaultSession s = (DefaultSession)session;
        String path = this.getManager(s, local).getPathForLocalArtifact(s.toArtifact(artifact));
        return local.getPath().resolve(path);
    }

    public Path getPathForRemoteArtifact(Session session, org.apache.maven.api.LocalRepository local, RemoteRepository remote, Artifact artifact) {
        DefaultSession s = (DefaultSession)session;
        String path = this.getManager(s, local).getPathForRemoteArtifact(s.toArtifact(artifact), s.toRepository(remote), null);
        return local.getPath().resolve(path);
    }

    private org.eclipse.aether.repository.LocalRepositoryManager getManager(DefaultSession session, org.apache.maven.api.LocalRepository local) {
        LocalRepository repository = session.toRepository(local);
        if ("enhanced".equals(repository.getContentType())) {
            repository = new LocalRepository(repository.getBasedir(), "");
        }
        return session.getRepositorySystem().newLocalRepositoryManager(session.getSession(), repository);
    }
}

