/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.artifact.repository.metadata.BaseObject;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.WrapperList;
import org.apache.maven.artifact.repository.metadata.v4.SnapshotVersion;

@Generated
public class Versioning
extends BaseObject {
    public Versioning() {
        this(org.apache.maven.artifact.repository.metadata.v4.Versioning.newInstance());
    }

    public Versioning(org.apache.maven.artifact.repository.metadata.v4.Versioning delegate) {
        this(delegate, null);
    }

    public Versioning(org.apache.maven.artifact.repository.metadata.v4.Versioning delegate, BaseObject parent) {
        super((Object)delegate, parent);
    }

    public Versioning clone() {
        return new Versioning(this.getDelegate());
    }

    @Override
    public org.apache.maven.artifact.repository.metadata.v4.Versioning getDelegate() {
        return (org.apache.maven.artifact.repository.metadata.v4.Versioning)super.getDelegate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Versioning)) {
            return false;
        }
        Versioning that = (Versioning)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public String getLatest() {
        return this.getDelegate().getLatest();
    }

    public void setLatest(String latest) {
        if (!Objects.equals(latest, this.getLatest())) {
            this.update(this.getDelegate().withLatest(latest));
        }
    }

    public String getRelease() {
        return this.getDelegate().getRelease();
    }

    public void setRelease(String release) {
        if (!Objects.equals(release, this.getRelease())) {
            this.update(this.getDelegate().withRelease(release));
        }
    }

    @Nonnull
    public List<String> getVersions() {
        return new WrapperList<String, String>(() -> this.getDelegate().getVersions(), this::setVersions, s -> s, s -> s);
    }

    public void setVersions(List<String> versions) {
        if (!Objects.equals(versions, this.getVersions())) {
            this.update(this.getDelegate().withVersions(versions));
        }
    }

    public void addVersion(String version) {
        this.update(this.getDelegate().withVersions(Stream.concat(this.getDelegate().getVersions().stream(), Stream.of(version)).collect(Collectors.toList())));
    }

    public void removeVersion(String version) {
        this.update(this.getDelegate().withVersions(this.getDelegate().getVersions().stream().filter(e -> !Objects.equals(e, version)).collect(Collectors.toList())));
    }

    public String getLastUpdated() {
        return this.getDelegate().getLastUpdated();
    }

    public void setLastUpdated(String lastUpdated) {
        if (!Objects.equals(lastUpdated, this.getLastUpdated())) {
            this.update(this.getDelegate().withLastUpdated(lastUpdated));
        }
    }

    public Snapshot getSnapshot() {
        return this.getDelegate().getSnapshot() != null ? new Snapshot(this.getDelegate().getSnapshot(), (BaseObject)this) : null;
    }

    public void setSnapshot(Snapshot snapshot) {
        if (!Objects.equals(snapshot, this.getSnapshot())) {
            if (snapshot != null) {
                this.update(this.getDelegate().withSnapshot(snapshot.getDelegate()));
                snapshot.childrenTracking = this::replace;
            } else {
                this.update(this.getDelegate().withSnapshot(null));
            }
        }
    }

    @Nonnull
    public List<org.apache.maven.artifact.repository.metadata.SnapshotVersion> getSnapshotVersions() {
        return new WrapperList<org.apache.maven.artifact.repository.metadata.SnapshotVersion, SnapshotVersion>(() -> this.getDelegate().getSnapshotVersions(), l -> this.update(this.getDelegate().withSnapshotVersions((Collection<SnapshotVersion>)l)), d -> new org.apache.maven.artifact.repository.metadata.SnapshotVersion((SnapshotVersion)d, (BaseObject)this), org.apache.maven.artifact.repository.metadata.SnapshotVersion::getDelegate);
    }

    public void setSnapshotVersions(List<org.apache.maven.artifact.repository.metadata.SnapshotVersion> snapshotVersions) {
        if (snapshotVersions == null) {
            snapshotVersions = Collections.emptyList();
        }
        if (!Objects.equals(snapshotVersions, this.getSnapshotVersions())) {
            this.update(this.getDelegate().withSnapshotVersions(snapshotVersions.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            snapshotVersions.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addSnapshotVersion(org.apache.maven.artifact.repository.metadata.SnapshotVersion snapshotVersion) {
        this.update(this.getDelegate().withSnapshotVersions(Stream.concat(this.getDelegate().getSnapshotVersions().stream(), Stream.of(snapshotVersion.getDelegate())).collect(Collectors.toList())));
        snapshotVersion.childrenTracking = this::replace;
    }

    public void removeSnapshotVersion(org.apache.maven.artifact.repository.metadata.SnapshotVersion snapshotVersion) {
        this.update(this.getDelegate().withSnapshotVersions(this.getDelegate().getSnapshotVersions().stream().filter(e -> !Objects.equals(e, snapshotVersion)).collect(Collectors.toList())));
        snapshotVersion.childrenTracking = null;
    }

    @Override
    protected boolean replace(Object oldDelegate, Object newDelegate) {
        if (super.replace(oldDelegate, newDelegate)) {
            return true;
        }
        if (oldDelegate == this.getDelegate().getSnapshot()) {
            this.update(this.getDelegate().withSnapshot((org.apache.maven.artifact.repository.metadata.v4.Snapshot)newDelegate));
            return true;
        }
        if (this.getDelegate().getSnapshotVersions().contains(oldDelegate)) {
            ArrayList<SnapshotVersion> list = new ArrayList<SnapshotVersion>(this.getDelegate().getSnapshotVersions());
            list.replaceAll(d -> d == oldDelegate ? (SnapshotVersion)newDelegate : d);
            this.update(this.getDelegate().withSnapshotVersions(list));
            return true;
        }
        return false;
    }

    public static List<org.apache.maven.artifact.repository.metadata.v4.Versioning> versioningToApiV4(List<Versioning> list) {
        return list != null ? new WrapperList<org.apache.maven.artifact.repository.metadata.v4.Versioning, Versioning>(list, Versioning::getDelegate, Versioning::new) : null;
    }

    public static List<Versioning> versioningToApiV3(List<org.apache.maven.artifact.repository.metadata.v4.Versioning> list) {
        return list != null ? new WrapperList<Versioning, org.apache.maven.artifact.repository.metadata.v4.Versioning>(list, Versioning::new, Versioning::getDelegate) : null;
    }

    public void updateTimestamp() {
        this.setLastUpdatedTimestamp(new Date());
    }

    public void setLastUpdatedTimestamp(Date date) {
        TimeZone timezone = TimeZone.getTimeZone("UTC");
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmss");
        fmt.setTimeZone(timezone);
        this.setLastUpdated(fmt.format(date));
    }
}

