/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.model.Model;

class ReactorModelPool {
    private final Map<GAKey, Set<Model>> modelsByGa = new ConcurrentHashMap<GAKey, Set<Model>>();
    private final Map<Path, Model> modelsByPath = new ConcurrentHashMap<Path, Model>();

    ReactorModelPool() {
    }

    public Model get(String groupId, String artifactId, String version) {
        return this.modelsByGa.getOrDefault(new GAKey(groupId, artifactId), Collections.emptySet()).stream().filter(m -> version == null || version.equals(this.getVersion((Model)m))).reduce((a, b) -> {
            throw new IllegalStateException("Multiple modules with key " + a.getGroupId() + ':' + a.getArtifactId());
        }).orElse(null);
    }

    private String getVersion(Model model) {
        String version = model.getVersion();
        if (version == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        return version;
    }

    void put(Path pomFile, Model model) {
        this.modelsByPath.put(pomFile, model);
        this.modelsByGa.computeIfAbsent(new GAKey(ReactorModelPool.getGroupId(model), model.getArtifactId()), k -> new HashSet()).add(model);
    }

    private static String getGroupId(Model model) {
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        return groupId;
    }

    private static final class GAKey {
        private final String groupId;
        private final String artifactId;
        private final int hashCode;

        GAKey(String groupId, String artifactId) {
            this.groupId = groupId != null ? groupId : "";
            this.artifactId = artifactId != null ? artifactId : "";
            this.hashCode = Objects.hash(this.groupId, this.artifactId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GAKey)) {
                return false;
            }
            GAKey that = (GAKey)obj;
            return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.groupId + ':' + this.artifactId;
        }
    }
}

