/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.maven.logwrapper.LogLevelRecorder;
import org.apache.maven.logwrapper.MavenSlf4jWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.impl.MvndDaemonLogger;
import org.slf4j.impl.MvndFailOnSeverityLogger;
import org.slf4j.impl.MvndSimpleLogger;
import org.slf4j.impl.SimpleLoggerConfiguration;

public class MvndLoggerFactory
implements MavenSlf4jWrapperFactory {
    private LogLevelRecorder logLevelRecorder = null;
    private final ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    public MvndLoggerFactory() {
        MvndSimpleLogger.lazyInit();
    }

    @Override
    public void setLogLevelRecorder(LogLevelRecorder logLevelRecorder) {
        if (this.logLevelRecorder != null) {
            throw new IllegalStateException("LogLevelRecorder has already been set.");
        }
        this.logLevelRecorder = logLevelRecorder;
    }

    @Override
    public Optional<LogLevelRecorder> getLogLevelRecorder() {
        return Optional.ofNullable(this.logLevelRecorder);
    }

    public Logger getLogger(String name) {
        return this.loggerMap.computeIfAbsent(name, this::getNewLoggingInstance);
    }

    private Logger getNewLoggingInstance(String name) {
        if (name.startsWith("org.mvndaemon.mvnd.daemon")) {
            return new MvndDaemonLogger(name);
        }
        if (this.logLevelRecorder == null) {
            return new MvndSimpleLogger(name);
        }
        return new MvndFailOnSeverityLogger(name, this.logLevelRecorder);
    }

    public void reconfigure() {
        SimpleLoggerConfiguration config = MvndSimpleLogger.CONFIG_PARAMS;
        config.init();
        this.loggerMap.values().forEach(l -> {
            if (l instanceof MvndSimpleLogger) {
                ((MvndSimpleLogger)((Object)l)).configure(config.defaultLogLevel);
            }
        });
    }
}

