/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.cache.invalidating;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.DefaultPluginRealmCache;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginRealmCache;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.eclipse.sisu.Priority;
import org.mvndaemon.mvnd.cache.Cache;
import org.mvndaemon.mvnd.cache.CacheFactory;
import org.mvndaemon.mvnd.cache.CacheRecord;

@Singleton
@Named
@Priority(value=10)
public class InvalidatingPluginRealmCache
extends DefaultPluginRealmCache {
    final Cache<PluginRealmCache.Key, Record> cache;

    @Inject
    public InvalidatingPluginRealmCache(CacheFactory cacheFactory) {
        this.cache = cacheFactory.newCache();
    }

    public PluginRealmCache.CacheRecord get(PluginRealmCache.Key key) {
        Record r = (Record)this.cache.get((Object)key);
        return r != null ? r.record : null;
    }

    public PluginRealmCache.CacheRecord get(PluginRealmCache.Key key, PluginRealmCache.PluginRealmSupplier supplier) throws PluginResolutionException, PluginContainerException {
        try {
            Record r = (Record)this.cache.computeIfAbsent((Object)key, k -> {
                try {
                    return new Record(supplier.load());
                }
                catch (PluginContainerException | PluginResolutionException e) {
                    throw new RuntimeException(e);
                }
            });
            return r.record;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof PluginResolutionException) {
                throw (PluginResolutionException)e.getCause();
            }
            if (e.getCause() instanceof PluginContainerException) {
                throw (PluginContainerException)e.getCause();
            }
            throw e;
        }
    }

    public PluginRealmCache.CacheRecord put(PluginRealmCache.Key key, ClassRealm pluginRealm, List<Artifact> pluginArtifacts) {
        PluginRealmCache.CacheRecord record = super.put(key, pluginRealm, pluginArtifacts);
        ((DefaultPluginRealmCache)this).cache.remove(key);
        this.cache.put((Object)key, (CacheRecord)new Record(record));
        return record;
    }

    public void flush() {
        this.cache.clear();
    }

    public void register(MavenProject project, PluginRealmCache.Key key, PluginRealmCache.CacheRecord record) {
    }

    protected static class Record
    implements CacheRecord {
        final PluginRealmCache.CacheRecord record;

        public Record(PluginRealmCache.CacheRecord record) {
            this.record = record;
        }

        public Stream<Path> getDependencyPaths() {
            return this.record.getArtifacts().stream().map(artifact -> artifact.getFile().toPath());
        }

        public void invalidate() {
            ClassRealm realm = this.record.getRealm();
            try {
                realm.getWorld().disposeRealm(realm.getId());
            }
            catch (NoSuchRealmException noSuchRealmException) {
                // empty catch block
            }
        }
    }
}

