/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.logwrapper;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.event.Level;

public class LogLevelRecorder {
    private static final Map<String, Level> ACCEPTED_LEVELS = new HashMap<String, Level>();
    private final Level logThreshold;
    private boolean metThreshold = false;

    public LogLevelRecorder(String threshold) {
        this.logThreshold = this.determineThresholdLevel(threshold);
    }

    private Level determineThresholdLevel(String input) {
        Level result = ACCEPTED_LEVELS.get(input);
        if (result == null) {
            String message = String.format("%s is not a valid log severity threshold. Valid severities are WARN/WARNING and ERROR.", input);
            throw new IllegalArgumentException(message);
        }
        return result;
    }

    public void record(Level logLevel) {
        if (!this.metThreshold && logLevel.toInt() >= this.logThreshold.toInt()) {
            this.metThreshold = true;
        }
    }

    public boolean metThreshold() {
        return this.metThreshold;
    }

    static {
        ACCEPTED_LEVELS.put("WARN", Level.WARN);
        ACCEPTED_LEVELS.put("WARNING", Level.WARN);
        ACCEPTED_LEVELS.put("ERROR", Level.ERROR);
    }
}

