/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.building;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.settings.InputSource;
import org.apache.maven.building.FileSource;
import org.apache.maven.building.Source;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingResult;
import org.apache.maven.settings.building.DefaultSettingsProblemCollector;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.building.SettingsProblemCollector;
import org.apache.maven.settings.io.SettingsParseException;
import org.apache.maven.settings.io.SettingsReader;
import org.apache.maven.settings.io.SettingsWriter;
import org.apache.maven.settings.merge.MavenSettingsMerger;
import org.apache.maven.settings.v4.SettingsTransformer;
import org.apache.maven.settings.validation.SettingsValidator;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

@Named
@Singleton
public class DefaultSettingsBuilder
implements SettingsBuilder {
    private SettingsReader settingsReader;
    private SettingsWriter settingsWriter;
    private SettingsValidator settingsValidator;
    private final MavenSettingsMerger settingsMerger = new MavenSettingsMerger();

    @Inject
    public DefaultSettingsBuilder(SettingsReader settingsReader, SettingsWriter settingsWriter, SettingsValidator settingsValidator) {
        this.settingsReader = settingsReader;
        this.settingsWriter = settingsWriter;
        this.settingsValidator = settingsValidator;
    }

    public DefaultSettingsBuilder setSettingsReader(SettingsReader settingsReader) {
        this.settingsReader = settingsReader;
        return this;
    }

    public DefaultSettingsBuilder setSettingsWriter(SettingsWriter settingsWriter) {
        this.settingsWriter = settingsWriter;
        return this;
    }

    public DefaultSettingsBuilder setSettingsValidator(SettingsValidator settingsValidator) {
        this.settingsValidator = settingsValidator;
        return this;
    }

    @Override
    public SettingsBuildingResult build(SettingsBuildingRequest request) throws SettingsBuildingException {
        File file;
        DefaultSettingsProblemCollector problems = new DefaultSettingsProblemCollector(null);
        Source globalSettingsSource = this.getSettingsSource(request.getGlobalSettingsFile(), request.getGlobalSettingsSource());
        Settings globalSettings = this.readSettings(globalSettingsSource, false, request, problems);
        Source projectSettingsSource = this.getSettingsSource(request.getProjectSettingsFile(), request.getProjectSettingsSource());
        Settings projectSettings = this.readSettings(projectSettingsSource, true, request, problems);
        Source userSettingsSource = this.getSettingsSource(request.getUserSettingsFile(), request.getUserSettingsSource());
        Settings userSettings = this.readSettings(userSettingsSource, false, request, problems);
        this.settingsMerger.merge(projectSettings, globalSettings, "global-level");
        this.settingsMerger.merge(userSettings, projectSettings, "project-level");
        if (userSettings.getRepositories().isEmpty() && userSettings.getPluginRepositories().isEmpty()) {
            Repository central = new Repository();
            central.setId("central");
            central.setName("Central Repository");
            central.setUrl("https://repo.maven.apache.org/maven2");
            RepositoryPolicy disabledPolicy = new RepositoryPolicy();
            disabledPolicy.setEnabled(false);
            central.setSnapshots(disabledPolicy);
            userSettings.getRepositories().add(central);
            central = central.clone();
            RepositoryPolicy updateNeverPolicy = new RepositoryPolicy();
            disabledPolicy.setUpdatePolicy("never");
            central.setReleases(updateNeverPolicy);
            userSettings.getPluginRepositories().add(central);
        }
        problems.setSource("");
        userSettings = this.interpolate(userSettings, request, problems);
        String localRepository = userSettings.getLocalRepository();
        if (localRepository != null && localRepository.length() > 0 && !(file = new File(localRepository)).isAbsolute() && file.getPath().startsWith(File.separator)) {
            userSettings.setLocalRepository(file.getAbsolutePath());
        }
        if (this.hasErrors(problems.getProblems())) {
            throw new SettingsBuildingException(problems.getProblems());
        }
        return new DefaultSettingsBuildingResult(userSettings, problems.getProblems());
    }

    private boolean hasErrors(List<SettingsProblem> problems) {
        if (problems != null) {
            for (SettingsProblem problem : problems) {
                if (SettingsProblem.Severity.ERROR.compareTo(problem.getSeverity()) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private Source getSettingsSource(File settingsFile, Source settingsSource) {
        if (settingsSource != null) {
            return settingsSource;
        }
        if (settingsFile != null && settingsFile.exists()) {
            return new FileSource(settingsFile);
        }
        return null;
    }

    private Settings readSettings(Source settingsSource, boolean isProjectSettings, SettingsBuildingRequest request, DefaultSettingsProblemCollector problems) {
        Settings settings;
        if (settingsSource == null) {
            return new Settings();
        }
        problems.setSource(settingsSource.getLocation());
        try {
            Map<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("org.apache.maven.settings.io.isStrict", Boolean.TRUE);
            options.put(InputSource.class.getName(), (Boolean)new InputSource(settingsSource.getLocation()));
            try {
                settings = this.settingsReader.read(settingsSource.getInputStream(), options);
            }
            catch (SettingsParseException e) {
                options = Collections.singletonMap("org.apache.maven.settings.io.isStrict", Boolean.FALSE);
                settings = this.settingsReader.read(settingsSource.getInputStream(), options);
                problems.add(SettingsProblem.Severity.WARNING, e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
            }
        }
        catch (SettingsParseException e) {
            problems.add(SettingsProblem.Severity.FATAL, "Non-parseable settings " + settingsSource.getLocation() + ": " + e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
            return new Settings();
        }
        catch (IOException e) {
            problems.add(SettingsProblem.Severity.FATAL, "Non-readable settings " + settingsSource.getLocation() + ": " + e.getMessage(), -1, -1, e);
            return new Settings();
        }
        this.settingsValidator.validate(settings, isProjectSettings, problems);
        if (isProjectSettings) {
            settings.setLocalRepository(null);
            settings.setInteractiveMode(true);
            settings.setOffline(false);
            settings.setProxies(Collections.emptyList());
            settings.setUsePluginRegistry(false);
            for (Server server : settings.getServers()) {
                server.setUsername(null);
                server.setPassword(null);
                server.setPrivateKey(null);
                server.setPassword(null);
                server.setFilePermissions(null);
                server.setDirectoryPermissions(null);
            }
        }
        return settings;
    }

    private Settings interpolate(Settings settings, SettingsBuildingRequest request, SettingsProblemCollector problems) {
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(request.getUserProperties()));
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(request.getSystemProperties()));
        try {
            interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
        }
        catch (IOException e) {
            problems.add(SettingsProblem.Severity.WARNING, "Failed to use environment variables for interpolation: " + e.getMessage(), -1, -1, e);
        }
        return new Settings(new SettingsTransformer(value -> {
            try {
                return value != null ? interpolator.interpolate(value) : null;
            }
            catch (InterpolationException e) {
                problems.add(SettingsProblem.Severity.WARNING, "Failed to interpolate settings: " + e.getMessage(), -1, -1, (Exception)((Object)e));
                return value;
            }
        }).visit(settings.getDelegate()));
    }
}

