/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.root;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.inject.Named;
import org.apache.maven.model.root.RootLocator;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named
public class DefaultRootLocator
implements RootLocator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isRootDirectory(Path dir) {
        if (Files.isDirectory(dir.resolve(".mvn"), new LinkOption[0])) {
            return true;
        }
        Path pom = dir.resolve("pom.xml");
        try (InputStream is = Files.newInputStream(pom, new OpenOption[0]);){
            MXParser parser = new MXParser();
            parser.setInput(is, null);
            if (parser.nextTag() != 2) return false;
            if (!parser.getName().equals("project")) return false;
            int i = 0;
            while (i < parser.getAttributeCount()) {
                if ("root".equals(parser.getAttributeName(i))) {
                    boolean bl = Boolean.parseBoolean(parser.getAttributeValue(i));
                    return bl;
                }
                ++i;
            }
            return false;
        }
        catch (IOException | XmlPullParserException throwable) {
            // empty catch block
        }
        return false;
    }
}

