/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.logging;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.maven.cli.logging.Slf4jConfiguration;
import org.apache.maven.cli.logging.impl.UnsupportedSlf4jBindingConfiguration;
import org.codehaus.plexus.util.PropertyUtils;
import org.slf4j.ILoggerFactory;

public class Slf4jConfigurationFactory {
    public static final String RESOURCE = "META-INF/maven/slf4j-configuration.properties";

    public static Slf4jConfiguration getConfiguration(ILoggerFactory loggerFactory) {
        String slf4jBinding = loggerFactory.getClass().getCanonicalName();
        try {
            Enumeration<URL> resources = Slf4jConfigurationFactory.class.getClassLoader().getResources(RESOURCE);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                try {
                    Properties conf = PropertyUtils.loadProperties((InputStream)resource.openStream());
                    String impl = conf.getProperty(slf4jBinding);
                    if (impl == null) continue;
                    return (Slf4jConfiguration)Class.forName(impl).newInstance();
                }
                catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new UnsupportedSlf4jBindingConfiguration();
    }
}

