/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.MetadataParseException;
import org.apache.maven.artifact.repository.metadata.io.MetadataReader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named
@Singleton
public class DefaultMetadataReader
implements MetadataReader {
    @Override
    public Metadata read(File input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        return this.read((Reader)ReaderFactory.newXmlReader((File)input), options);
    }

    @Override
    public Metadata read(Reader input, Map<String, ?> options) throws IOException {
        Metadata metadata;
        block8: {
            Objects.requireNonNull(input, "input cannot be null");
            Reader in = input;
            try {
                metadata = new MetadataXpp3Reader().read(in, this.isStrict(options));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XmlPullParserException e) {
                    throw new MetadataParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
                }
            }
            in.close();
        }
        return metadata;
    }

    @Override
    public Metadata read(InputStream input, Map<String, ?> options) throws IOException {
        Metadata metadata;
        block8: {
            Objects.requireNonNull(input, "input cannot be null");
            InputStream in = input;
            try {
                metadata = new MetadataXpp3Reader().read(in, this.isStrict(options));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XmlPullParserException e) {
                    throw new MetadataParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
                }
            }
            in.close();
        }
        return metadata;
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("org.apache.maven.artifact.repository.metadata.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }
}

