/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Scm
implements Serializable,
InputLocationTracker {
    final String connection;
    final String developerConnection;
    final String tag;
    final String url;
    final String childScmConnectionInheritAppendPath;
    final String childScmDeveloperConnectionInheritAppendPath;
    final String childScmUrlInheritAppendPath;
    final Map<Object, InputLocation> locations;

    Scm(String connection, String developerConnection, String tag, String url, String childScmConnectionInheritAppendPath, String childScmDeveloperConnectionInheritAppendPath, String childScmUrlInheritAppendPath, Map<Object, InputLocation> locations) {
        this.connection = connection;
        this.developerConnection = developerConnection;
        this.tag = tag;
        this.url = url;
        this.childScmConnectionInheritAppendPath = childScmConnectionInheritAppendPath;
        this.childScmDeveloperConnectionInheritAppendPath = childScmDeveloperConnectionInheritAppendPath;
        this.childScmUrlInheritAppendPath = childScmUrlInheritAppendPath;
        this.locations = ImmutableCollections.copy(locations);
    }

    public String getConnection() {
        return this.connection;
    }

    public String getDeveloperConnection() {
        return this.developerConnection;
    }

    public String getTag() {
        return this.tag;
    }

    public String getUrl() {
        return this.url;
    }

    public String getChildScmConnectionInheritAppendPath() {
        return this.childScmConnectionInheritAppendPath;
    }

    public String getChildScmDeveloperConnectionInheritAppendPath() {
        return this.childScmDeveloperConnectionInheritAppendPath;
    }

    public String getChildScmUrlInheritAppendPath() {
        return this.childScmUrlInheritAppendPath;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Scm.newBuilder(this);
    }

    @Nonnull
    public Scm withConnection(String connection) {
        return Scm.newBuilder(this, true).connection(connection).build();
    }

    @Nonnull
    public Scm withDeveloperConnection(String developerConnection) {
        return Scm.newBuilder(this, true).developerConnection(developerConnection).build();
    }

    @Nonnull
    public Scm withTag(String tag) {
        return Scm.newBuilder(this, true).tag(tag).build();
    }

    @Nonnull
    public Scm withUrl(String url) {
        return Scm.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public Scm withChildScmConnectionInheritAppendPath(String childScmConnectionInheritAppendPath) {
        return Scm.newBuilder(this, true).childScmConnectionInheritAppendPath(childScmConnectionInheritAppendPath).build();
    }

    @Nonnull
    public Scm withChildScmDeveloperConnectionInheritAppendPath(String childScmDeveloperConnectionInheritAppendPath) {
        return Scm.newBuilder(this, true).childScmDeveloperConnectionInheritAppendPath(childScmDeveloperConnectionInheritAppendPath).build();
    }

    @Nonnull
    public Scm withChildScmUrlInheritAppendPath(String childScmUrlInheritAppendPath) {
        return Scm.newBuilder(this, true).childScmUrlInheritAppendPath(childScmUrlInheritAppendPath).build();
    }

    @Nonnull
    public static Scm newInstance() {
        return Scm.newInstance(true);
    }

    @Nonnull
    public static Scm newInstance(boolean withDefaults) {
        return Scm.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Scm.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Scm from) {
        return Scm.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Scm from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isChildScmConnectionInheritAppendPath() {
        return this.getChildScmConnectionInheritAppendPath() != null ? Boolean.parseBoolean(this.getChildScmConnectionInheritAppendPath()) : true;
    }

    public boolean isChildScmDeveloperConnectionInheritAppendPath() {
        return this.getChildScmDeveloperConnectionInheritAppendPath() != null ? Boolean.parseBoolean(this.getChildScmDeveloperConnectionInheritAppendPath()) : true;
    }

    public boolean isChildScmUrlInheritAppendPath() {
        return this.getChildScmUrlInheritAppendPath() != null ? Boolean.parseBoolean(this.getChildScmUrlInheritAppendPath()) : true;
    }

    public String toString() {
        return "Scm {connection=" + this.getConnection() + "}";
    }

    @NotThreadSafe
    public static class Builder {
        Scm base;
        String connection;
        String developerConnection;
        String tag;
        String url;
        String childScmConnectionInheritAppendPath;
        String childScmDeveloperConnectionInheritAppendPath;
        String childScmUrlInheritAppendPath;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.tag = "HEAD";
            }
        }

        Builder(Scm base, boolean forceCopy) {
            if (forceCopy) {
                this.connection = base.connection;
                this.developerConnection = base.developerConnection;
                this.tag = base.tag;
                this.url = base.url;
                this.childScmConnectionInheritAppendPath = base.childScmConnectionInheritAppendPath;
                this.childScmDeveloperConnectionInheritAppendPath = base.childScmDeveloperConnectionInheritAppendPath;
                this.childScmUrlInheritAppendPath = base.childScmUrlInheritAppendPath;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder connection(String connection) {
            this.connection = connection;
            return this;
        }

        @Nonnull
        public Builder developerConnection(String developerConnection) {
            this.developerConnection = developerConnection;
            return this;
        }

        @Nonnull
        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder childScmConnectionInheritAppendPath(String childScmConnectionInheritAppendPath) {
            this.childScmConnectionInheritAppendPath = childScmConnectionInheritAppendPath;
            return this;
        }

        @Nonnull
        public Builder childScmDeveloperConnectionInheritAppendPath(String childScmDeveloperConnectionInheritAppendPath) {
            this.childScmDeveloperConnectionInheritAppendPath = childScmDeveloperConnectionInheritAppendPath;
            return this;
        }

        @Nonnull
        public Builder childScmUrlInheritAppendPath(String childScmUrlInheritAppendPath) {
            this.childScmUrlInheritAppendPath = childScmUrlInheritAppendPath;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Scm build() {
            if (!(this.base == null || this.connection != null && this.connection != this.base.connection || this.developerConnection != null && this.developerConnection != this.base.developerConnection || this.tag != null && this.tag != this.base.tag || this.url != null && this.url != this.base.url || this.childScmConnectionInheritAppendPath != null && this.childScmConnectionInheritAppendPath != this.base.childScmConnectionInheritAppendPath || this.childScmDeveloperConnectionInheritAppendPath != null && this.childScmDeveloperConnectionInheritAppendPath != this.base.childScmDeveloperConnectionInheritAppendPath || this.childScmUrlInheritAppendPath != null && this.childScmUrlInheritAppendPath != this.base.childScmUrlInheritAppendPath)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            Object location = null;
            Object connectionLocation = null;
            Object developerConnectionLocation = null;
            Object tagLocation = null;
            Object urlLocation = null;
            Object childScmConnectionInheritAppendPathLocation = null;
            Object childScmDeveloperConnectionInheritAppendPathLocation = null;
            Object childScmUrlInheritAppendPathLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new Scm(this.connection != null ? this.connection : (this.base != null ? this.base.connection : null), this.developerConnection != null ? this.developerConnection : (this.base != null ? this.base.developerConnection : null), this.tag != null ? this.tag : (this.base != null ? this.base.tag : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), this.childScmConnectionInheritAppendPath != null ? this.childScmConnectionInheritAppendPath : (this.base != null ? this.base.childScmConnectionInheritAppendPath : null), this.childScmDeveloperConnectionInheritAppendPath != null ? this.childScmDeveloperConnectionInheritAppendPath : (this.base != null ? this.base.childScmDeveloperConnectionInheritAppendPath : null), this.childScmUrlInheritAppendPath != null ? this.childScmUrlInheritAppendPath : (this.base != null ? this.base.childScmUrlInheritAppendPath : null), locations != null ? locations : (this.base != null ? this.base.locations : null));
        }
    }
}

