/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.v4;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.ActivationProperty;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.RepositoryBase;
import org.apache.maven.api.settings.RepositoryPolicy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.api.settings.TrackableBase;
import org.apache.maven.api.xml.XmlNode;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Generated
public class SettingsTransformer {
    private final Function<String, String> transformer;

    public SettingsTransformer(Function<String, String> transformer) {
        this.transformer = transformer;
    }

    public Settings visit(Settings target) {
        Objects.requireNonNull(target, "target cannot be null");
        return this.transformSettings(target);
    }

    protected String transform(String value) {
        return this.transformer.apply(value);
    }

    protected TrackableBase transformTrackableBase(TrackableBase target) {
        if (target == null) {
            return null;
        }
        TrackableBase.Builder builder = TrackableBase.newBuilder((TrackableBase)target);
        return builder.build();
    }

    protected IdentifiableBase transformIdentifiableBase(IdentifiableBase target) {
        if (target == null) {
            return null;
        }
        IdentifiableBase.Builder builder = IdentifiableBase.newBuilder((IdentifiableBase)target);
        this.transformIdentifiableBase_Id(builder, target);
        return builder.build();
    }

    protected void transformIdentifiableBase_Id(IdentifiableBase.Builder builder, IdentifiableBase target) {
        String newVal = this.transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected Settings transformSettings(Settings target) {
        if (target == null) {
            return null;
        }
        Settings.Builder builder = Settings.newBuilder((Settings)target);
        this.transformSettings_LocalRepository(builder, target);
        this.transformSettings_InteractiveMode(builder, target);
        this.transformSettings_UsePluginRegistry(builder, target);
        this.transformSettings_Offline(builder, target);
        this.transformSettings_Proxies(builder, target);
        this.transformSettings_Servers(builder, target);
        this.transformSettings_Mirrors(builder, target);
        this.transformSettings_Repositories(builder, target);
        this.transformSettings_PluginRepositories(builder, target);
        this.transformSettings_Profiles(builder, target);
        this.transformSettings_ActiveProfiles(builder, target);
        this.transformSettings_PluginGroups(builder, target);
        return builder.build();
    }

    protected void transformSettings_LocalRepository(Settings.Builder builder, Settings target) {
        String newVal = this.transform(target.getLocalRepository());
        builder.localRepository(newVal != target.getLocalRepository() ? newVal : null);
    }

    protected void transformSettings_InteractiveMode(Settings.Builder builder, Settings target) {
    }

    protected void transformSettings_UsePluginRegistry(Settings.Builder builder, Settings target) {
    }

    protected void transformSettings_Offline(Settings.Builder builder, Settings target) {
    }

    protected void transformSettings_Proxies(Settings.Builder builder, Settings target) {
        builder.proxies(this.transform(target.getProxies(), this::transformProxy));
    }

    protected void transformSettings_Servers(Settings.Builder builder, Settings target) {
        builder.servers(this.transform(target.getServers(), this::transformServer));
    }

    protected void transformSettings_Mirrors(Settings.Builder builder, Settings target) {
        builder.mirrors(this.transform(target.getMirrors(), this::transformMirror));
    }

    protected void transformSettings_Repositories(Settings.Builder builder, Settings target) {
        builder.repositories(this.transform(target.getRepositories(), this::transformRepository));
    }

    protected void transformSettings_PluginRepositories(Settings.Builder builder, Settings target) {
        builder.pluginRepositories(this.transform(target.getPluginRepositories(), this::transformRepository));
    }

    protected void transformSettings_Profiles(Settings.Builder builder, Settings target) {
        builder.profiles(this.transform(target.getProfiles(), this::transformProfile));
    }

    protected void transformSettings_ActiveProfiles(Settings.Builder builder, Settings target) {
        builder.activeProfiles(this.transform(target.getActiveProfiles(), this::transform));
    }

    protected void transformSettings_PluginGroups(Settings.Builder builder, Settings target) {
        builder.pluginGroups(this.transform(target.getPluginGroups(), this::transform));
    }

    protected Proxy transformProxy(Proxy target) {
        if (target == null) {
            return null;
        }
        Proxy.Builder builder = Proxy.newBuilder((Proxy)target);
        this.transformProxy_Active(builder, target);
        this.transformProxy_Protocol(builder, target);
        this.transformProxy_Username(builder, target);
        this.transformProxy_Password(builder, target);
        this.transformProxy_Port(builder, target);
        this.transformProxy_Host(builder, target);
        this.transformProxy_NonProxyHosts(builder, target);
        this.transformIdentifiableBase_Id((IdentifiableBase.Builder)builder, (IdentifiableBase)target);
        return builder.build();
    }

    protected void transformProxy_Active(Proxy.Builder builder, Proxy target) {
    }

    protected void transformProxy_Protocol(Proxy.Builder builder, Proxy target) {
        String newVal = this.transform(target.getProtocol());
        builder.protocol(newVal != target.getProtocol() ? newVal : null);
    }

    protected void transformProxy_Username(Proxy.Builder builder, Proxy target) {
        String newVal = this.transform(target.getUsername());
        builder.username(newVal != target.getUsername() ? newVal : null);
    }

    protected void transformProxy_Password(Proxy.Builder builder, Proxy target) {
        String newVal = this.transform(target.getPassword());
        builder.password(newVal != target.getPassword() ? newVal : null);
    }

    protected void transformProxy_Port(Proxy.Builder builder, Proxy target) {
    }

    protected void transformProxy_Host(Proxy.Builder builder, Proxy target) {
        String newVal = this.transform(target.getHost());
        builder.host(newVal != target.getHost() ? newVal : null);
    }

    protected void transformProxy_NonProxyHosts(Proxy.Builder builder, Proxy target) {
        String newVal = this.transform(target.getNonProxyHosts());
        builder.nonProxyHosts(newVal != target.getNonProxyHosts() ? newVal : null);
    }

    protected void transformProxy_Id(Proxy.Builder builder, Proxy target) {
        String newVal = this.transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected Server transformServer(Server target) {
        if (target == null) {
            return null;
        }
        Server.Builder builder = Server.newBuilder((Server)target);
        this.transformServer_Username(builder, target);
        this.transformServer_Password(builder, target);
        this.transformServer_PrivateKey(builder, target);
        this.transformServer_Passphrase(builder, target);
        this.transformServer_FilePermissions(builder, target);
        this.transformServer_DirectoryPermissions(builder, target);
        this.transformServer_Configuration(builder, target);
        this.transformIdentifiableBase_Id((IdentifiableBase.Builder)builder, (IdentifiableBase)target);
        return builder.build();
    }

    protected void transformServer_Username(Server.Builder builder, Server target) {
        String newVal = this.transform(target.getUsername());
        builder.username(newVal != target.getUsername() ? newVal : null);
    }

    protected void transformServer_Password(Server.Builder builder, Server target) {
        String newVal = this.transform(target.getPassword());
        builder.password(newVal != target.getPassword() ? newVal : null);
    }

    protected void transformServer_PrivateKey(Server.Builder builder, Server target) {
        String newVal = this.transform(target.getPrivateKey());
        builder.privateKey(newVal != target.getPrivateKey() ? newVal : null);
    }

    protected void transformServer_Passphrase(Server.Builder builder, Server target) {
        String newVal = this.transform(target.getPassphrase());
        builder.passphrase(newVal != target.getPassphrase() ? newVal : null);
    }

    protected void transformServer_FilePermissions(Server.Builder builder, Server target) {
        String newVal = this.transform(target.getFilePermissions());
        builder.filePermissions(newVal != target.getFilePermissions() ? newVal : null);
    }

    protected void transformServer_DirectoryPermissions(Server.Builder builder, Server target) {
        String newVal = this.transform(target.getDirectoryPermissions());
        builder.directoryPermissions(newVal != target.getDirectoryPermissions() ? newVal : null);
    }

    protected void transformServer_Configuration(Server.Builder builder, Server target) {
        XmlNode newVal = this.transform(target.getConfiguration());
        builder.configuration((XmlNode)(newVal != target.getConfiguration() ? newVal : null));
    }

    protected void transformServer_Id(Server.Builder builder, Server target) {
        String newVal = this.transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected Mirror transformMirror(Mirror target) {
        if (target == null) {
            return null;
        }
        Mirror.Builder builder = Mirror.newBuilder((Mirror)target);
        this.transformMirror_MirrorOf(builder, target);
        this.transformMirror_Name(builder, target);
        this.transformMirror_Url(builder, target);
        this.transformMirror_Layout(builder, target);
        this.transformMirror_MirrorOfLayouts(builder, target);
        this.transformMirror_Blocked(builder, target);
        this.transformIdentifiableBase_Id((IdentifiableBase.Builder)builder, (IdentifiableBase)target);
        return builder.build();
    }

    protected void transformMirror_MirrorOf(Mirror.Builder builder, Mirror target) {
        String newVal = this.transform(target.getMirrorOf());
        builder.mirrorOf(newVal != target.getMirrorOf() ? newVal : null);
    }

    protected void transformMirror_Name(Mirror.Builder builder, Mirror target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformMirror_Url(Mirror.Builder builder, Mirror target) {
        String newVal = this.transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }

    protected void transformMirror_Layout(Mirror.Builder builder, Mirror target) {
        String newVal = this.transform(target.getLayout());
        builder.layout(newVal != target.getLayout() ? newVal : null);
    }

    protected void transformMirror_MirrorOfLayouts(Mirror.Builder builder, Mirror target) {
        String newVal = this.transform(target.getMirrorOfLayouts());
        builder.mirrorOfLayouts(newVal != target.getMirrorOfLayouts() ? newVal : null);
    }

    protected void transformMirror_Blocked(Mirror.Builder builder, Mirror target) {
    }

    protected void transformMirror_Id(Mirror.Builder builder, Mirror target) {
        String newVal = this.transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected Profile transformProfile(Profile target) {
        if (target == null) {
            return null;
        }
        Profile.Builder builder = Profile.newBuilder((Profile)target);
        this.transformProfile_Activation(builder, target);
        this.transformProfile_Properties(builder, target);
        this.transformProfile_Repositories(builder, target);
        this.transformProfile_PluginRepositories(builder, target);
        this.transformIdentifiableBase_Id((IdentifiableBase.Builder)builder, (IdentifiableBase)target);
        return builder.build();
    }

    protected void transformProfile_Activation(Profile.Builder builder, Profile target) {
        Activation newVal = this.transformActivation(target.getActivation());
        builder.activation((Activation)(newVal != target.getActivation() ? newVal : null));
    }

    protected void transformProfile_Properties(Profile.Builder builder, Profile target) {
        Map props = target.getProperties();
        HashMap<String, String> newProps = null;
        for (Map.Entry entry : props.entrySet()) {
            String newVal = this.transform((String)entry.getValue());
            if (newVal == null || newVal == entry.getValue()) continue;
            if (newProps == null) {
                newProps = new HashMap<String, String>();
                newProps.putAll(props);
                builder.properties(newProps);
            }
            newProps.put((String)entry.getKey(), newVal);
        }
    }

    protected void transformProfile_Repositories(Profile.Builder builder, Profile target) {
        builder.repositories(this.transform(target.getRepositories(), this::transformRepository));
    }

    protected void transformProfile_PluginRepositories(Profile.Builder builder, Profile target) {
        builder.pluginRepositories(this.transform(target.getPluginRepositories(), this::transformRepository));
    }

    protected void transformProfile_Id(Profile.Builder builder, Profile target) {
        String newVal = this.transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected Activation transformActivation(Activation target) {
        if (target == null) {
            return null;
        }
        Activation.Builder builder = Activation.newBuilder((Activation)target);
        this.transformActivation_ActiveByDefault(builder, target);
        this.transformActivation_Jdk(builder, target);
        this.transformActivation_Os(builder, target);
        this.transformActivation_Property(builder, target);
        this.transformActivation_File(builder, target);
        return builder.build();
    }

    protected void transformActivation_ActiveByDefault(Activation.Builder builder, Activation target) {
    }

    protected void transformActivation_Jdk(Activation.Builder builder, Activation target) {
        String newVal = this.transform(target.getJdk());
        builder.jdk(newVal != target.getJdk() ? newVal : null);
    }

    protected void transformActivation_Os(Activation.Builder builder, Activation target) {
        ActivationOS newVal = this.transformActivationOS(target.getOs());
        builder.os((ActivationOS)(newVal != target.getOs() ? newVal : null));
    }

    protected void transformActivation_Property(Activation.Builder builder, Activation target) {
        ActivationProperty newVal = this.transformActivationProperty(target.getProperty());
        builder.property((ActivationProperty)(newVal != target.getProperty() ? newVal : null));
    }

    protected void transformActivation_File(Activation.Builder builder, Activation target) {
        ActivationFile newVal = this.transformActivationFile(target.getFile());
        builder.file((ActivationFile)(newVal != target.getFile() ? newVal : null));
    }

    protected RepositoryBase transformRepositoryBase(RepositoryBase target) {
        if (target == null) {
            return null;
        }
        RepositoryBase.Builder builder = RepositoryBase.newBuilder((RepositoryBase)target);
        this.transformRepositoryBase_Name(builder, target);
        this.transformRepositoryBase_Url(builder, target);
        this.transformRepositoryBase_Layout(builder, target);
        this.transformIdentifiableBase_Id((IdentifiableBase.Builder)builder, (IdentifiableBase)target);
        return builder.build();
    }

    protected void transformRepositoryBase_Name(RepositoryBase.Builder builder, RepositoryBase target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformRepositoryBase_Url(RepositoryBase.Builder builder, RepositoryBase target) {
        String newVal = this.transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }

    protected void transformRepositoryBase_Layout(RepositoryBase.Builder builder, RepositoryBase target) {
        String newVal = this.transform(target.getLayout());
        builder.layout(newVal != target.getLayout() ? newVal : null);
    }

    protected void transformRepositoryBase_Id(RepositoryBase.Builder builder, RepositoryBase target) {
        String newVal = this.transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected Repository transformRepository(Repository target) {
        if (target == null) {
            return null;
        }
        Repository.Builder builder = Repository.newBuilder((Repository)target);
        this.transformRepository_Releases(builder, target);
        this.transformRepository_Snapshots(builder, target);
        this.transformRepositoryBase_Name((RepositoryBase.Builder)builder, (RepositoryBase)target);
        this.transformRepositoryBase_Url((RepositoryBase.Builder)builder, (RepositoryBase)target);
        this.transformRepositoryBase_Layout((RepositoryBase.Builder)builder, (RepositoryBase)target);
        this.transformIdentifiableBase_Id((IdentifiableBase.Builder)builder, (IdentifiableBase)target);
        return builder.build();
    }

    protected void transformRepository_Releases(Repository.Builder builder, Repository target) {
        RepositoryPolicy newVal = this.transformRepositoryPolicy(target.getReleases());
        builder.releases((RepositoryPolicy)(newVal != target.getReleases() ? newVal : null));
    }

    protected void transformRepository_Snapshots(Repository.Builder builder, Repository target) {
        RepositoryPolicy newVal = this.transformRepositoryPolicy(target.getSnapshots());
        builder.snapshots((RepositoryPolicy)(newVal != target.getSnapshots() ? newVal : null));
    }

    protected void transformRepository_Name(Repository.Builder builder, Repository target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformRepository_Url(Repository.Builder builder, Repository target) {
        String newVal = this.transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }

    protected void transformRepository_Layout(Repository.Builder builder, Repository target) {
        String newVal = this.transform(target.getLayout());
        builder.layout(newVal != target.getLayout() ? newVal : null);
    }

    protected void transformRepository_Id(Repository.Builder builder, Repository target) {
        String newVal = this.transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected RepositoryPolicy transformRepositoryPolicy(RepositoryPolicy target) {
        if (target == null) {
            return null;
        }
        RepositoryPolicy.Builder builder = RepositoryPolicy.newBuilder((RepositoryPolicy)target);
        this.transformRepositoryPolicy_Enabled(builder, target);
        this.transformRepositoryPolicy_UpdatePolicy(builder, target);
        this.transformRepositoryPolicy_ChecksumPolicy(builder, target);
        return builder.build();
    }

    protected void transformRepositoryPolicy_Enabled(RepositoryPolicy.Builder builder, RepositoryPolicy target) {
    }

    protected void transformRepositoryPolicy_UpdatePolicy(RepositoryPolicy.Builder builder, RepositoryPolicy target) {
        String newVal = this.transform(target.getUpdatePolicy());
        builder.updatePolicy(newVal != target.getUpdatePolicy() ? newVal : null);
    }

    protected void transformRepositoryPolicy_ChecksumPolicy(RepositoryPolicy.Builder builder, RepositoryPolicy target) {
        String newVal = this.transform(target.getChecksumPolicy());
        builder.checksumPolicy(newVal != target.getChecksumPolicy() ? newVal : null);
    }

    protected ActivationProperty transformActivationProperty(ActivationProperty target) {
        if (target == null) {
            return null;
        }
        ActivationProperty.Builder builder = ActivationProperty.newBuilder((ActivationProperty)target);
        this.transformActivationProperty_Name(builder, target);
        this.transformActivationProperty_Value(builder, target);
        return builder.build();
    }

    protected void transformActivationProperty_Name(ActivationProperty.Builder builder, ActivationProperty target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformActivationProperty_Value(ActivationProperty.Builder builder, ActivationProperty target) {
        String newVal = this.transform(target.getValue());
        builder.value(newVal != target.getValue() ? newVal : null);
    }

    protected ActivationOS transformActivationOS(ActivationOS target) {
        if (target == null) {
            return null;
        }
        ActivationOS.Builder builder = ActivationOS.newBuilder((ActivationOS)target);
        this.transformActivationOS_Name(builder, target);
        this.transformActivationOS_Family(builder, target);
        this.transformActivationOS_Arch(builder, target);
        this.transformActivationOS_Version(builder, target);
        return builder.build();
    }

    protected void transformActivationOS_Name(ActivationOS.Builder builder, ActivationOS target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformActivationOS_Family(ActivationOS.Builder builder, ActivationOS target) {
        String newVal = this.transform(target.getFamily());
        builder.family(newVal != target.getFamily() ? newVal : null);
    }

    protected void transformActivationOS_Arch(ActivationOS.Builder builder, ActivationOS target) {
        String newVal = this.transform(target.getArch());
        builder.arch(newVal != target.getArch() ? newVal : null);
    }

    protected void transformActivationOS_Version(ActivationOS.Builder builder, ActivationOS target) {
        String newVal = this.transform(target.getVersion());
        builder.version(newVal != target.getVersion() ? newVal : null);
    }

    protected ActivationFile transformActivationFile(ActivationFile target) {
        if (target == null) {
            return null;
        }
        ActivationFile.Builder builder = ActivationFile.newBuilder((ActivationFile)target);
        this.transformActivationFile_Missing(builder, target);
        this.transformActivationFile_Exists(builder, target);
        return builder.build();
    }

    protected void transformActivationFile_Missing(ActivationFile.Builder builder, ActivationFile target) {
        String newVal = this.transform(target.getMissing());
        builder.missing(newVal != target.getMissing() ? newVal : null);
    }

    protected void transformActivationFile_Exists(ActivationFile.Builder builder, ActivationFile target) {
        String newVal = this.transform(target.getExists());
        builder.exists(newVal != target.getExists() ? newVal : null);
    }

    protected <T> List<T> transform(List<T> list, Function<T, T> transformer) {
        ArrayList<T> newList = null;
        for (int i = 0; i < list.size(); ++i) {
            T newVal = transformer.apply(list.get(i));
            if (newVal == list.get(i)) continue;
            if (newList == null) {
                newList = new ArrayList<T>(list);
            }
            newList.set(i, newVal);
        }
        return newList;
    }

    protected XmlNode transform(XmlNode node) {
        if (node != null) {
            Xpp3Dom xpp = new Xpp3Dom(node);
            this.transform(xpp);
            return xpp.getDom();
        }
        return node;
    }

    protected void transform(Xpp3Dom dom) {
        if (dom != null) {
            String val;
            String org = dom.getValue();
            if (org != (val = this.transform(org))) {
                dom.setValue(val);
            }
            for (String attr : dom.getAttributeNames()) {
                org = dom.getAttribute(attr);
                if (org == (val = this.transform(org))) continue;
                dom.setAttribute(attr, val);
            }
            int l = dom.getChildCount();
            for (int i = 0; i < l; ++i) {
                this.transform(dom.getChild(i));
            }
        }
    }
}

