/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtilsV4;

public final class SettingsUtils {
    private SettingsUtils() {
    }

    public static void merge(Settings dominant, Settings recessive, String recessiveSourceLevel) {
        if (dominant != null && recessive != null) {
            dominant.delegate = SettingsUtilsV4.merge(dominant.getDelegate(), recessive.getDelegate());
        }
    }

    public static Profile convertToSettingsProfile(org.apache.maven.model.Profile modelProfile) {
        return new Profile(SettingsUtilsV4.convertToSettingsProfile(modelProfile.getDelegate()));
    }

    public static org.apache.maven.model.Profile convertFromSettingsProfile(Profile settingsProfile) {
        return new org.apache.maven.model.Profile(SettingsUtilsV4.convertFromSettingsProfile(settingsProfile.getDelegate()));
    }

    public static Settings copySettings(Settings settings) {
        if (settings == null) {
            return null;
        }
        Settings clone = new Settings();
        clone.setActiveProfiles(settings.getActiveProfiles());
        clone.setInteractiveMode(settings.isInteractiveMode());
        clone.setLocalRepository(settings.getLocalRepository());
        clone.setMirrors(settings.getMirrors());
        clone.setOffline(settings.isOffline());
        clone.setPluginGroups(settings.getPluginGroups());
        clone.setProfiles(settings.getProfiles());
        clone.setProxies(settings.getProxies());
        clone.setServers(settings.getServers());
        clone.setSourceLevel(settings.getSourceLevel());
        clone.setUsePluginRegistry(settings.isUsePluginRegistry());
        return clone;
    }
}

