/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.PluginContainer;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.lifecycle.LifeCyclePluginAnalyzer;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.merge.MavenModelMerger;
import org.apache.maven.model.plugin.LifecycleBindingsInjector;

@Named
@Singleton
public class DefaultLifecycleBindingsInjector
implements LifecycleBindingsInjector {
    private final LifecycleBindingsMerger merger = new LifecycleBindingsMerger();
    private final LifeCyclePluginAnalyzer lifecycle;

    @Inject
    public DefaultLifecycleBindingsInjector(LifeCyclePluginAnalyzer lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void injectLifecycleBindings(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        String packaging = model.getPackaging();
        Set<Plugin> defaultPlugins = this.lifecycle.getPluginsBoundByDefaultToAllLifecycles(packaging);
        if (defaultPlugins == null) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Unknown packaging: " + packaging).setLocation(model.getLocation((Object)"packaging")));
        } else if (!defaultPlugins.isEmpty()) {
            List plugins = defaultPlugins.stream().map(Plugin::getDelegate).collect(Collectors.toList());
            org.apache.maven.api.model.Model lifecycleModel = org.apache.maven.api.model.Model.newBuilder().build(Build.newBuilder().plugins(plugins).build()).build();
            model.update((Object)this.merger.merge(model.getDelegate(), lifecycleModel));
        }
    }

    protected static class LifecycleBindingsMerger
    extends MavenModelMerger {
        private static final String PLUGIN_MANAGEMENT = "plugin-management";

        protected LifecycleBindingsMerger() {
        }

        public org.apache.maven.api.model.Model merge(org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source) {
            Build targetBuild = target.getBuild();
            if (targetBuild == null) {
                targetBuild = Build.newInstance();
            }
            Map<String, PluginManagement> context = Collections.singletonMap(PLUGIN_MANAGEMENT, target.getBuild().getPluginManagement());
            Build.Builder builder = Build.newBuilder((Build)target.getBuild());
            this.mergePluginContainer_Plugins((PluginContainer.Builder)builder, (PluginContainer)targetBuild, (PluginContainer)source.getBuild(), false, context);
            return target.withBuild(builder.build());
        }

        protected void mergePluginContainer_Plugins(PluginContainer.Builder builder, PluginContainer target, PluginContainer source, boolean sourceDominant, Map<Object, Object> context) {
            List src = source.getPlugins();
            if (!src.isEmpty()) {
                PluginManagement pluginMgmt;
                List tgt = target.getPlugins();
                LinkedHashMap<Object, Object> merged = new LinkedHashMap<Object, Object>((src.size() + tgt.size()) * 2);
                for (Object element : tgt) {
                    Object key = this.getPluginKey().apply(element);
                    merged.put(key, element);
                }
                LinkedHashMap<Object, org.apache.maven.api.model.Plugin> added = new LinkedHashMap<Object, org.apache.maven.api.model.Plugin>();
                for (org.apache.maven.api.model.Plugin element : src) {
                    Object key = this.getPluginKey().apply((Object)element);
                    org.apache.maven.api.model.Plugin existing = (org.apache.maven.api.model.Plugin)merged.get(key);
                    if (existing != null) {
                        element = this.mergePlugin(existing, element, sourceDominant, context);
                    } else {
                        added.put(key, element);
                    }
                    merged.put(key, element);
                }
                if (!added.isEmpty() && (pluginMgmt = (PluginManagement)context.get(PLUGIN_MANAGEMENT)) != null) {
                    for (org.apache.maven.api.model.Plugin managedPlugin : pluginMgmt.getPlugins()) {
                        Object key = this.getPluginKey().apply((Object)managedPlugin);
                        org.apache.maven.api.model.Plugin addedPlugin = (org.apache.maven.api.model.Plugin)added.get(key);
                        if (addedPlugin == null) continue;
                        org.apache.maven.api.model.Plugin plugin = this.mergePlugin(managedPlugin, addedPlugin, sourceDominant, Collections.emptyMap());
                        merged.put(key, plugin);
                    }
                }
                ArrayList result = new ArrayList(merged.values());
                builder.plugins(result);
            }
        }

        protected void mergePluginExecution_Priority(PluginExecution.Builder builder, PluginExecution target, PluginExecution source, boolean sourceDominant, Map<Object, Object> context) {
            if (target.getPriority() > source.getPriority()) {
                builder.priority(source.getPriority());
                builder.location((Object)"priority", source.getLocation((Object)"priority"));
            }
        }
    }
}

