/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Path;
import java.util.Optional;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.Source;

@Experimental
@Immutable
public interface SettingsBuilderRequest {
    @Nonnull
    public Session getSession();

    @Nonnull
    public Optional<Path> getGlobalSettingsPath();

    @Nonnull
    public Optional<Source> getGlobalSettingsSource();

    @Nonnull
    public Optional<Source> getProjectSettingsSource();

    @Nonnull
    public Optional<Path> getProjectSettingsPath();

    @Nonnull
    public Optional<Path> getUserSettingsPath();

    @Nonnull
    public Optional<Source> getUserSettingsSource();

    @Nonnull
    public static SettingsBuilderRequest build(@Nonnull Session session, @Nonnull Source globalSettingsSource, @Nonnull Source userSettingsSource) {
        return SettingsBuilderRequest.build(session, globalSettingsSource, null, userSettingsSource);
    }

    @Nonnull
    public static SettingsBuilderRequest build(@Nonnull Session session, @Nonnull Path globalSettingsPath, @Nonnull Path userSettingsPath) {
        return SettingsBuilderRequest.build(session, globalSettingsPath, null, userSettingsPath);
    }

    @Nonnull
    public static SettingsBuilderRequest build(@Nonnull Session session, @Nonnull Source globalSettingsSource, @Nonnull Source projectSettingsSource, @Nonnull Source userSettingsSource) {
        return SettingsBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).globalSettingsSource(BaseRequest.nonNull(globalSettingsSource, "globalSettingsSource cannot be null")).projectSettingsSource(BaseRequest.nonNull(projectSettingsSource, "projectSettingsSource cannot be null")).userSettingsSource(BaseRequest.nonNull(userSettingsSource, "userSettingsSource cannot be null")).build();
    }

    @Nonnull
    public static SettingsBuilderRequest build(@Nonnull Session session, @Nonnull Path globalSettingsPath, @Nonnull Path projectSettingsPath, @Nonnull Path userSettingsPath) {
        return SettingsBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).globalSettingsPath(BaseRequest.nonNull(globalSettingsPath, "globalSettingsPath cannot be null")).projectSettingsPath(BaseRequest.nonNull(projectSettingsPath, "projectSettingsPath cannot be null")).userSettingsPath(BaseRequest.nonNull(userSettingsPath, "userSettingsPath cannot be null")).build();
    }

    @Nonnull
    public static SettingsBuilderRequestBuilder builder() {
        return new SettingsBuilderRequestBuilder();
    }

    @NotThreadSafe
    public static class SettingsBuilderRequestBuilder {
        Session session;
        Path globalSettingsPath;
        Source globalSettingsSource;
        Path projectSettingsPath;
        Source projectSettingsSource;
        Path userSettingsPath;
        Source userSettingsSource;

        public SettingsBuilderRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public SettingsBuilderRequestBuilder globalSettingsPath(Path globalSettingsPath) {
            this.globalSettingsPath = globalSettingsPath;
            return this;
        }

        public SettingsBuilderRequestBuilder globalSettingsSource(Source globalSettingsSource) {
            this.globalSettingsSource = globalSettingsSource;
            return this;
        }

        public SettingsBuilderRequestBuilder projectSettingsPath(Path projectSettingsPath) {
            this.projectSettingsPath = projectSettingsPath;
            return this;
        }

        public SettingsBuilderRequestBuilder projectSettingsSource(Source projectSettingsSource) {
            this.projectSettingsSource = projectSettingsSource;
            return this;
        }

        public SettingsBuilderRequestBuilder userSettingsPath(Path userSettingsPath) {
            this.userSettingsPath = userSettingsPath;
            return this;
        }

        public SettingsBuilderRequestBuilder userSettingsSource(Source userSettingsSource) {
            this.userSettingsSource = userSettingsSource;
            return this;
        }

        public SettingsBuilderRequest build() {
            return new DefaultSettingsBuilderRequest(this.session, this.globalSettingsPath, this.globalSettingsSource, this.projectSettingsPath, this.projectSettingsSource, this.userSettingsPath, this.userSettingsSource);
        }

        private static class DefaultSettingsBuilderRequest
        extends BaseRequest
        implements SettingsBuilderRequest {
            private final Path globalSettingsPath;
            private final Source globalSettingsSource;
            private final Path projectSettingsPath;
            private final Source projectSettingsSource;
            private final Path userSettingsPath;
            private final Source userSettingsSource;

            DefaultSettingsBuilderRequest(@Nonnull Session session, @Nullable Path globalSettingsPath, @Nullable Source globalSettingsSource, @Nullable Path projectSettingsPath, @Nullable Source projectSettingsSource, @Nullable Path userSettingsPath, @Nullable Source userSettingsSource) {
                super(session);
                this.globalSettingsPath = globalSettingsPath;
                this.globalSettingsSource = globalSettingsSource;
                this.projectSettingsPath = projectSettingsPath;
                this.projectSettingsSource = projectSettingsSource;
                this.userSettingsPath = userSettingsPath;
                this.userSettingsSource = userSettingsSource;
            }

            @Override
            @Nonnull
            public Optional<Path> getGlobalSettingsPath() {
                return Optional.ofNullable(this.globalSettingsPath);
            }

            @Override
            @Nonnull
            public Optional<Source> getGlobalSettingsSource() {
                return Optional.ofNullable(this.globalSettingsSource);
            }

            @Override
            @Nonnull
            public Optional<Path> getProjectSettingsPath() {
                return Optional.ofNullable(this.projectSettingsPath);
            }

            @Override
            @Nonnull
            public Optional<Source> getProjectSettingsSource() {
                return Optional.ofNullable(this.projectSettingsSource);
            }

            @Override
            @Nonnull
            public Optional<Path> getUserSettingsPath() {
                return Optional.ofNullable(this.userSettingsPath);
            }

            @Override
            @Nonnull
            public Optional<Source> getUserSettingsSource() {
                return Optional.ofNullable(this.userSettingsSource);
            }
        }
    }
}

