/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.transform;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.model.transform.pull.BufferingParser;
import org.apache.maven.model.transform.pull.NodeBufferingParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;

public class ModelVersionXMLFilter
extends NodeBufferingParser {
    private static final Pattern S_FILTER = Pattern.compile("\\s+");
    public static final String NAMESPACE_PREFIX = "http://maven.apache.org/POM/";

    public ModelVersionXMLFilter(XmlPullParser xmlPullParser) {
        super(xmlPullParser, "project");
    }

    @Override
    protected void process(List<BufferingParser.Event> buffer) {
        if (buffer.stream().noneMatch(e -> e.event == 2 && "modelVersion".equals(e.name))) {
            String namespace = null;
            for (int pos = 0; pos < buffer.size(); ++pos) {
                BufferingParser.Event e2 = buffer.get(pos);
                if (namespace != null) {
                    if (e2.event != 2) continue;
                    BufferingParser.Event prev = buffer.get(pos - 1);
                    if (prev.event != 4 || !S_FILTER.matcher(prev.text).matches()) {
                        prev = null;
                    }
                    BufferingParser.Event pmse = new BufferingParser.Event();
                    pmse.event = 2;
                    pmse.name = "modelVersion";
                    pmse.namespace = namespace;
                    buffer.add(pos++, pmse);
                    BufferingParser.Event pmve = new BufferingParser.Event();
                    pmve.event = 4;
                    pmve.text = namespace.substring(NAMESPACE_PREFIX.length());
                    buffer.add(pos++, pmve);
                    BufferingParser.Event pmee = new BufferingParser.Event();
                    pmee.event = 3;
                    pmee.name = "modelVersion";
                    pmee.namespace = namespace;
                    buffer.add(pos++, pmee);
                    if (prev == null) break;
                    buffer.add(pos++, prev);
                    break;
                }
                if (e2.event != 2 || !"project".equals(e2.name) || e2.namespace == null || !e2.namespace.startsWith(NAMESPACE_PREFIX)) continue;
                namespace = e2.namespace;
            }
        }
        buffer.forEach(x$0 -> this.pushEvent((BufferingParser.Event)x$0));
    }
}

