/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginContainer;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.management.PluginManagementInjector;
import org.apache.maven.model.merge.MavenModelMerger;

@Named
@Singleton
public class DefaultPluginManagementInjector
implements PluginManagementInjector {
    private ManagementModelMerger merger = new ManagementModelMerger();

    @Override
    public void injectManagement(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        model.update((Object)this.merger.mergeManagedBuildPlugins(model.getDelegate()));
    }

    protected static class ManagementModelMerger
    extends MavenModelMerger {
        protected ManagementModelMerger() {
        }

        public org.apache.maven.api.model.Model mergeManagedBuildPlugins(org.apache.maven.api.model.Model model) {
            PluginManagement pluginManagement;
            Build build = model.getBuild();
            if (build != null && (pluginManagement = build.getPluginManagement()) != null) {
                return model.withBuild(this.mergePluginContainerPlugins(build, (PluginContainer)pluginManagement));
            }
            return model;
        }

        private Build mergePluginContainerPlugins(Build target, PluginContainer source) {
            List src = source.getPlugins();
            if (!src.isEmpty()) {
                LinkedHashMap<Object, Plugin> managedPlugins = new LinkedHashMap<Object, Plugin>(src.size() * 2);
                Map context = Collections.emptyMap();
                for (Plugin element : src) {
                    Object key = this.getPluginKey().apply((Object)element);
                    managedPlugins.put(key, element);
                }
                ArrayList<Plugin> newPlugins = new ArrayList<Plugin>();
                for (Plugin element : target.getPlugins()) {
                    Object key = this.getPluginKey().apply((Object)element);
                    Plugin managedPlugin = (Plugin)managedPlugins.get(key);
                    if (managedPlugin != null) {
                        element = this.mergePlugin(element, managedPlugin, false, context);
                    }
                    newPlugins.add(element);
                }
                return target.withPlugins(newPlugins);
            }
            return target;
        }

        @Override
        protected void mergePlugin_Executions(Plugin.Builder builder, Plugin target, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
            List src = source.getExecutions();
            if (!src.isEmpty()) {
                Object key;
                List tgt = target.getExecutions();
                LinkedHashMap<Object, PluginExecution> merged = new LinkedHashMap<Object, PluginExecution>((src.size() + tgt.size()) * 2);
                for (PluginExecution element : src) {
                    key = this.getPluginExecutionKey().apply((Object)element);
                    merged.put(key, element);
                }
                for (PluginExecution element : tgt) {
                    key = this.getPluginExecutionKey().apply((Object)element);
                    PluginExecution existing = (PluginExecution)merged.get(key);
                    if (existing != null) {
                        element = this.mergePluginExecution(element, existing, sourceDominant, context);
                    }
                    merged.put(key, element);
                }
                builder.executions(merged.values());
            }
        }
    }
}

