/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.TransformerContext;
import org.apache.maven.model.transform.BuildToRawPomXMLFilterFactory;
import org.apache.maven.model.transform.RelativeProject;

public class DefaultBuildPomXMLFilterFactory
extends BuildToRawPomXMLFilterFactory {
    private final TransformerContext context;

    public DefaultBuildPomXMLFilterFactory(TransformerContext context, boolean consume) {
        super(consume);
        this.context = context;
    }

    protected Function<Path, Optional<RelativeProject>> getRelativePathMapper() {
        return p -> Optional.ofNullable(this.context.getRawModel((Path)p)).map(DefaultBuildPomXMLFilterFactory::toRelativeProject);
    }

    protected BiFunction<String, String, String> getDependencyKeyToVersionMapper() {
        return (g, a) -> Optional.ofNullable(this.context.getRawModel((String)g, (String)a)).map(DefaultBuildPomXMLFilterFactory::toVersion).orElse(null);
    }

    protected Optional<String> getChangelist() {
        return Optional.ofNullable(this.context.getUserProperty("changelist"));
    }

    protected Optional<String> getRevision() {
        return Optional.ofNullable(this.context.getUserProperty("revision"));
    }

    protected Optional<String> getSha1() {
        return Optional.ofNullable(this.context.getUserProperty("sha1"));
    }

    private static RelativeProject toRelativeProject(Model m) {
        String version;
        String groupId = m.getGroupId();
        if (groupId == null && m.getParent() != null) {
            groupId = m.getParent().getGroupId();
        }
        if ((version = m.getVersion()) == null && m.getParent() != null) {
            version = m.getParent().getVersion();
        }
        return new RelativeProject(groupId, m.getArtifactId(), version);
    }

    private static String toVersion(Model m) {
        String version = m.getVersion();
        if (version == null && m.getParent() != null) {
            version = m.getParent().getVersion();
        }
        return version;
    }
}

