/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.Objects;
import org.apache.maven.building.Source;
import org.apache.maven.model.building.ModelCache;

public class SnapshotModelCache
implements ModelCache {
    private final ModelCache globalCache;
    private final ModelCache reactorCache;

    public SnapshotModelCache(ModelCache globalCache, ModelCache reactorCache) {
        this.globalCache = Objects.requireNonNull(globalCache);
        this.reactorCache = Objects.requireNonNull(reactorCache);
    }

    public Object get(Source path, String tag) {
        return this.reactorCache.get(path, tag);
    }

    public void put(Source path, String tag, Object data) {
        this.reactorCache.put(path, tag, data);
    }

    public void put(String groupId, String artifactId, String version, String tag, Object data) {
        this.getDelegate(version).put(groupId, artifactId, version, tag, data);
    }

    public Object get(String groupId, String artifactId, String version, String tag) {
        return this.getDelegate(version).get(groupId, artifactId, version, tag);
    }

    private ModelCache getDelegate(String version) {
        return version.contains("SNAPSHOT") || version.contains("${") ? this.reactorCache : this.globalCache;
    }
}

