/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.maven.InternalErrorException;
import org.apache.maven.Maven;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.building.FileSource;
import org.apache.maven.building.Problem;
import org.apache.maven.building.Source;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.cli.CliRequest;
import org.apache.maven.cli.DaemonCli;
import org.apache.maven.cli.MvndHelpFormatter;
import org.apache.maven.cli.configuration.ConfigurationProcessor;
import org.apache.maven.cli.event.ExecutionEventLogger;
import org.apache.maven.cli.internal.BootstrapCoreExtensionManager;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.cli.jansi.JansiMessageBuilderFactory;
import org.apache.maven.cli.jansi.MessageUtils;
import org.apache.maven.cli.logging.Slf4jConfiguration;
import org.apache.maven.cli.logging.Slf4jConfigurationFactory;
import org.apache.maven.cli.transfer.QuietMavenTransferListener;
import org.apache.maven.cli.transfer.Slf4jMavenTransferListener;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.exception.DefaultExceptionHandler;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.ProfileActivation;
import org.apache.maven.execution.ProjectActivation;
import org.apache.maven.execution.scope.internal.MojoExecutionScopeModule;
import org.apache.maven.extension.internal.CoreExports;
import org.apache.maven.extension.internal.CoreExportsProvider;
import org.apache.maven.extension.internal.CoreExtensionEntry;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.root.RootLocator;
import org.apache.maven.plugin.ExtensionRealmCache;
import org.apache.maven.plugin.PluginArtifactsCache;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactsCache;
import org.apache.maven.properties.internal.SystemProperties;
import org.apache.maven.session.scope.internal.SessionScopeModule;
import org.apache.maven.toolchain.building.DefaultToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuilder;
import org.apache.maven.toolchain.building.ToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuildingResult;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.BasicInterpolator;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.logging.LoggerManager;
import org.eclipse.aether.transfer.TransferListener;
import org.mvndaemon.mvnd.cache.invalidating.InvalidatingExtensionRealmCache;
import org.mvndaemon.mvnd.cache.invalidating.InvalidatingPluginArtifactsCache;
import org.mvndaemon.mvnd.cache.invalidating.InvalidatingProjectArtifactsCache;
import org.mvndaemon.mvnd.cli.EnvHelper;
import org.mvndaemon.mvnd.common.Environment;
import org.mvndaemon.mvnd.common.Os;
import org.mvndaemon.mvnd.logging.internal.Slf4jLoggerManager;
import org.mvndaemon.mvnd.logging.smart.BuildEventListener;
import org.mvndaemon.mvnd.logging.smart.LoggingExecutionListener;
import org.mvndaemon.mvnd.logging.smart.LoggingOutputStream;
import org.mvndaemon.mvnd.transfer.DaemonMavenTransferListener;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.MvndSimpleLogger;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

public class DaemonMavenCli
implements DaemonCli {
    public static final String LOCAL_REPO_PROPERTY = "maven.repo.local";
    public static final String MULTIMODULE_PROJECT_DIRECTORY = "maven.multiModuleProjectDirectory";
    public static final String USER_HOME = System.getProperty("user.home");
    public static final File USER_MAVEN_CONFIGURATION_HOME = new File(USER_HOME, ".m2");
    public static final File DEFAULT_USER_TOOLCHAINS_FILE = new File(USER_MAVEN_CONFIGURATION_HOME, "toolchains.xml");
    public static final File DEFAULT_GLOBAL_TOOLCHAINS_FILE = new File(System.getProperty("maven.conf"), "toolchains.xml");
    private static final String EXT_CLASS_PATH = "maven.ext.class.path";
    private static final String EXTENSIONS_FILENAME = ".mvn/extensions.xml";
    private static final String MVN_MAVEN_CONFIG = ".mvn/maven.config";
    public static final String STYLE_COLOR_PROPERTY = "style.color";
    public static final String RAW_STREAMS = "raw-streams";
    private final Slf4jLoggerManager plexusLoggerManager;
    private final ILoggerFactory slf4jLoggerFactory;
    private final Logger slf4jLogger;
    private final ClassWorld classWorld;
    private final DefaultPlexusContainer container;
    private final EventSpyDispatcher eventSpyDispatcher;
    private final ModelProcessor modelProcessor;
    private final Maven maven;
    private final MavenExecutionRequestPopulator executionRequestPopulator;
    private final ToolchainsBuilder toolchainsBuilder;
    private final DefaultSecDispatcher dispatcher;
    private final Map<String, ConfigurationProcessor> configurationProcessors;
    private final LoggingExecutionListener executionListener;
    private BuildEventListener buildEventListener = BuildEventListener.dummy();
    private MessageBuilderFactory messageBuilderFactory;
    private static final Pattern LAST_ANSI_SEQUENCE = Pattern.compile("(\u001b\\[[;\\d]*[ -/]*[@-~])[^\u001b]*$");
    private static final String ANSI_RESET = "\u001b[m";

    public DaemonMavenCli() throws Exception {
        this.slf4jLoggerFactory = LoggerFactory.getILoggerFactory();
        this.slf4jLogger = this.slf4jLoggerFactory.getLogger(this.getClass().getName());
        this.plexusLoggerManager = new Slf4jLoggerManager();
        this.classWorld = ((ClassRealm)Thread.currentThread().getContextClassLoader()).getWorld();
        this.messageBuilderFactory = new JansiMessageBuilderFactory();
        this.container = this.container();
        this.eventSpyDispatcher = (EventSpyDispatcher)this.container.lookup(EventSpyDispatcher.class);
        this.maven = (Maven)this.container.lookup(Maven.class);
        this.executionRequestPopulator = (MavenExecutionRequestPopulator)this.container.lookup(MavenExecutionRequestPopulator.class);
        this.modelProcessor = this.createModelProcessor((PlexusContainer)this.container);
        this.configurationProcessors = this.container.lookupMap(ConfigurationProcessor.class);
        this.toolchainsBuilder = (ToolchainsBuilder)this.container.lookup(ToolchainsBuilder.class);
        this.dispatcher = (DefaultSecDispatcher)this.container.lookup(SecDispatcher.class, "maven");
        this.executionListener = (LoggingExecutionListener)this.container.lookup(LoggingExecutionListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int main(List<String> arguments, String workingDirectory, String projectDirectory, Map<String, String> clientEnv, BuildEventListener buildEventListener) throws Exception {
        this.buildEventListener = buildEventListener;
        try {
            CliRequest req = new CliRequest(null, null);
            req.args = arguments.toArray(new String[0]);
            req.workingDirectory = new File(workingDirectory).getCanonicalPath();
            req.multiModuleProjectDirectory = new File(projectDirectory);
            int n = this.doMain(req, clientEnv);
            return n;
        }
        finally {
            this.buildEventListener = BuildEventListener.dummy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doMain(CliRequest cliRequest, Map<String, String> clientEnv) throws Exception {
        Properties props = (Properties)System.getProperties().clone();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.container.getContainerRealm());
            this.initialize(cliRequest);
            this.environment(cliRequest.workingDirectory, clientEnv);
            this.cli(cliRequest);
            this.properties(cliRequest);
            this.logging(cliRequest);
            this.informativeCommands(cliRequest);
            this.version(cliRequest);
            this.container(cliRequest);
            DaemonMavenCli.configure(cliRequest, this.eventSpyDispatcher, this.configurationProcessors);
            this.toolchains(cliRequest);
            this.populateRequest(cliRequest);
            this.encryption(cliRequest);
            int n = this.execute(cliRequest);
            return n;
        }
        catch (ExitException e) {
            int n = e.exitCode;
            return n;
        }
        finally {
            this.eventSpyDispatcher.close();
            System.setProperties(props);
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    void initialize(CliRequest cliRequest) throws ExitException {
        cliRequest.classWorld = this.classWorld;
        if (cliRequest.workingDirectory == null) {
            cliRequest.workingDirectory = System.getProperty("user.dir");
        }
        if (cliRequest.multiModuleProjectDirectory == null) {
            this.buildEventListener.log(String.format("-D%s system property is not set.", MULTIMODULE_PROJECT_DIRECTORY));
            throw new ExitException(1);
        }
        System.setProperty(MULTIMODULE_PROJECT_DIRECTORY, cliRequest.multiModuleProjectDirectory.toString());
        Path topDirectory = Paths.get(cliRequest.workingDirectory, new String[0]);
        boolean isAltFile = false;
        for (String arg : cliRequest.args) {
            if (isAltFile) {
                Path path = topDirectory.resolve(arg);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    topDirectory = path;
                    break;
                }
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    topDirectory = path.getParent();
                    if (Files.isDirectory(topDirectory, new LinkOption[0])) break;
                    System.err.println("Directory " + topDirectory + " extracted from the -f/--file command-line argument " + arg + " does not exist");
                    throw new ExitException(1);
                }
                System.err.println("POM file " + arg + " specified with the -f/--file command line argument does not exist");
                throw new ExitException(1);
            }
            isAltFile = arg.equals(String.valueOf('f')) || arg.equals("file");
        }
        cliRequest.topDirectory = topDirectory = DaemonMavenCli.getCanonicalPath(topDirectory);
        RootLocator rootLocator = ServiceLoader.load(RootLocator.class).iterator().next();
        Path rootDirectory = rootLocator.findRoot(topDirectory);
        if (rootDirectory == null) {
            System.err.println("Unable to find the root directory. Create a .mvn directory in the root directory or add the root=\"true\" attribute on the root project's model to identify it.");
        }
        cliRequest.rootDirectory = rootDirectory;
    }

    void cli(CliRequest cliRequest) throws Exception {
        CommandLine mavenConfig;
        CLIManager cliManager;
        block14: {
            cliManager = this.newCLIManager();
            mavenConfig = null;
            try {
                File configFile = new File(cliRequest.multiModuleProjectDirectory, MVN_MAVEN_CONFIG);
                if (!configFile.isFile()) break block14;
                try (Stream<String> lines = Files.lines(configFile.toPath(), Charset.defaultCharset());){
                    String[] args = (String[])lines.filter(arg -> !arg.isEmpty() && !arg.startsWith("#")).toArray(String[]::new);
                    mavenConfig = cliManager.parse(args);
                    List unrecognized = mavenConfig.getArgList();
                    if (!unrecognized.isEmpty()) {
                        throw new ParseException("Unrecognized maven.config file entries: " + unrecognized);
                    }
                }
            }
            catch (ParseException e) {
                this.buildEventListener.log("Unable to parse maven.config: " + e.getMessage());
                this.buildEventListener.log("Run 'mvnd --help' for available options.");
                throw new ExitException(1);
            }
        }
        try {
            cliRequest.commandLine = mavenConfig == null ? cliManager.parse(cliRequest.args) : this.cliMerge(cliManager.parse(cliRequest.args), mavenConfig);
        }
        catch (ParseException e) {
            this.buildEventListener.log("Unable to parse command line options: " + e.getMessage());
            this.buildEventListener.log("Run 'mvnd --help' for available options.");
            throw new ExitException(1);
        }
        try {
            if (cliRequest.commandLine.hasOption("llr")) {
                throw new UnrecognizedOptionException("Option '-llr' is not supported starting with Maven 3.9.1");
            }
        }
        catch (ParseException e) {
            System.err.println("Unsupported options: " + e.getMessage());
            cliManager.displayHelp(System.out);
            throw e;
        }
    }

    private void informativeCommands(CliRequest cliRequest) throws Exception {
        if (cliRequest.commandLine.hasOption('h')) {
            this.buildEventListener.log(MvndHelpFormatter.displayHelp((CLIManager)this.newCLIManager()));
            throw new ExitException(0);
        }
        if (cliRequest.commandLine.hasOption('v')) {
            if (cliRequest.commandLine.hasOption('q')) {
                this.buildEventListener.log(CLIReportingUtils.showVersionMinimal());
            } else {
                this.buildEventListener.log(CLIReportingUtils.showVersion());
            }
            throw new ExitException(0);
        }
    }

    private CLIManager newCLIManager() {
        CLIManager cliManager = new CLIManager();
        cliManager.options.addOption(Option.builder().longOpt(RAW_STREAMS).desc("Do not decorate output and error streams").build());
        return cliManager;
    }

    private CommandLine cliMerge(CommandLine mavenArgs, CommandLine mavenConfig) {
        CommandLine.Builder commandLineBuilder = new CommandLine.Builder();
        for (String arg : mavenArgs.getArgs()) {
            commandLineBuilder.addArg(arg);
        }
        for (String arg : mavenConfig.getArgs()) {
            commandLineBuilder.addArg(arg);
        }
        ArrayList<Option> setPropertyOptions = new ArrayList<Option>();
        for (Option opt : mavenArgs.getOptions()) {
            if (String.valueOf('D').equals(opt.getOpt())) {
                setPropertyOptions.add(opt);
                continue;
            }
            commandLineBuilder.addOption(opt);
        }
        for (Option opt : mavenConfig.getOptions()) {
            commandLineBuilder.addOption(opt);
        }
        for (Option opt : setPropertyOptions) {
            commandLineBuilder.addOption(opt);
        }
        return commandLineBuilder.build();
    }

    void logging(CliRequest cliRequest) {
        CommandLine commandLine = cliRequest.commandLine;
        cliRequest.verbose = commandLine.hasOption('X') || commandLine.hasOption("debug");
        cliRequest.quiet = !cliRequest.verbose && commandLine.hasOption('q');
        cliRequest.showErrors = cliRequest.verbose || commandLine.hasOption('e');
        Slf4jConfiguration slf4jConfiguration = Slf4jConfigurationFactory.getConfiguration((ILoggerFactory)this.slf4jLoggerFactory);
        if (cliRequest.verbose) {
            cliRequest.request.setLoggingLevel(0);
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.DEBUG);
        } else if (cliRequest.quiet) {
            cliRequest.request.setLoggingLevel(3);
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.ERROR);
        }
        String styleColor = cliRequest.getUserProperties().getProperty(STYLE_COLOR_PROPERTY, "auto");
        if ("always".equals(styleColor)) {
            MessageUtils.setColorEnabled((boolean)true);
        } else if ("never".equals(styleColor)) {
            MessageUtils.setColorEnabled((boolean)false);
        } else {
            boolean isBatchMode;
            if (!"auto".equals(styleColor)) {
                throw new IllegalArgumentException("Invalid color configuration option [" + styleColor + "]. Supported values are (auto|always|never).");
            }
            boolean bl = isBatchMode = !commandLine.hasOption("force-interactive") && (commandLine.hasOption('B') || commandLine.hasOption("non-interactive"));
            if (isBatchMode || commandLine.hasOption("l")) {
                MessageUtils.setColorEnabled((boolean)false);
            }
        }
        if (commandLine.hasOption("l")) {
            File logFile = new File(commandLine.getOptionValue("l"));
            logFile = DaemonMavenCli.resolveFile(logFile, cliRequest.workingDirectory);
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(logFile), true);
                System.setOut(ps);
                System.setErr(ps);
            }
            catch (FileNotFoundException ps) {}
        } else if (!Environment.MVND_RAW_STREAMS.asOptional().map(Boolean::parseBoolean).orElse(Boolean.FALSE).booleanValue()) {
            MvndSimpleLogger stdout = (MvndSimpleLogger)this.slf4jLoggerFactory.getLogger("stdout");
            MvndSimpleLogger stderr = (MvndSimpleLogger)this.slf4jLoggerFactory.getLogger("stderr");
            stdout.setLogLevel(20);
            stderr.setLogLevel(20);
            System.setOut(new LoggingOutputStream(s -> stdout.info("[stdout] " + s)).printStream());
            System.setErr(new LoggingOutputStream(s -> stderr.warn("[stderr] " + s)).printStream());
        }
        slf4jConfiguration.activate();
    }

    private void version(CliRequest cliRequest) throws ExitException {
        if (cliRequest.verbose || cliRequest.commandLine.hasOption('V')) {
            this.buildEventListener.log(CLIReportingUtils.showVersion());
        }
    }

    private void commands(CliRequest cliRequest) {
        if (cliRequest.showErrors) {
            this.slf4jLogger.info("Error stacktraces are turned on.");
        }
        if ("warn".equals(cliRequest.request.getGlobalChecksumPolicy())) {
            this.slf4jLogger.info("Disabling strict checksum verification on all artifact downloads.");
        } else if ("fail".equals(cliRequest.request.getGlobalChecksumPolicy())) {
            this.slf4jLogger.info("Enabling strict checksum verification on all artifact downloads.");
        }
        if (this.slf4jLogger.isDebugEnabled()) {
            this.slf4jLogger.debug("Message scheme: {}", (Object)(MessageUtils.isColorEnabled() ? "color" : "plain"));
            if (MessageUtils.isColorEnabled()) {
                MessageBuilder buff = MessageUtils.builder();
                buff.a((CharSequence)"Message styles: ");
                buff.debug((Object)"debug").a((Object)Character.valueOf(' '));
                buff.info((Object)"info").a((Object)Character.valueOf(' '));
                buff.warning((Object)"warning").a((Object)Character.valueOf(' '));
                buff.error((Object)"error").a((Object)Character.valueOf(' '));
                buff.success((Object)"success").a((Object)Character.valueOf(' '));
                buff.failure((Object)"failure").a((Object)Character.valueOf(' '));
                buff.strong((Object)"strong").a((Object)Character.valueOf(' '));
                buff.mojo((Object)"mojo").a((Object)Character.valueOf(' '));
                buff.project((Object)"project");
                this.slf4jLogger.debug(buff.toString());
            }
        }
    }

    void properties(CliRequest cliRequest) throws Exception {
        Properties paths = new Properties();
        if (cliRequest.topDirectory != null) {
            paths.put("session.topDirectory", cliRequest.topDirectory.toString());
        }
        if (cliRequest.rootDirectory != null) {
            paths.put("session.rootDirectory", cliRequest.rootDirectory.toString());
        }
        DaemonMavenCli.populateProperties(cliRequest.commandLine, paths, cliRequest.systemProperties, cliRequest.userProperties);
        BasicInterpolator interpolator = DaemonMavenCli.createInterpolator(paths, cliRequest.systemProperties, cliRequest.userProperties);
        CommandLine.Builder commandLineBuilder = new CommandLine.Builder();
        for (Option option : cliRequest.commandLine.getOptions()) {
            if (!String.valueOf('D').equals(option.getOpt())) {
                List values = option.getValuesList();
                ListIterator<String> it = values.listIterator();
                while (it.hasNext()) {
                    it.set(interpolator.interpolate((String)it.next()));
                }
            }
            commandLineBuilder.addOption(option);
        }
        for (String arg : cliRequest.commandLine.getArgList()) {
            commandLineBuilder.addArg(interpolator.interpolate(arg));
        }
        cliRequest.commandLine = commandLineBuilder.build();
    }

    void container(CliRequest cliRequest) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("plexus", this.container);
        data.put("workingDirectory", cliRequest.workingDirectory);
        data.put("systemProperties", cliRequest.systemProperties);
        data.put("userProperties", cliRequest.userProperties);
        data.put("versionProperties", CLIReportingUtils.getBuildProperties());
        this.eventSpyDispatcher.init(() -> data);
    }

    DefaultPlexusContainer container() throws Exception {
        ClassRealm coreRealm = this.classWorld.getClassRealm("plexus.core");
        if (coreRealm == null) {
            coreRealm = (ClassRealm)this.classWorld.getRealms().iterator().next();
        }
        List<File> extClassPath = Stream.of(Environment.MVND_EXT_CLASSPATH.asString().split(",")).filter(s -> s != null && !s.isEmpty()).map(File::new).collect(Collectors.toList());
        CoreExtensionEntry coreEntry = CoreExtensionEntry.discoverFrom((ClassRealm)coreRealm);
        List<CoreExtension> extensions = Stream.of(Environment.MVND_CORE_EXTENSIONS.asString().split(";")).filter(s -> s != null && !s.isEmpty()).map(s -> {
            String[] parts = s.split(":");
            CoreExtension ce = new CoreExtension();
            ce.setGroupId(parts[0]);
            ce.setArtifactId(parts[1]);
            ce.setVersion(parts[2]);
            return ce;
        }).collect(Collectors.toList());
        List<CoreExtensionEntry> extensionsEntries = this.loadCoreExtensions(extensions, coreRealm, coreEntry.getExportedArtifacts());
        ClassRealm containerRealm = this.setupContainerRealm(this.classWorld, coreRealm, extClassPath, extensionsEntries);
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(this.classWorld).setRealm(containerRealm).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setName("maven");
        HashSet<String> exportedArtifacts = new HashSet<String>(coreEntry.getExportedArtifacts());
        HashSet<String> exportedPackages = new HashSet<String>(coreEntry.getExportedPackages());
        for (CoreExtensionEntry extension : extensionsEntries) {
            exportedArtifacts.addAll(extension.getExportedArtifacts());
            exportedPackages.addAll(extension.getExportedPackages());
        }
        exportedPackages.add("org.codehaus.plexus.components.interactivity");
        exportedPackages.add("org.mvndaemon.mvnd.interactivity");
        exportedArtifacts.add("org.codehaus.plexus:plexus-interactivity-api");
        final CoreExports exports = new CoreExports(containerRealm, exportedArtifacts, exportedPackages);
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)DaemonMavenCli.this.slf4jLoggerFactory);
                this.bind(CoreExports.class).toInstance((Object)exports);
                this.bind(CoreExportsProvider.class).toInstance((Object)new CoreExportsProvider(exports));
                this.bind(ExtensionRealmCache.class).to(InvalidatingExtensionRealmCache.class);
                this.bind(PluginArtifactsCache.class).to(InvalidatingPluginArtifactsCache.class);
                this.bind(ProjectArtifactsCache.class).to(InvalidatingProjectArtifactsCache.class);
                this.bind(MessageBuilderFactory.class).toInstance((Object)DaemonMavenCli.this.messageBuilderFactory);
            }
        }});
        container.setLookupRealm(null);
        Thread.currentThread().setContextClassLoader((ClassLoader)container.getContainerRealm());
        container.setLoggerManager((LoggerManager)this.plexusLoggerManager);
        for (CoreExtensionEntry extension : extensionsEntries) {
            container.discoverComponents(extension.getClassRealm(), new Module[]{new SessionScopeModule((PlexusContainer)container), new MojoExecutionScopeModule((PlexusContainer)container)});
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CoreExtensionEntry> loadCoreExtensions(List<CoreExtension> extensions, ClassRealm containerRealm, Set<String> providedArtifacts) {
        List<CoreExtensionEntry> list;
        if (extensions.isEmpty()) {
            return Collections.emptyList();
        }
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(this.classWorld).setRealm(containerRealm).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setName("maven");
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)DaemonMavenCli.this.slf4jLoggerFactory);
            }
        }});
        MavenExecutionRequestPopulator executionRequestPopulator = null;
        try {
            CliRequest cliRequest = new CliRequest(new String[0], this.classWorld);
            cliRequest.commandLine = new CommandLine.Builder().build();
            container.setLookupRealm(null);
            container.setLoggerManager((LoggerManager)this.plexusLoggerManager);
            container.getLoggerManager().setThresholds(cliRequest.request.getLoggingLevel());
            Thread.currentThread().setContextClassLoader((ClassLoader)container.getContainerRealm());
            executionRequestPopulator = (MavenExecutionRequestPopulator)container.lookup(MavenExecutionRequestPopulator.class);
            Map configurationProcessors = container.lookupMap(ConfigurationProcessor.class);
            EventSpyDispatcher eventSpyDispatcher = (EventSpyDispatcher)container.lookup(EventSpyDispatcher.class);
            this.properties(cliRequest);
            DaemonMavenCli.configure(cliRequest, eventSpyDispatcher, configurationProcessors);
            LoggingExecutionListener executionListener = (LoggingExecutionListener)container.lookup(LoggingExecutionListener.class);
            this.populateRequest(cliRequest, cliRequest.request, eventSpyDispatcher, (ModelProcessor)container.lookup(ModelProcessor.class), this.createTransferListener(cliRequest), this.buildEventListener, executionListener);
            executionRequestPopulator.populateDefaults(cliRequest.request);
            BootstrapCoreExtensionManager resolver = (BootstrapCoreExtensionManager)container.lookup(BootstrapCoreExtensionManager.class);
            list = Collections.unmodifiableList(resolver.loadCoreExtensions(cliRequest.request, providedArtifacts, extensions));
            executionRequestPopulator = null;
        }
        catch (Throwable throwable) {
            try {
                executionRequestPopulator = null;
                container.dispose();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                this.slf4jLogger.warn("Failed to load extensions descriptor {}: {}", extensions, (Object)e.getMessage());
                return Collections.emptyList();
            }
        }
        container.dispose();
        return list;
    }

    private ClassRealm setupContainerRealm(ClassWorld classWorld, ClassRealm coreRealm, List<File> extClassPath, List<CoreExtensionEntry> extensions) throws Exception {
        if (!extClassPath.isEmpty() || !extensions.isEmpty()) {
            ClassRealm extRealm = classWorld.newRealm("maven.ext", null);
            extRealm.setParentRealm(coreRealm);
            this.slf4jLogger.debug("Populating class realm {}", (Object)extRealm.getId());
            for (File file : extClassPath) {
                extRealm.addURL(file.toURI().toURL());
            }
            for (CoreExtensionEntry entry : DaemonMavenCli.reverse(extensions)) {
                Set exportedPackages = entry.getExportedPackages();
                ClassRealm realm = entry.getClassRealm();
                for (String exportedPackage : exportedPackages) {
                    extRealm.importFrom((ClassLoader)realm, exportedPackage);
                }
                if (!exportedPackages.isEmpty()) continue;
                extRealm.importFrom((ClassLoader)realm, realm.getId());
            }
            return extRealm;
        }
        return coreRealm;
    }

    private static <T> List<T> reverse(List<T> list) {
        ArrayList<T> copy = new ArrayList<T>(list);
        Collections.reverse(copy);
        return copy;
    }

    private List<File> parseExtClasspath(CliRequest cliRequest) {
        String extClassPath = cliRequest.userProperties.getProperty(EXT_CLASS_PATH);
        if (extClassPath == null) {
            extClassPath = cliRequest.systemProperties.getProperty(EXT_CLASS_PATH);
        }
        ArrayList<File> jars = new ArrayList<File>();
        if (extClassPath != null) {
            for (String jar : extClassPath.split(File.pathSeparator)) {
                File file = DaemonMavenCli.resolveFile(new File(jar), cliRequest.workingDirectory);
                this.slf4jLogger.debug("  Included {}", (Object)file);
                jars.add(file);
            }
        }
        return jars;
    }

    private void encryption(CliRequest cliRequest) throws Exception {
        if (cliRequest.commandLine.hasOption("emp")) {
            throw new UnsupportedOperationException("Unsupported option: emp");
        }
        if (cliRequest.commandLine.hasOption("ep")) {
            throw new UnsupportedOperationException("Unsupported option: ep");
        }
    }

    private void environment(String workingDir, Map<String, String> clientEnv) {
        EnvHelper.environment((String)workingDir, clientEnv);
    }

    private int execute(CliRequest cliRequest) throws MavenExecutionRequestPopulationException {
        this.commands(cliRequest);
        MavenExecutionRequest request = this.executionRequestPopulator.populateDefaults(cliRequest.request);
        this.eventSpyDispatcher.onEvent((Object)request);
        this.slf4jLogger.info(MessageUtils.builder().a((CharSequence)"Processing build on daemon ").strong((Object)Environment.MVND_ID.asString()).toString());
        MavenExecutionResult result = this.maven.execute(request);
        LoggingOutputStream.forceFlush((PrintStream)System.out);
        LoggingOutputStream.forceFlush((PrintStream)System.err);
        this.eventSpyDispatcher.onEvent((Object)result);
        if (result.hasExceptions()) {
            DefaultExceptionHandler handler = new DefaultExceptionHandler();
            LinkedHashMap<String, String> references = new LinkedHashMap<String, String>();
            ArrayList<MavenProject> failedProjects = new ArrayList<MavenProject>();
            for (Throwable throwable : result.getExceptions()) {
                MavenProject project;
                ExceptionSummary summary = handler.handleException(throwable);
                this.logSummary(summary, references, "", cliRequest.showErrors);
                if (!(throwable instanceof LifecycleExecutionException) || (project = ((LifecycleExecutionException)throwable).getProject()) == null) continue;
                failedProjects.add(project);
            }
            this.slf4jLogger.error("");
            if (!cliRequest.showErrors) {
                this.slf4jLogger.error("To see the full stack trace of the errors, re-run Maven with the {} switch.", (Object)MessageUtils.builder().strong((Object)"-e"));
            }
            if (!this.slf4jLogger.isDebugEnabled()) {
                this.slf4jLogger.error("Re-run Maven using the {} switch to enable full debug logging.", (Object)MessageUtils.builder().strong((Object)"-X"));
            }
            if (!references.isEmpty()) {
                this.slf4jLogger.error("");
                this.slf4jLogger.error("For more information about the errors and possible solutions, please read the following articles:");
                for (Map.Entry entry : references.entrySet()) {
                    this.slf4jLogger.error("{} {}", (Object)MessageUtils.builder().strong(entry.getValue()), entry.getKey());
                }
            }
            if (result.canResume()) {
                this.logBuildResumeHint("mvn <args> -r");
            } else if (!failedProjects.isEmpty()) {
                List sortedProjects = result.getTopologicallySortedProjects();
                failedProjects.sort(Comparator.comparing(sortedProjects::indexOf));
                MavenProject mavenProject = (MavenProject)failedProjects.get(0);
                if (!mavenProject.equals(sortedProjects.get(0))) {
                    String resumeFromSelector = this.getResumeFromSelector(sortedProjects, mavenProject);
                    this.logBuildResumeHint("mvn <args> -rf " + resumeFromSelector);
                }
            }
            if ("FAIL_NEVER".equals(cliRequest.request.getReactorFailureBehavior())) {
                this.slf4jLogger.info("Build failures were ignored.");
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private void logBuildResumeHint(String resumeBuildHint) {
        this.slf4jLogger.error("");
        this.slf4jLogger.error("After correcting the problems, you can resume the build with the command");
        this.slf4jLogger.error(MessageUtils.builder().a((CharSequence)"  ").strong((Object)resumeBuildHint).toString());
    }

    private String getResumeFromSelector(List<MavenProject> mavenProjects, MavenProject failedProject) {
        for (MavenProject buildProject : mavenProjects) {
            if (!failedProject.getArtifactId().equals(buildProject.getArtifactId()) || failedProject.equals((Object)buildProject)) continue;
            return failedProject.getGroupId() + ":" + failedProject.getArtifactId();
        }
        return ":" + failedProject.getArtifactId();
    }

    private void logSummary(ExceptionSummary summary, Map<String, String> references, String indent, boolean showErrors) {
        String msg = summary.getMessage();
        if (!summary.getReference().isEmpty()) {
            String referenceKey = references.computeIfAbsent(summary.getReference(), k -> "[Help " + (references.size() + 1) + "]");
            msg = msg.indexOf(10) < 0 ? msg + " -> " + MessageUtils.builder().strong((Object)referenceKey) : msg + "\n-> " + MessageUtils.builder().strong((Object)referenceKey);
        }
        String[] lines = msg.split("(\r\n)|(\r)|(\n)");
        String currentColor = "";
        for (int i = 0; i < lines.length; ++i) {
            String line = currentColor + lines[i];
            Matcher matcher = LAST_ANSI_SEQUENCE.matcher(line);
            String nextColor = "";
            if (matcher.find() && ANSI_RESET.equals(nextColor = matcher.group(1))) {
                nextColor = "";
            }
            line = indent + line + ("".equals(nextColor) ? "" : ANSI_RESET);
            if (i == lines.length - 1 && (showErrors || summary.getException() instanceof InternalErrorException)) {
                this.slf4jLogger.error(line, summary.getException());
            } else {
                this.slf4jLogger.error(line);
            }
            currentColor = nextColor;
        }
        indent = indent + "  ";
        for (ExceptionSummary child : summary.getChildren()) {
            this.logSummary(child, references, indent, showErrors);
        }
    }

    private static void configure(CliRequest cliRequest, EventSpyDispatcher eventSpyDispatcher, Map<String, ConfigurationProcessor> configurationProcessors) throws Exception {
        cliRequest.request.setEventSpyDispatcher(eventSpyDispatcher);
        int userSuppliedConfigurationProcessorCount = configurationProcessors.size() - 1;
        if (userSuppliedConfigurationProcessorCount == 0) {
            configurationProcessors.get("settings").process(cliRequest);
        } else if (userSuppliedConfigurationProcessorCount == 1) {
            for (Map.Entry<String, ConfigurationProcessor> entry : configurationProcessors.entrySet()) {
                String hint = entry.getKey();
                if (hint.equals("settings")) continue;
                ConfigurationProcessor configurationProcessor = entry.getValue();
                configurationProcessor.process(cliRequest);
            }
        } else if (userSuppliedConfigurationProcessorCount > 1) {
            StringBuilder sb = new StringBuilder(String.format("\nThere can only be one user supplied ConfigurationProcessor, there are %s:\n\n", userSuppliedConfigurationProcessorCount));
            for (Map.Entry<String, ConfigurationProcessor> entry : configurationProcessors.entrySet()) {
                String hint = entry.getKey();
                if (hint.equals("settings")) continue;
                ConfigurationProcessor configurationProcessor = entry.getValue();
                sb.append(String.format("%s\n", configurationProcessor.getClass().getName()));
            }
            sb.append("\n");
            throw new Exception(sb.toString());
        }
    }

    void toolchains(CliRequest cliRequest) throws Exception {
        File globalToolchainsFile;
        File userToolchainsFile;
        if (cliRequest.commandLine.hasOption('t')) {
            userToolchainsFile = new File(cliRequest.commandLine.getOptionValue('t'));
            if (!(userToolchainsFile = DaemonMavenCli.resolveFile(userToolchainsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified user toolchains file does not exist: " + userToolchainsFile);
            }
        } else {
            userToolchainsFile = DEFAULT_USER_TOOLCHAINS_FILE;
        }
        if (cliRequest.commandLine.hasOption("gt")) {
            globalToolchainsFile = new File(cliRequest.commandLine.getOptionValue("gt"));
            if (!(globalToolchainsFile = DaemonMavenCli.resolveFile(globalToolchainsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified global toolchains file does not exist: " + globalToolchainsFile);
            }
        } else {
            globalToolchainsFile = DEFAULT_GLOBAL_TOOLCHAINS_FILE;
        }
        cliRequest.request.setGlobalToolchainsFile(globalToolchainsFile);
        cliRequest.request.setUserToolchainsFile(userToolchainsFile);
        DefaultToolchainsBuildingRequest toolchainsRequest = new DefaultToolchainsBuildingRequest();
        if (globalToolchainsFile.isFile()) {
            toolchainsRequest.setGlobalToolchainsSource((Source)new FileSource(globalToolchainsFile));
        }
        if (userToolchainsFile.isFile()) {
            toolchainsRequest.setUserToolchainsSource((Source)new FileSource(userToolchainsFile));
        }
        this.eventSpyDispatcher.onEvent((Object)toolchainsRequest);
        this.slf4jLogger.debug("Reading global toolchains from {}", this.getLocation(toolchainsRequest.getGlobalToolchainsSource(), globalToolchainsFile));
        this.slf4jLogger.debug("Reading user toolchains from {}", this.getLocation(toolchainsRequest.getUserToolchainsSource(), userToolchainsFile));
        ToolchainsBuildingResult toolchainsResult = this.toolchainsBuilder.build((ToolchainsBuildingRequest)toolchainsRequest);
        this.eventSpyDispatcher.onEvent((Object)toolchainsResult);
        this.executionRequestPopulator.populateFromToolchains(cliRequest.request, toolchainsResult.getEffectiveToolchains());
        if (!toolchainsResult.getProblems().isEmpty() && this.slf4jLogger.isWarnEnabled()) {
            this.slf4jLogger.warn("");
            this.slf4jLogger.warn("Some problems were encountered while building the effective toolchains");
            for (Problem problem : toolchainsResult.getProblems()) {
                this.slf4jLogger.warn("{} @ {}", (Object)problem.getMessage(), (Object)problem.getLocation());
            }
            this.slf4jLogger.warn("");
        }
    }

    private Object getLocation(Source source, File defaultLocation) {
        if (source != null) {
            return source.getLocation();
        }
        return defaultLocation;
    }

    private void populateRequest(CliRequest cliRequest) {
        this.populateRequest(cliRequest, cliRequest.request, this.eventSpyDispatcher, this.modelProcessor, this.createTransferListener(cliRequest), this.buildEventListener, this.executionListener);
    }

    private void populateRequest(CliRequest cliRequest, MavenExecutionRequest request, EventSpyDispatcher eventSpyDispatcher, ModelProcessor modelProcessor, TransferListener transferListener, BuildEventListener buildEventListener, LoggingExecutionListener executionListener) {
        int degreeOfConcurrency;
        String threadConfiguration;
        CommandLine commandLine = cliRequest.commandLine;
        String workingDirectory = cliRequest.workingDirectory;
        boolean quiet = cliRequest.quiet;
        boolean verbose = cliRequest.verbose;
        request.setShowErrors(cliRequest.showErrors);
        File baseDirectory = new File(workingDirectory, "").getAbsoluteFile();
        this.disableInteractiveModeIfNeeded(cliRequest, request);
        this.enableOnPresentOption(commandLine, "nsu", arg_0 -> ((MavenExecutionRequest)request).setNoSnapshotUpdates(arg_0));
        request.setGoals(commandLine.getArgList());
        request.setReactorFailureBehavior(this.determineReactorFailureBehaviour(commandLine));
        this.disableOnPresentOption(commandLine, 'N', arg_0 -> ((MavenExecutionRequest)request).setRecursive(arg_0));
        this.enableOnPresentOption(commandLine, 'o', arg_0 -> ((MavenExecutionRequest)request).setOffline(arg_0));
        this.enableOnPresentOption(commandLine, 'U', arg_0 -> ((MavenExecutionRequest)request).setUpdateSnapshots(arg_0));
        request.setGlobalChecksumPolicy(this.determineGlobalCheckPolicy(commandLine));
        request.setBaseDirectory(baseDirectory);
        request.setSystemProperties(cliRequest.systemProperties);
        request.setUserProperties(cliRequest.userProperties);
        request.setMultiModuleProjectDirectory(cliRequest.multiModuleProjectDirectory);
        request.setRootDirectory(cliRequest.rootDirectory);
        request.setTopDirectory(cliRequest.topDirectory);
        request.setPom(this.determinePom(modelProcessor, commandLine, workingDirectory, baseDirectory));
        request.setTransferListener(transferListener);
        request.setExecutionListener((ExecutionListener)executionListener);
        ExecutionEventLogger executionEventLogger = new ExecutionEventLogger(this.messageBuilderFactory);
        executionListener.init(eventSpyDispatcher.chainListener((ExecutionListener)executionEventLogger), buildEventListener);
        if (request.getPom() != null && request.getPom().getParentFile() != null) {
            request.setBaseDirectory(request.getPom().getParentFile());
        }
        request.setResumeFrom(commandLine.getOptionValue("rf"));
        this.enableOnPresentOption(commandLine, "r", arg_0 -> ((MavenExecutionRequest)request).setResume(arg_0));
        request.setMakeBehavior(this.determineMakeBehavior(commandLine));
        request.setCacheNotFound(true);
        request.setCacheTransferError(false);
        DaemonMavenCli.performProjectActivation(commandLine, request.getProjectActivation());
        DaemonMavenCli.performProfileActivation(commandLine, request.getProfileActivation());
        String localRepositoryPath = this.determineLocalRepositoryPath(request);
        if (localRepositoryPath != null) {
            request.setLocalRepositoryPath(localRepositoryPath);
        }
        if ((threadConfiguration = commandLine.getOptionValue("T")) != null && (degreeOfConcurrency = this.calculateDegreeOfConcurrency(threadConfiguration)) > 1) {
            request.setBuilderId("multithreaded");
            request.setDegreeOfConcurrency(degreeOfConcurrency);
        }
        request.setBuilderId(commandLine.getOptionValue("b", request.getBuilderId()));
    }

    private void disableInteractiveModeIfNeeded(CliRequest cliRequest, MavenExecutionRequest request) {
        CommandLine commandLine = cliRequest.getCommandLine();
        if (commandLine.hasOption("force-interactive")) {
            return;
        }
        boolean runningOnCI = DaemonMavenCli.isRunningOnCI(cliRequest.getSystemProperties());
        if (runningOnCI) {
            this.slf4jLogger.info("Making this build non-interactive, because the environment variable CI equals \"true\". Disable this detection by removing that variable or adding --force-interactive.");
            request.setInteractiveMode(false);
        } else if (commandLine.hasOption('B') || commandLine.hasOption("non-interactive")) {
            request.setInteractiveMode(false);
        }
    }

    private static boolean isRunningOnCI(Properties systemProperties) {
        String ciEnv = systemProperties.getProperty("env.CI");
        return ciEnv != null && !"false".equals(ciEnv);
    }

    private String determineLocalRepositoryPath(MavenExecutionRequest request) {
        String userDefinedLocalRepo = request.getUserProperties().getProperty(LOCAL_REPO_PROPERTY);
        if (userDefinedLocalRepo != null) {
            return userDefinedLocalRepo;
        }
        return request.getSystemProperties().getProperty(LOCAL_REPO_PROPERTY);
    }

    private File determinePom(ModelProcessor modelProcessor, CommandLine commandLine, String workingDirectory, File baseDirectory) {
        File pom;
        String alternatePomFile = null;
        if (commandLine.hasOption('f')) {
            alternatePomFile = commandLine.getOptionValue('f');
        }
        if (alternatePomFile != null) {
            File pom2 = DaemonMavenCli.resolveFile(new File(alternatePomFile), workingDirectory);
            if (pom2.isDirectory()) {
                pom2 = new File(pom2, "pom.xml");
            }
            return pom2;
        }
        if (modelProcessor != null && (pom = modelProcessor.locatePom(baseDirectory)).isFile()) {
            return pom;
        }
        return null;
    }

    static void performProjectActivation(CommandLine commandLine, ProjectActivation projectActivation) {
        if (commandLine.hasOption("pl")) {
            String[] optionValues = commandLine.getOptionValues("pl");
            if (optionValues == null || optionValues.length == 0) {
                return;
            }
            for (String optionValue : optionValues) {
                for (String token : optionValue.split(",")) {
                    String selector = token.trim();
                    boolean active = true;
                    if (selector.charAt(0) == '-' || selector.charAt(0) == '!') {
                        active = false;
                        selector = selector.substring(1);
                    } else if (token.charAt(0) == '+') {
                        selector = selector.substring(1);
                    }
                    boolean optional = selector.charAt(0) == '?';
                    selector = selector.substring(optional ? 1 : 0);
                    projectActivation.addProjectActivation(selector, active, optional);
                }
            }
        }
    }

    static void performProfileActivation(CommandLine commandLine, ProfileActivation profileActivation) {
        if (commandLine.hasOption('P')) {
            String[] optionValues = commandLine.getOptionValues('P');
            if (optionValues == null || optionValues.length == 0) {
                return;
            }
            for (String optionValue : optionValues) {
                for (String token : optionValue.split(",")) {
                    String profileId = token.trim();
                    boolean active = true;
                    if (profileId.charAt(0) == '-' || profileId.charAt(0) == '!') {
                        active = false;
                        profileId = profileId.substring(1);
                    } else if (token.charAt(0) == '+') {
                        profileId = profileId.substring(1);
                    }
                    boolean optional = profileId.charAt(0) == '?';
                    profileId = profileId.substring(optional ? 1 : 0);
                    profileActivation.addProfileActivation(profileId, active, optional);
                }
            }
        }
    }

    private ExecutionListener determineExecutionListener(EventSpyDispatcher eventSpyDispatcher) {
        ExecutionEventLogger executionListener = new ExecutionEventLogger(this.messageBuilderFactory);
        if (eventSpyDispatcher != null) {
            return eventSpyDispatcher.chainListener((ExecutionListener)executionListener);
        }
        return executionListener;
    }

    private String determineReactorFailureBehaviour(CommandLine commandLine) {
        if (commandLine.hasOption("ff")) {
            return "FAIL_FAST";
        }
        if (commandLine.hasOption("fae")) {
            return "FAIL_AT_END";
        }
        if (commandLine.hasOption("fn")) {
            return "FAIL_NEVER";
        }
        return "FAIL_FAST";
    }

    private String determineMakeBehavior(CommandLine cl) {
        if (cl.hasOption("am") && !cl.hasOption("amd")) {
            return "make-upstream";
        }
        if (!cl.hasOption("am") && cl.hasOption("amd")) {
            return "make-downstream";
        }
        if (cl.hasOption("am") && cl.hasOption("amd")) {
            return "make-both";
        }
        return null;
    }

    private String determineGlobalCheckPolicy(CommandLine commandLine) {
        if (commandLine.hasOption('C')) {
            return "fail";
        }
        if (commandLine.hasOption('c')) {
            return "warn";
        }
        return null;
    }

    private void disableOnPresentOption(CommandLine commandLine, String option, Consumer<Boolean> setting) {
        if (commandLine.hasOption(option)) {
            setting.accept(false);
        }
    }

    private void disableOnPresentOption(CommandLine commandLine, char option, Consumer<Boolean> setting) {
        this.disableOnPresentOption(commandLine, String.valueOf(option), setting);
    }

    private void enableOnPresentOption(CommandLine commandLine, String option, Consumer<Boolean> setting) {
        if (commandLine.hasOption(option)) {
            setting.accept(true);
        }
    }

    private void enableOnPresentOption(CommandLine commandLine, char option, Consumer<Boolean> setting) {
        this.enableOnPresentOption(commandLine, String.valueOf(option), setting);
    }

    private void enableOnAbsentOption(CommandLine commandLine, char option, Consumer<Boolean> setting) {
        if (!commandLine.hasOption(option)) {
            setting.accept(true);
        }
    }

    int calculateDegreeOfConcurrency(String threadConfiguration) {
        try {
            if (threadConfiguration.endsWith("C")) {
                String str = threadConfiguration.substring(0, threadConfiguration.length() - 1);
                float coreMultiplier = Float.parseFloat(str);
                if (coreMultiplier <= 0.0f) {
                    throw new IllegalArgumentException("Invalid threads core multiplier value: '" + threadConfiguration + "C'. Value must be positive.");
                }
                int procs = Runtime.getRuntime().availableProcessors();
                int threads = (int)(coreMultiplier * (float)procs);
                return threads == 0 ? 1 : threads;
            }
            int threads = Integer.parseInt(threadConfiguration);
            if (threads <= 0) {
                throw new IllegalArgumentException("Invalid threads value: '" + threadConfiguration + "'. Value must be positive.");
            }
            return threads;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid threads value: '" + threadConfiguration + "'. Supported are int and float values ending with C.");
        }
    }

    static File resolveFile(File file, String workingDirectory) {
        if (file == null) {
            return null;
        }
        if (file.isAbsolute()) {
            return file;
        }
        if (file.getPath().startsWith(File.separator)) {
            return file.getAbsoluteFile();
        }
        return new File(workingDirectory, file.getPath()).getAbsoluteFile();
    }

    static void populateProperties(CommandLine commandLine, Properties paths, Properties systemProperties, Properties userProperties) throws Exception {
        DaemonMavenCli.addEnvVars(systemProperties);
        Properties userSpecifiedProperties = commandLine.getOptionProperties(String.valueOf('D'));
        SystemProperties.addSystemProperties((Properties)systemProperties);
        Properties buildProperties = CLIReportingUtils.getBuildProperties();
        String mavenVersion = buildProperties.getProperty("version");
        systemProperties.setProperty("maven.version", mavenVersion);
        String mavenBuildVersion = CLIReportingUtils.createMavenVersionString((Properties)buildProperties);
        systemProperties.setProperty("maven.build.version", mavenBuildVersion);
        BasicInterpolator interpolator = DaemonMavenCli.createInterpolator(paths, systemProperties, userProperties, userSpecifiedProperties);
        for (Map.Entry<Object, Object> e : userSpecifiedProperties.entrySet()) {
            String name = (String)e.getKey();
            String value = interpolator.interpolate((String)e.getValue());
            userProperties.setProperty(name, value);
            if (System.getProperty(name) != null) continue;
            System.setProperty(name, value);
        }
    }

    public static void addEnvVars(Properties props) {
        if (props != null) {
            boolean caseSensitive = Os.current() == Os.WINDOWS;
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                String key = "env." + (caseSensitive ? entry.getKey() : entry.getKey().toUpperCase(Locale.ENGLISH));
                props.setProperty(key, entry.getValue());
            }
        }
    }

    private static void setCliProperty(String name, String value, Properties properties) {
        properties.setProperty(name, value);
        System.setProperty(name, value);
    }

    private static Path getCanonicalPath(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return DaemonMavenCli.getCanonicalPath(path.getParent()).resolve(path.getFileName());
        }
    }

    private static BasicInterpolator createInterpolator(final Properties ... properties) {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.addValueSource((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                for (Properties props : properties) {
                    String val = props.getProperty(expression);
                    if (val == null) continue;
                    return val;
                }
                return null;
            }
        });
        return interpolator;
    }

    protected TransferListener createTransferListener(CliRequest cliRequest) {
        if (cliRequest.quiet || cliRequest.commandLine.hasOption("ntp")) {
            return new QuietMavenTransferListener();
        }
        if (cliRequest.request.isInteractiveMode() && !cliRequest.commandLine.hasOption("l")) {
            return this.getConsoleTransferListener();
        }
        return this.getBatchTransferListener();
    }

    protected TransferListener getConsoleTransferListener() {
        return new DaemonMavenTransferListener(this.buildEventListener, (TransferListener)new Slf4jMavenTransferListener());
    }

    protected TransferListener getBatchTransferListener() {
        return new Slf4jMavenTransferListener();
    }

    protected ModelProcessor createModelProcessor(PlexusContainer container) throws ComponentLookupException {
        return (ModelProcessor)container.lookup(ModelProcessor.class);
    }

    static class ExitException
    extends Exception {
        static final long serialVersionUID = 1L;
        int exitCode;

        ExitException(int exitCode) {
            this.exitCode = exitCode;
        }
    }
}

