/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Parent
implements Serializable,
InputLocationTracker {
    final String groupId;
    final String artifactId;
    final String version;
    final String relativePath;
    final Map<Object, InputLocation> locations;

    Parent(String groupId, String artifactId, String version, String relativePath, Map<Object, InputLocation> locations) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.relativePath = relativePath;
        this.locations = ImmutableCollections.copy(locations);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Parent.newBuilder(this);
    }

    @Nonnull
    public Parent withGroupId(String groupId) {
        return Parent.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public Parent withArtifactId(String artifactId) {
        return Parent.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public Parent withVersion(String version) {
        return Parent.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public Parent withRelativePath(String relativePath) {
        return Parent.newBuilder(this, true).relativePath(relativePath).build();
    }

    @Nonnull
    public static Parent newInstance() {
        return Parent.newInstance(true);
    }

    @Nonnull
    public static Parent newInstance(boolean withDefaults) {
        return Parent.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Parent.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Parent from) {
        return Parent.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Parent from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String getId() {
        StringBuilder id = new StringBuilder(64);
        id.append(this.getGroupId());
        id.append(":");
        id.append(this.getArtifactId());
        id.append(":");
        id.append("pom");
        id.append(":");
        id.append(this.getVersion());
        return id.toString();
    }

    public String toString() {
        return this.getId();
    }

    @NotThreadSafe
    public static class Builder {
        Parent base;
        String groupId;
        String artifactId;
        String version;
        String relativePath;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.relativePath = "../pom.xml";
            }
        }

        Builder(Parent base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.relativePath = base.relativePath;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder relativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Parent build() {
            if (!(this.base == null || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.relativePath != null && this.relativePath != this.base.relativePath)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            Object location = null;
            Object groupIdLocation = null;
            Object artifactIdLocation = null;
            Object versionLocation = null;
            Object relativePathLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new Parent(this.groupId != null ? this.groupId : (this.base != null ? this.base.groupId : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), this.relativePath != null ? this.relativePath : (this.base != null ? this.base.relativePath : null), locations != null ? locations : (this.base != null ? this.base.locations : null));
        }
    }
}

