/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.Contributor;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Developer
extends Contributor
implements Serializable,
InputLocationTracker {
    final String id;

    Developer(String name, String email, String url, String organization, String organizationUrl, Collection<String> roles, String timezone, Map<String, String> properties, String id, Map<Object, InputLocation> locations) {
        super(name, email, url, organization, organizationUrl, roles, timezone, properties, locations);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Developer.newBuilder(this);
    }

    @Override
    @Nonnull
    public Developer withName(String name) {
        return Developer.newBuilder(this, true).name(name).build();
    }

    @Override
    @Nonnull
    public Developer withEmail(String email) {
        return Developer.newBuilder(this, true).email(email).build();
    }

    @Override
    @Nonnull
    public Developer withUrl(String url) {
        return Developer.newBuilder(this, true).url(url).build();
    }

    @Override
    @Nonnull
    public Developer withOrganization(String organization) {
        return Developer.newBuilder(this, true).organization(organization).build();
    }

    @Override
    @Nonnull
    public Developer withOrganizationUrl(String organizationUrl) {
        return Developer.newBuilder(this, true).organizationUrl(organizationUrl).build();
    }

    @Override
    @Nonnull
    public Developer withRoles(Collection<String> roles) {
        return ((Builder)Developer.newBuilder(this, true).roles((Collection)roles)).build();
    }

    @Override
    @Nonnull
    public Developer withTimezone(String timezone) {
        return Developer.newBuilder(this, true).timezone(timezone).build();
    }

    @Override
    @Nonnull
    public Developer withProperties(Map<String, String> properties) {
        return ((Builder)Developer.newBuilder(this, true).properties((Map)properties)).build();
    }

    @Nonnull
    public Developer withId(String id) {
        return Developer.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public static Developer newInstance() {
        return Developer.newInstance(true);
    }

    @Nonnull
    public static Developer newInstance(boolean withDefaults) {
        return Developer.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Developer.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Developer from) {
        return Developer.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Developer from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @Override
    public String toString() {
        return "Developer {id=" + this.getId() + ", " + super.toString() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends Contributor.Builder {
        Developer base;
        String id;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Developer base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @Nonnull
        public Builder email(String email) {
            this.email = email;
            return this;
        }

        @Override
        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        @Nonnull
        public Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        @Override
        @Nonnull
        public Builder organizationUrl(String organizationUrl) {
            this.organizationUrl = organizationUrl;
            return this;
        }

        @Override
        @Nonnull
        public Builder roles(Collection<String> roles) {
            this.roles = roles;
            return this;
        }

        @Override
        @Nonnull
        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Developer build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.email != null && this.email != this.base.email || this.url != null && this.url != this.base.url || this.organization != null && this.organization != this.base.organization || this.organizationUrl != null && this.organizationUrl != this.base.organizationUrl || this.roles != null && this.roles != this.base.roles || this.timezone != null && this.timezone != this.base.timezone || this.properties != null && this.properties != this.base.properties || this.id != null && this.id != this.base.id)) {
                return this.base;
            }
            Map locations = null;
            Object location = null;
            Object nameLocation = null;
            Object emailLocation = null;
            Object urlLocation = null;
            Object organizationLocation = null;
            Object organizationUrlLocation = null;
            Object rolesLocation = null;
            Object timezoneLocation = null;
            Object propertiesLocation = null;
            Object idLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new Developer(this.name != null ? this.name : (this.base != null ? this.base.name : null), this.email != null ? this.email : (this.base != null ? this.base.email : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), this.organization != null ? this.organization : (this.base != null ? this.base.organization : null), this.organizationUrl != null ? this.organizationUrl : (this.base != null ? this.base.organizationUrl : null), this.roles != null ? this.roles : (this.base != null ? this.base.roles : null), this.timezone != null ? this.timezone : (this.base != null ? this.base.timezone : null), this.properties != null ? this.properties : (this.base != null ? this.base.properties : null), this.id != null ? this.id : (this.base != null ? this.base.id : null), locations != null ? locations : (this.base != null ? this.base.locations : null));
        }
    }
}

