/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Contributor
implements Serializable,
InputLocationTracker {
    final String name;
    final String email;
    final String url;
    final String organization;
    final String organizationUrl;
    final List<String> roles;
    final String timezone;
    final Map<String, String> properties;
    final Map<Object, InputLocation> locations;

    Contributor(String name, String email, String url, String organization, String organizationUrl, Collection<String> roles, String timezone, Map<String, String> properties, Map<Object, InputLocation> locations) {
        this.name = name;
        this.email = email;
        this.url = url;
        this.organization = organization;
        this.organizationUrl = organizationUrl;
        this.roles = ImmutableCollections.copy(roles);
        this.timezone = timezone;
        this.properties = ImmutableCollections.copy(properties);
        this.locations = ImmutableCollections.copy(locations);
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUrl() {
        return this.url;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    @Nonnull
    public List<String> getRoles() {
        return this.roles;
    }

    public String getTimezone() {
        return this.timezone;
    }

    @Nonnull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Contributor.newBuilder(this);
    }

    @Nonnull
    public Contributor withName(String name) {
        return Contributor.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public Contributor withEmail(String email) {
        return Contributor.newBuilder(this, true).email(email).build();
    }

    @Nonnull
    public Contributor withUrl(String url) {
        return Contributor.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public Contributor withOrganization(String organization) {
        return Contributor.newBuilder(this, true).organization(organization).build();
    }

    @Nonnull
    public Contributor withOrganizationUrl(String organizationUrl) {
        return Contributor.newBuilder(this, true).organizationUrl(organizationUrl).build();
    }

    @Nonnull
    public Contributor withRoles(Collection<String> roles) {
        return Contributor.newBuilder(this, true).roles(roles).build();
    }

    @Nonnull
    public Contributor withTimezone(String timezone) {
        return Contributor.newBuilder(this, true).timezone(timezone).build();
    }

    @Nonnull
    public Contributor withProperties(Map<String, String> properties) {
        return Contributor.newBuilder(this, true).properties(properties).build();
    }

    @Nonnull
    public static Contributor newInstance() {
        return Contributor.newInstance(true);
    }

    @Nonnull
    public static Contributor newInstance(boolean withDefaults) {
        return Contributor.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Contributor.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Contributor from) {
        return Contributor.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Contributor from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        return "Contributor {name=" + this.getName() + ", email=" + this.getEmail() + "}";
    }

    @NotThreadSafe
    public static class Builder {
        Contributor base;
        String name;
        String email;
        String url;
        String organization;
        String organizationUrl;
        Collection<String> roles;
        String timezone;
        Map<String, String> properties;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Contributor base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.email = base.email;
                this.url = base.url;
                this.organization = base.organization;
                this.organizationUrl = base.organizationUrl;
                this.roles = base.roles;
                this.timezone = base.timezone;
                this.properties = base.properties;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder email(String email) {
            this.email = email;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        @Nonnull
        public Builder organizationUrl(String organizationUrl) {
            this.organizationUrl = organizationUrl;
            return this;
        }

        @Nonnull
        public Builder roles(Collection<String> roles) {
            this.roles = roles;
            return this;
        }

        @Nonnull
        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Contributor build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.email != null && this.email != this.base.email || this.url != null && this.url != this.base.url || this.organization != null && this.organization != this.base.organization || this.organizationUrl != null && this.organizationUrl != this.base.organizationUrl || this.roles != null && this.roles != this.base.roles || this.timezone != null && this.timezone != this.base.timezone || this.properties != null && this.properties != this.base.properties)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            Object location = null;
            Object nameLocation = null;
            Object emailLocation = null;
            Object urlLocation = null;
            Object organizationLocation = null;
            Object organizationUrlLocation = null;
            Object rolesLocation = null;
            Object timezoneLocation = null;
            Object propertiesLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new Contributor(this.name != null ? this.name : (this.base != null ? this.base.name : null), this.email != null ? this.email : (this.base != null ? this.base.email : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), this.organization != null ? this.organization : (this.base != null ? this.base.organization : null), this.organizationUrl != null ? this.organizationUrl : (this.base != null ? this.base.organizationUrl : null), this.roles != null ? this.roles : (this.base != null ? this.base.roles : null), this.timezone != null ? this.timezone : (this.base != null ? this.base.timezone : null), this.properties != null ? this.properties : (this.base != null ? this.base.properties : null), locations != null ? locations : (this.base != null ? this.base.locations : null));
        }
    }
}

