/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class ActivationProperty
implements Serializable,
InputLocationTracker {
    final String name;
    final String value;
    final Map<Object, InputLocation> locations;

    ActivationProperty(String name, String value, Map<Object, InputLocation> locations) {
        this.name = name;
        this.value = value;
        this.locations = ImmutableCollections.copy(locations);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return ActivationProperty.newBuilder(this);
    }

    @Nonnull
    public ActivationProperty withName(String name) {
        return ActivationProperty.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public ActivationProperty withValue(String value) {
        return ActivationProperty.newBuilder(this, true).value(value).build();
    }

    @Nonnull
    public static ActivationProperty newInstance() {
        return ActivationProperty.newInstance(true);
    }

    @Nonnull
    public static ActivationProperty newInstance(boolean withDefaults) {
        return ActivationProperty.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return ActivationProperty.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(ActivationProperty from) {
        return ActivationProperty.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(ActivationProperty from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        ActivationProperty base;
        String name;
        String value;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(ActivationProperty base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.value = base.value;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder value(String value) {
            this.value = value;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public ActivationProperty build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.value != null && this.value != this.base.value)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            Object location = null;
            Object nameLocation = null;
            Object valueLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new ActivationProperty(this.name != null ? this.name : (this.base != null ? this.base.name : null), this.value != null ? this.value : (this.base != null ? this.base.value : null), locations != null ? locations : (this.base != null ? this.base.locations : null));
        }
    }
}

