/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.MavenPluginPrerequisitesChecker;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class MavenPluginMavenPrerequisiteChecker
implements MavenPluginPrerequisitesChecker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RuntimeInformation runtimeInformation;

    @Inject
    public MavenPluginMavenPrerequisiteChecker(RuntimeInformation runtimeInformation) {
        this.runtimeInformation = runtimeInformation;
    }

    @Override
    public void accept(PluginDescriptor pluginDescriptor) {
        String requiredMavenVersion = pluginDescriptor.getRequiredMavenVersion();
        if (StringUtils.isNotBlank((String)requiredMavenVersion)) {
            boolean isRequirementMet = false;
            try {
                isRequirementMet = this.runtimeInformation.isMavenVersion(requiredMavenVersion);
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Could not verify plugin's Maven prerequisite as an invalid version is given in " + requiredMavenVersion, (Throwable)e);
                return;
            }
            if (!isRequirementMet) {
                throw new IllegalStateException("Required Maven version " + requiredMavenVersion + " is not met by current version " + this.runtimeInformation.getMavenVersion());
            }
        }
    }
}

