/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.RepositoryPolicy;
import org.apache.maven.api.services.RepositoryFactory;
import org.apache.maven.internal.impl.DefaultLocalRepository;
import org.apache.maven.internal.impl.DefaultRemoteRepository;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;

@Named
@Singleton
public class DefaultRepositoryFactory
implements RepositoryFactory {
    private final RepositorySystem repositorySystem;

    @Inject
    public DefaultRepositoryFactory(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    public org.apache.maven.api.LocalRepository createLocal(Path path) {
        return new DefaultLocalRepository(new LocalRepository(path.toFile()));
    }

    public RemoteRepository createRemote(String id, String url) {
        return new DefaultRemoteRepository(new RemoteRepository.Builder(id, "default", url).build());
    }

    public RemoteRepository createRemote(Repository repository) throws IllegalArgumentException {
        return new DefaultRemoteRepository(new RemoteRepository.Builder(repository.getId(), repository.getLayout(), repository.getUrl()).setReleasePolicy(DefaultRepositoryFactory.buildRepositoryPolicy(repository.getReleases())).setSnapshotPolicy(DefaultRepositoryFactory.buildRepositoryPolicy(repository.getSnapshots())).build());
    }

    public static org.eclipse.aether.repository.RepositoryPolicy buildRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String updatePolicy = "daily";
        String checksumPolicy = "fail";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updatePolicy = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksumPolicy = policy.getChecksumPolicy();
            }
        }
        return new org.eclipse.aether.repository.RepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }
}

