/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Objects;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.Version;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.internal.impl.AbstractSession;
import org.apache.maven.internal.impl.DefaultVersionParser;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.artifact.Artifact;

public class DefaultArtifact
implements org.apache.maven.api.Artifact {
    @Nonnull
    private final AbstractSession session;
    @Nonnull
    private final Artifact artifact;
    private final String id;

    public DefaultArtifact(@Nonnull AbstractSession session, @Nonnull Artifact artifact) {
        this.session = Utils.nonNull(session, "session can not be null");
        this.artifact = Utils.nonNull(artifact, "artifact can not be null");
        this.id = this.getGroupId() + ':' + this.getArtifactId() + ':' + this.getExtension() + (this.getClassifier().length() > 0 ? ":" + this.getClassifier() : "") + ':' + this.getVersion();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String key() {
        return this.id;
    }

    @Nonnull
    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    @Nonnull
    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    @Nonnull
    public Version getVersion() {
        return this.session.parseVersion(this.artifact.getVersion());
    }

    @Nonnull
    public String getExtension() {
        return this.artifact.getExtension();
    }

    @Nonnull
    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    public boolean isSnapshot() {
        return DefaultVersionParser.checkSnapshot(this.artifact.getVersion());
    }

    @Nonnull
    public ArtifactCoordinate toCoordinate() {
        return this.session.createArtifactCoordinate(this);
    }

    public boolean equals(Object o) {
        return o instanceof DefaultArtifact && Objects.equals(this.id, ((DefaultArtifact)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.artifact.toString();
    }
}

