/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.v4;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.ActivationProperty;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.RepositoryBase;
import org.apache.maven.api.settings.RepositoryPolicy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.api.settings.TrackableBase;
import org.apache.maven.api.xml.XmlNode;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

@Generated
public class SettingsXpp3WriterEx {
    private static final String NAMESPACE = null;
    private String fileComment = null;
    protected InputLocation.StringFormatter stringFormatter;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void setStringFormatter(InputLocation.StringFormatter stringFormatter) {
        this.stringFormatter = stringFormatter;
    }

    public void write(Writer writer, Settings settings) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(settings.getModelEncoding(), null);
        this.writeSettings("settings", settings, (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, Settings settings) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, settings.getModelEncoding());
        serializer.startDocument(settings.getModelEncoding(), null);
        this.writeSettings("settings", settings, (XmlSerializer)serializer);
        serializer.endDocument();
    }

    protected void writeDomToSerializer(XmlNode dom, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, dom.getName());
        for (Map.Entry attribute : dom.getAttributes().entrySet()) {
            serializer.attribute(NAMESPACE, (String)attribute.getKey(), (String)attribute.getValue());
        }
        for (XmlNode aChild : dom.getChildren()) {
            this.writeDomToSerializer(aChild, serializer);
        }
        String value = dom.getValue();
        if (value != null) {
            serializer.text(value);
        }
        serializer.endTag(NAMESPACE, dom.getName());
    }

    private void writeTrackableBase(String tagName, TrackableBase trackableBase, XmlSerializer serializer) throws IOException {
        if (trackableBase != null) {
            serializer.startTag(NAMESPACE, tagName);
            serializer.endTag(NAMESPACE, tagName);
            this.writeLocationTracking((InputLocationTracker)trackableBase, "", serializer);
        }
    }

    private void writeIdentifiableBase(String tagName, IdentifiableBase identifiableBase, XmlSerializer serializer) throws IOException {
        if (identifiableBase != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("id", "default", identifiableBase.getId(), serializer, (InputLocationTracker)identifiableBase);
            serializer.endTag(NAMESPACE, tagName);
            this.writeLocationTracking((InputLocationTracker)identifiableBase, "", serializer);
        }
    }

    private void writeSettings(String tagName, Settings settings, XmlSerializer serializer) throws IOException {
        if (settings != null) {
            if (this.fileComment != null) {
                serializer.comment(this.fileComment);
            }
            serializer.setPrefix("", "http://maven.apache.org/POM/4.0.0");
            serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.startTag(NAMESPACE, tagName);
            serializer.attribute("", "xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd");
            this.writeTag("localRepository", null, settings.getLocalRepository(), serializer, (InputLocationTracker)settings);
            this.writeTag("interactiveMode", "true", settings.isInteractiveMode() ? null : "false", serializer, (InputLocationTracker)settings);
            this.writeTag("usePluginRegistry", "false", settings.isUsePluginRegistry() ? "true" : null, serializer, (InputLocationTracker)settings);
            this.writeTag("offline", "false", settings.isOffline() ? "true" : null, serializer, (InputLocationTracker)settings);
            this.writeList("proxies", false, settings.getProxies(), serializer, (InputLocationTracker)settings, t -> this.writeProxy("proxy", (Proxy)t, serializer));
            this.writeList("servers", false, settings.getServers(), serializer, (InputLocationTracker)settings, t -> this.writeServer("server", (Server)t, serializer));
            this.writeList("mirrors", false, settings.getMirrors(), serializer, (InputLocationTracker)settings, t -> this.writeMirror("mirror", (Mirror)t, serializer));
            this.writeList("repositories", false, settings.getRepositories(), serializer, (InputLocationTracker)settings, t -> this.writeRepository("repository", (Repository)t, serializer));
            this.writeList("pluginRepositories", false, settings.getPluginRepositories(), serializer, (InputLocationTracker)settings, t -> this.writeRepository("pluginRepository", (Repository)t, serializer));
            this.writeList("profiles", false, settings.getProfiles(), serializer, (InputLocationTracker)settings, t -> this.writeProfile("profile", (Profile)t, serializer));
            this.writeList("activeProfiles", settings.getActiveProfiles(), serializer, (InputLocationTracker)settings, t -> this.writeTag("activeProfile", null, (String)t, serializer, null));
            this.writeList("pluginGroups", settings.getPluginGroups(), serializer, (InputLocationTracker)settings, t -> this.writeTag("pluginGroup", null, (String)t, serializer, null));
            serializer.endTag(NAMESPACE, tagName);
            this.writeLocationTracking((InputLocationTracker)settings, "", serializer);
        }
    }

    private void writeProxy(String tagName, Proxy proxy, XmlSerializer serializer) throws IOException {
        if (proxy != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("active", "true", proxy.isActive() ? null : "false", serializer, (InputLocationTracker)proxy);
            this.writeTag("protocol", "http", proxy.getProtocol(), serializer, (InputLocationTracker)proxy);
            this.writeTag("username", null, proxy.getUsername(), serializer, (InputLocationTracker)proxy);
            this.writeTag("password", null, proxy.getPassword(), serializer, (InputLocationTracker)proxy);
            this.writeTag("port", "8080", Integer.toString(proxy.getPort()), serializer, (InputLocationTracker)proxy);
            this.writeTag("host", null, proxy.getHost(), serializer, (InputLocationTracker)proxy);
            this.writeTag("nonProxyHosts", null, proxy.getNonProxyHosts(), serializer, (InputLocationTracker)proxy);
            this.writeTag("id", "default", proxy.getId(), serializer, (InputLocationTracker)proxy);
            serializer.endTag(NAMESPACE, tagName);
            this.writeLocationTracking((InputLocationTracker)proxy, "", serializer);
        }
    }

    private void writeServer(String tagName, Server server, XmlSerializer serializer) throws IOException {
        if (server != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("username", null, server.getUsername(), serializer, (InputLocationTracker)server);
            this.writeTag("password", null, server.getPassword(), serializer, (InputLocationTracker)server);
            this.writeTag("privateKey", null, server.getPrivateKey(), serializer, (InputLocationTracker)server);
            this.writeTag("passphrase", null, server.getPassphrase(), serializer, (InputLocationTracker)server);
            this.writeTag("filePermissions", null, server.getFilePermissions(), serializer, (InputLocationTracker)server);
            this.writeTag("directoryPermissions", null, server.getDirectoryPermissions(), serializer, (InputLocationTracker)server);
            this.writeDom(server.getConfiguration(), serializer);
            this.writeTag("id", "default", server.getId(), serializer, (InputLocationTracker)server);
            serializer.endTag(NAMESPACE, tagName);
            this.writeLocationTracking((InputLocationTracker)server, "", serializer);
        }
    }

    private void writeMirror(String tagName, Mirror mirror, XmlSerializer serializer) throws IOException {
        if (mirror != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("mirrorOf", null, mirror.getMirrorOf(), serializer, (InputLocationTracker)mirror);
            this.writeTag("name", null, mirror.getName(), serializer, (InputLocationTracker)mirror);
            this.writeTag("url", null, mirror.getUrl(), serializer, (InputLocationTracker)mirror);
            this.writeTag("layout", "default", mirror.getLayout(), serializer, (InputLocationTracker)mirror);
            this.writeTag("mirrorOfLayouts", "default,legacy", mirror.getMirrorOfLayouts(), serializer, (InputLocationTracker)mirror);
            this.writeTag("blocked", "false", mirror.isBlocked() ? "true" : null, serializer, (InputLocationTracker)mirror);
            this.writeTag("id", "default", mirror.getId(), serializer, (InputLocationTracker)mirror);
            serializer.endTag(NAMESPACE, tagName);
            this.writeLocationTracking((InputLocationTracker)mirror, "", serializer);
        }
    }

    private void writeProfile(String tagName, Profile profile, XmlSerializer serializer) throws IOException {
        if (profile != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeActivation("activation", profile.getActivation(), serializer);
            this.writeProperties("properties", profile.getProperties(), serializer, (InputLocationTracker)profile);
            this.writeList("repositories", false, profile.getRepositories(), serializer, (InputLocationTracker)profile, t -> this.writeRepository("repository", (Repository)t, serializer));
            this.writeList("pluginRepositories", false, profile.getPluginRepositories(), serializer, (InputLocationTracker)profile, t -> this.writeRepository("pluginRepository", (Repository)t, serializer));
            this.writeTag("id", "default", profile.getId(), serializer, (InputLocationTracker)profile);
            serializer.endTag(NAMESPACE, tagName);
            this.writeLocationTracking((InputLocationTracker)profile, "", serializer);
        }
    }

    private void writeActivation(String tagName, Activation activation, XmlSerializer serializer) throws IOException {
        if (activation != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("activeByDefault", "false", activation.isActiveByDefault() ? "true" : null, serializer, (InputLocationTracker)activation);
            this.writeTag("jdk", null, activation.getJdk(), serializer, (InputLocationTracker)activation);
            this.writeActivationOS("os", activation.getOs(), serializer);
            this.writeActivationProperty("property", activation.getProperty(), serializer);
            this.writeActivationFile("file", activation.getFile(), serializer);
            serializer.endTag(NAMESPACE, tagName);
            this.writeLocationTracking((InputLocationTracker)activation, "", serializer);
        }
    }

    private void writeRepositoryBase(String tagName, RepositoryBase repositoryBase, XmlSerializer serializer) throws IOException {
        if (repositoryBase != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("name", null, repositoryBase.getName(), serializer, (InputLocationTracker)repositoryBase);
            this.writeTag("url", null, repositoryBase.getUrl(), serializer, (InputLocationTracker)repositoryBase);
            this.writeTag("layout", "default", repositoryBase.getLayout(), serializer, (InputLocationTracker)repositoryBase);
            this.writeTag("id", "default", repositoryBase.getId(), serializer, (InputLocationTracker)repositoryBase);
            serializer.endTag(NAMESPACE, tagName);
            this.writeLocationTracking((InputLocationTracker)repositoryBase, "", serializer);
        }
    }

    private void writeRepository(String tagName, Repository repository, XmlSerializer serializer) throws IOException {
        if (repository != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeRepositoryPolicy("releases", repository.getReleases(), serializer);
            this.writeRepositoryPolicy("snapshots", repository.getSnapshots(), serializer);
            this.writeTag("name", null, repository.getName(), serializer, (InputLocationTracker)repository);
            this.writeTag("url", null, repository.getUrl(), serializer, (InputLocationTracker)repository);
            this.writeTag("layout", "default", repository.getLayout(), serializer, (InputLocationTracker)repository);
            this.writeTag("id", "default", repository.getId(), serializer, (InputLocationTracker)repository);
            serializer.endTag(NAMESPACE, tagName);
            this.writeLocationTracking((InputLocationTracker)repository, "", serializer);
        }
    }

    private void writeRepositoryPolicy(String tagName, RepositoryPolicy repositoryPolicy, XmlSerializer serializer) throws IOException {
        if (repositoryPolicy != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("enabled", "true", repositoryPolicy.isEnabled() ? null : "false", serializer, (InputLocationTracker)repositoryPolicy);
            this.writeTag("updatePolicy", null, repositoryPolicy.getUpdatePolicy(), serializer, (InputLocationTracker)repositoryPolicy);
            this.writeTag("checksumPolicy", null, repositoryPolicy.getChecksumPolicy(), serializer, (InputLocationTracker)repositoryPolicy);
            serializer.endTag(NAMESPACE, tagName);
            this.writeLocationTracking((InputLocationTracker)repositoryPolicy, "", serializer);
        }
    }

    private void writeActivationProperty(String tagName, ActivationProperty activationProperty, XmlSerializer serializer) throws IOException {
        if (activationProperty != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("name", null, activationProperty.getName(), serializer, (InputLocationTracker)activationProperty);
            this.writeTag("value", null, activationProperty.getValue(), serializer, (InputLocationTracker)activationProperty);
            serializer.endTag(NAMESPACE, tagName);
            this.writeLocationTracking((InputLocationTracker)activationProperty, "", serializer);
        }
    }

    private void writeActivationOS(String tagName, ActivationOS activationOS, XmlSerializer serializer) throws IOException {
        if (activationOS != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("name", null, activationOS.getName(), serializer, (InputLocationTracker)activationOS);
            this.writeTag("family", null, activationOS.getFamily(), serializer, (InputLocationTracker)activationOS);
            this.writeTag("arch", null, activationOS.getArch(), serializer, (InputLocationTracker)activationOS);
            this.writeTag("version", null, activationOS.getVersion(), serializer, (InputLocationTracker)activationOS);
            serializer.endTag(NAMESPACE, tagName);
            this.writeLocationTracking((InputLocationTracker)activationOS, "", serializer);
        }
    }

    private void writeActivationFile(String tagName, ActivationFile activationFile, XmlSerializer serializer) throws IOException {
        if (activationFile != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("missing", null, activationFile.getMissing(), serializer, (InputLocationTracker)activationFile);
            this.writeTag("exists", null, activationFile.getExists(), serializer, (InputLocationTracker)activationFile);
            serializer.endTag(NAMESPACE, tagName);
            this.writeLocationTracking((InputLocationTracker)activationFile, "", serializer);
        }
    }

    private <T> void writeList(String tagName, List<T> list, XmlSerializer serializer, InputLocationTracker locationTracker, ElementWriter<T> writer) throws IOException {
        this.writeList(tagName, false, list, serializer, locationTracker, writer);
    }

    private <T> void writeList(String tagName, boolean flat, List<T> list, XmlSerializer serializer, InputLocationTracker locationTracker, ElementWriter<T> writer) throws IOException {
        if (list != null && !list.isEmpty()) {
            if (!flat) {
                serializer.startTag(NAMESPACE, tagName);
            }
            int index = 0;
            InputLocation location = locationTracker != null ? locationTracker.getLocation((Object)tagName) : null;
            for (T t : list) {
                writer.write(t);
                this.writeLocationTracking((InputLocationTracker)location, index++, serializer);
            }
            if (!flat) {
                serializer.endTag(NAMESPACE, tagName);
                this.writeLocationTracking(locationTracker, tagName, serializer);
            }
        }
    }

    private <T> void writeProperties(String tagName, Map<String, String> props, XmlSerializer serializer, InputLocationTracker locationTracker) throws IOException {
        if (props != null && !props.isEmpty()) {
            serializer.startTag(NAMESPACE, tagName);
            InputLocation location = locationTracker != null ? locationTracker.getLocation((Object)tagName) : null;
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String key = entry.getKey();
                this.writeTag(key, null, entry.getValue(), serializer, null);
                this.writeLocationTracking((InputLocationTracker)location, key, serializer);
            }
            serializer.endTag(NAMESPACE, tagName);
            this.writeLocationTracking(locationTracker, tagName, serializer);
        }
    }

    private void writeDom(XmlNode dom, XmlSerializer serializer) throws IOException {
        if (dom != null) {
            serializer.startTag(NAMESPACE, dom.getName());
            for (Map.Entry attr : dom.getAttributes().entrySet()) {
                serializer.attribute(NAMESPACE, (String)attr.getKey(), (String)attr.getValue());
            }
            for (XmlNode child : dom.getChildren()) {
                this.writeDom(child, serializer);
            }
            String value = dom.getValue();
            if (value != null) {
                serializer.text(value);
            }
            serializer.endTag(NAMESPACE, dom.getName());
        }
    }

    private void writeTag(String tagName, String defaultValue, String value, XmlSerializer serializer, InputLocationTracker locationTracker) throws IOException {
        if (value != null && !Objects.equals(defaultValue, value)) {
            serializer.startTag(NAMESPACE, tagName).text(value).endTag(NAMESPACE, tagName);
            this.writeLocationTracking(locationTracker, tagName, serializer);
        }
    }

    private void writeAttr(String attrName, String value, XmlSerializer serializer) throws IOException {
        if (value != null) {
            serializer.attribute(NAMESPACE, attrName, value);
        }
    }

    protected void writeLocationTracking(InputLocationTracker locationTracker, Object key, XmlSerializer serializer) throws IOException {
        InputLocation location;
        InputLocation inputLocation = location = locationTracker == null ? null : locationTracker.getLocation(key);
        if (location != null) {
            serializer.comment(this.toString(location));
        }
    }

    protected String toString(InputLocation location) {
        if (this.stringFormatter != null) {
            return this.stringFormatter.toString(location);
        }
        return ' ' + location.getSource().toString() + ':' + location.getLineNumber() + ' ';
    }

    @FunctionalInterface
    private static interface ElementWriter<T> {
        public void write(T var1) throws IOException;
    }
}

