/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.builder.smart;

import io.takari.maven.builder.smart.DependencyGraph;
import io.takari.maven.builder.smart.ReactorBuildStats;
import io.takari.maven.builder.smart.SmartBuilderImpl;
import java.text.NumberFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.lifecycle.internal.builder.Builder;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="smart")
public class SmartBuilder
implements Builder {
    public static final String PROP_PROFILING = "smartbuilder.profiling";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LifecycleModuleBuilder moduleBuilder;
    private volatile SmartBuilderImpl builder;
    private volatile boolean canceled;
    private static SmartBuilder INSTANCE;

    public static SmartBuilder cancel() {
        SmartBuilder builder = INSTANCE;
        if (builder != null) {
            builder.doCancel();
        }
        return builder;
    }

    @Inject
    public SmartBuilder(LifecycleModuleBuilder moduleBuilder) {
        this.moduleBuilder = moduleBuilder;
        INSTANCE = this;
    }

    void doCancel() {
        this.canceled = true;
        SmartBuilderImpl b = this.builder;
        if (b != null) {
            b.cancel();
        }
    }

    public void doneCancel() {
        this.canceled = false;
    }

    public synchronized void build(MavenSession session, ReactorContext reactorContext, ProjectBuildList projectBuilds, List<TaskSegment> taskSegments, ReactorBuildStatus reactorBuildStatus) throws ExecutionException, InterruptedException {
        session.getRepositorySession().getData().set(ReactorBuildStatus.class, (Object)reactorBuildStatus);
        DependencyGraph<MavenProject> graph = DependencyGraph.fromMaven(session);
        int degreeOfConcurrency = session.getRequest().getDegreeOfConcurrency();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Task segments : {}", taskSegments);
            this.logger.debug("Build maximum degree of concurrency is {}", (Object)degreeOfConcurrency);
            this.logger.debug("Total number of projects is {}", (Object)graph.getProjects().count());
        }
        ArrayList<AbstractMap.SimpleEntry<TaskSegment, ReactorBuildStats>> allstats = new ArrayList<AbstractMap.SimpleEntry<TaskSegment, ReactorBuildStats>>();
        for (TaskSegment taskSegment : taskSegments) {
            Set projects = projectBuilds.getByTaskSegment(taskSegment).getProjects();
            if (this.canceled) {
                return;
            }
            this.builder = new SmartBuilderImpl(this.moduleBuilder, session, reactorContext, taskSegment, projects, graph);
            try {
                ReactorBuildStats stats = this.builder.build();
                allstats.add(new AbstractMap.SimpleEntry<TaskSegment, ReactorBuildStats>(taskSegment, stats));
            }
            finally {
                this.builder = null;
            }
        }
        if (session.getResult().hasExceptions()) {
            return;
        }
        boolean profiling = this.isProfiling(session);
        for (Map.Entry entry : allstats) {
            List<String> bottleneckProjects;
            TaskSegment taskSegment = (TaskSegment)entry.getKey();
            ReactorBuildStats stats = (ReactorBuildStats)entry.getValue();
            Set projects = projectBuilds.getByTaskSegment(taskSegment).getProjects();
            if (profiling || this.logger.isDebugEnabled()) {
                this.logger.info("Task segment {}, number of projects {}", (Object)taskSegment, (Object)projects.size());
            }
            long walltimeReactor = stats.walltimeTime(TimeUnit.NANOSECONDS);
            long walltimeService = stats.totalServiceTime(TimeUnit.NANOSECONDS);
            double effective = (double)walltimeService / (double)walltimeReactor;
            String effectiveConcurrency = String.format("%2.2f", effective);
            if (profiling || this.logger.isDebugEnabled()) {
                this.logger.info("Segment walltime {} s, segment projects service time {} s, effective/maximum degree of concurrency {}/{}", new Object[]{TimeUnit.NANOSECONDS.toSeconds(walltimeReactor), TimeUnit.NANOSECONDS.toSeconds(walltimeService), effectiveConcurrency, degreeOfConcurrency});
                if (projects.size() <= 1) continue;
                this.logger.info(stats.renderCriticalPath(graph));
                continue;
            }
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(2);
            this.logger.info("------------------------------------------------------------------------");
            String averageWallTime = String.format("%2.2f", (double)TimeUnit.NANOSECONDS.toSeconds(walltimeReactor) / (double)projects.size());
            this.logger.info("Average project wall time: {}s", (Object)averageWallTime);
            double percentage = effective / (double)degreeOfConcurrency;
            this.logger.info("Total concurrency: {}", (Object)NumberFormat.getPercentInstance().format(percentage));
            if (!(percentage < 0.8) || (bottleneckProjects = stats.getBottleneckProjects()).size() <= 0) continue;
            this.logger.info("Bottleneck projects that decrease concurrency: (run build with -D{}=true for further details)", (Object)PROP_PROFILING);
            for (String project : bottleneckProjects) {
                this.logger.info("\t- {}", (Object)project);
            }
        }
    }

    private boolean isProfiling(MavenSession session) {
        String value = session.getUserProperties().getProperty(PROP_PROFILING);
        if (value == null) {
            value = session.getSystemProperties().getProperty(PROP_PROFILING);
        }
        return Boolean.parseBoolean(value);
    }
}

