/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.version.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.MetadataReader;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.plugin.version.PluginVersionResult;
import org.apache.maven.plugin.version.internal.DefaultPluginVersionResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SessionData;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;

@Component(role=PluginVersionResolver.class)
public class DefaultPluginVersionResolver
implements PluginVersionResolver {
    private static final String REPOSITORY_CONTEXT = "plugin";
    private static final Object CACHE_KEY = new Object();
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private MetadataReader metadataReader;
    @Requirement
    private MavenPluginManager pluginManager;

    @Override
    public PluginVersionResult resolve(PluginVersionRequest request) throws PluginVersionResolutionException {
        PluginVersionResult result = this.resolveFromProject(request);
        if (result == null) {
            Key key;
            ConcurrentMap<Key, PluginVersionResult> cache = this.getCache(request);
            result = (PluginVersionResult)cache.get(key = DefaultPluginVersionResolver.getKey(request));
            if (result == null) {
                result = this.resolveFromRepository(request);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Resolved plugin version for " + request.getGroupId() + ":" + request.getArtifactId() + " to " + result.getVersion() + " from repository " + result.getRepository());
                }
                cache.putIfAbsent(key, result);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Reusing cached resolved plugin version for " + request.getGroupId() + ":" + request.getArtifactId() + " to " + result.getVersion() + " from POM " + request.getPom());
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolved plugin version for " + request.getGroupId() + ":" + request.getArtifactId() + " to " + result.getVersion() + " from POM " + request.getPom());
        }
        return result;
    }

    private PluginVersionResult resolveFromRepository(PluginVersionRequest request) throws PluginVersionResolutionException {
        RequestTrace trace = RequestTrace.newChild(null, (Object)request);
        DefaultPluginVersionResult result = new DefaultPluginVersionResult();
        DefaultMetadata metadata = new DefaultMetadata(request.getGroupId(), request.getArtifactId(), "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
        ArrayList<MetadataRequest> requests = new ArrayList<MetadataRequest>();
        requests.add(new MetadataRequest((Metadata)metadata, null, REPOSITORY_CONTEXT).setTrace(trace));
        for (RemoteRepository repository : request.getRepositories()) {
            requests.add(new MetadataRequest((Metadata)metadata, repository, REPOSITORY_CONTEXT).setTrace(trace));
        }
        List results = this.repositorySystem.resolveMetadata(request.getRepositorySession(), requests);
        Versions versions = new Versions();
        for (MetadataResult res : results) {
            RemoteRepository repository = res.getRequest().getRepository();
            if (repository == null) {
                repository = request.getRepositorySession().getLocalRepository();
            }
            this.mergeMetadata(request.getRepositorySession(), trace, versions, res.getMetadata(), (ArtifactRepository)repository);
        }
        this.selectVersion(result, request, versions);
        return result;
    }

    private void selectVersion(DefaultPluginVersionResult result, PluginVersionRequest request, Versions versions) throws PluginVersionResolutionException {
        String version = null;
        ArtifactRepository repo = null;
        if (StringUtils.isNotEmpty((String)versions.releaseVersion)) {
            version = versions.releaseVersion;
            repo = versions.releaseRepository;
        } else if (StringUtils.isNotEmpty((String)versions.latestVersion)) {
            version = versions.latestVersion;
            repo = versions.latestRepository;
        }
        if (version != null && !this.isCompatible(request, version)) {
            versions.versions.remove(version);
            version = null;
        }
        if (version == null) {
            String ver;
            GenericVersionScheme versionScheme = new GenericVersionScheme();
            TreeSet releases = new TreeSet(Collections.reverseOrder());
            TreeSet snapshots = new TreeSet(Collections.reverseOrder());
            for (String ver2 : versions.versions.keySet()) {
                try {
                    Version v = versionScheme.parseVersion(ver2);
                    if (ver2.endsWith("-SNAPSHOT")) {
                        snapshots.add(v);
                        continue;
                    }
                    releases.add(v);
                }
                catch (InvalidVersionSpecificationException v) {}
            }
            for (Version v : releases) {
                ver = v.toString();
                if (!this.isCompatible(request, ver)) continue;
                version = ver;
                repo = versions.versions.get(version);
                break;
            }
            if (version == null) {
                for (Version v : snapshots) {
                    ver = v.toString();
                    if (!this.isCompatible(request, ver)) continue;
                    version = ver;
                    repo = versions.versions.get(version);
                    break;
                }
            }
        }
        if (version == null) {
            throw new PluginVersionResolutionException(request.getGroupId(), request.getArtifactId(), request.getRepositorySession().getLocalRepository(), request.getRepositories(), "Plugin not found in any plugin repository");
        }
        result.setVersion(version);
        result.setRepository(repo);
    }

    private boolean isCompatible(PluginVersionRequest request, String version) {
        PluginDescriptor pluginDescriptor;
        Plugin plugin = new Plugin();
        plugin.setGroupId(request.getGroupId());
        plugin.setArtifactId(request.getArtifactId());
        plugin.setVersion(version);
        try {
            pluginDescriptor = this.pluginManager.getPluginDescriptor(plugin, request.getRepositories(), request.getRepositorySession());
        }
        catch (PluginResolutionException e) {
            this.logger.debug("Ignoring unresolvable plugin version " + version, (Throwable)e);
            return false;
        }
        catch (Exception e) {
            return true;
        }
        try {
            this.pluginManager.checkRequiredMavenVersion(pluginDescriptor);
        }
        catch (Exception e) {
            this.logger.debug("Ignoring incompatible plugin version " + version + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    private void mergeMetadata(RepositorySystemSession session, RequestTrace trace, Versions versions, Metadata metadata, ArtifactRepository repository) {
        if (metadata != null && metadata.getFile() != null && metadata.getFile().isFile()) {
            try {
                Map<String, Boolean> options = Collections.singletonMap("org.apache.maven.artifact.repository.metadata.io.isStrict", Boolean.FALSE);
                org.apache.maven.artifact.repository.metadata.Metadata repoMetadata = this.metadataReader.read(metadata.getFile(), options);
                this.mergeMetadata(versions, repoMetadata, repository);
            }
            catch (IOException e) {
                this.invalidMetadata(session, trace, metadata, repository, e);
            }
        }
    }

    private void invalidMetadata(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository, Exception exception) {
        RepositoryListener listener = session.getRepositoryListener();
        if (listener != null) {
            RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_INVALID);
            event.setTrace(trace);
            event.setMetadata(metadata);
            event.setException(exception);
            event.setRepository(repository);
            listener.metadataInvalid(event.build());
        }
    }

    private void mergeMetadata(Versions versions, org.apache.maven.artifact.repository.metadata.Metadata source, ArtifactRepository repository) {
        Versioning versioning = source.getVersioning();
        if (versioning != null) {
            String timestamp = StringUtils.clean((String)versioning.getLastUpdated());
            if (StringUtils.isNotEmpty((String)versioning.getRelease()) && timestamp.compareTo(versions.releaseTimestamp) > 0) {
                versions.releaseVersion = versioning.getRelease();
                versions.releaseTimestamp = timestamp;
                versions.releaseRepository = repository;
            }
            if (StringUtils.isNotEmpty((String)versioning.getLatest()) && timestamp.compareTo(versions.latestTimestamp) > 0) {
                versions.latestVersion = versioning.getLatest();
                versions.latestTimestamp = timestamp;
                versions.latestRepository = repository;
            }
            for (String version : versioning.getVersions()) {
                if (versions.versions.containsKey(version)) continue;
                versions.versions.put(version, repository);
            }
        }
    }

    private PluginVersionResult resolveFromProject(PluginVersionRequest request) {
        Build build;
        PluginVersionResult result = null;
        if (request.getPom() != null && request.getPom().getBuild() != null && (result = this.resolveFromProject(request, (build = request.getPom().getBuild()).getPlugins())) == null && build.getPluginManagement() != null) {
            result = this.resolveFromProject(request, build.getPluginManagement().getPlugins());
        }
        return result;
    }

    private PluginVersionResult resolveFromProject(PluginVersionRequest request, List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (!request.getGroupId().equals(plugin.getGroupId()) || !request.getArtifactId().equals(plugin.getArtifactId())) continue;
            if (plugin.getVersion() != null) {
                return new DefaultPluginVersionResult(plugin.getVersion());
            }
            return null;
        }
        return null;
    }

    private ConcurrentMap<Key, PluginVersionResult> getCache(PluginVersionRequest request) {
        SessionData data = request.getRepositorySession().getData();
        return (ConcurrentMap)data.computeIfAbsent(CACHE_KEY, () -> new ConcurrentHashMap(256));
    }

    private static Key getKey(PluginVersionRequest request) {
        return new Key(request.getGroupId(), request.getArtifactId(), request.getRepositories());
    }

    static class Key {
        final String groupId;
        final String artifactId;
        final List<RemoteRepository> repositories;
        final int hash;

        Key(String groupId, String artifactId, List<RemoteRepository> repositories) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.repositories = repositories;
            this.hash = Objects.hash(groupId, artifactId, repositories);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.groupId.equals(key.groupId) && this.artifactId.equals(key.artifactId) && this.repositories.equals(key.repositories);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    static class Versions {
        String releaseVersion = "";
        String releaseTimestamp = "";
        ArtifactRepository releaseRepository;
        String latestVersion = "";
        String latestTimestamp = "";
        ArtifactRepository latestRepository;
        Map<String, ArtifactRepository> versions = new LinkedHashMap<String, ArtifactRepository>();

        Versions() {
        }
    }
}

