/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.transform;

import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.apache.maven.model.transform.pull.BufferingParser;
import org.apache.maven.model.transform.pull.NodeBufferingParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;

public class ReactorDependencyXMLFilter
extends NodeBufferingParser {
    private final BiFunction<String, String, String> reactorVersionMapper;
    private static final Pattern S_FILTER = Pattern.compile("\\s+");

    public ReactorDependencyXMLFilter(XmlPullParser xmlPullParser, BiFunction<String, String, String> reactorVersionMapper) {
        super(xmlPullParser, "dependency");
        this.reactorVersionMapper = reactorVersionMapper;
    }

    @Override
    protected void process(List<BufferingParser.Event> buffer) {
        String dependencyWhitespace = "";
        boolean hasVersion = false;
        String groupId = null;
        String artifactId = null;
        String tagName = null;
        for (int i = 0; i < buffer.size(); ++i) {
            BufferingParser.Event event = buffer.get(i);
            if (event.event == 2) {
                tagName = event.name;
                hasVersion |= "version".equals(tagName);
                continue;
            }
            if (event.event == 4) {
                if (S_FILTER.matcher(event.text).matches()) {
                    if (!dependencyWhitespace.isEmpty()) continue;
                    dependencyWhitespace = event.text;
                    continue;
                }
                if ("groupId".equals(tagName)) {
                    groupId = ReactorDependencyXMLFilter.nullSafeAppend(groupId, event.text);
                    continue;
                }
                if (!"artifactId".equals(tagName)) continue;
                artifactId = ReactorDependencyXMLFilter.nullSafeAppend(artifactId, event.text);
                continue;
            }
            if (event.event != 3 || !"dependency".equals(event.name)) continue;
            String version = this.reactorVersionMapper.apply(groupId, artifactId);
            if (hasVersion || version == null) break;
            int pos = buffer.get((int)(i - 1)).event == 4 ? i - 1 : i;
            BufferingParser.Event e = new BufferingParser.Event();
            e.event = 4;
            e.text = dependencyWhitespace;
            buffer.add(pos++, e);
            e = new BufferingParser.Event();
            e.event = 2;
            e.namespace = buffer.get((int)0).namespace;
            e.prefix = buffer.get((int)0).prefix;
            e.name = "version";
            buffer.add(pos++, e);
            e = new BufferingParser.Event();
            e.event = 4;
            e.text = version;
            buffer.add(pos++, e);
            e = new BufferingParser.Event();
            e.event = 3;
            e.name = "version";
            e.namespace = buffer.get((int)0).namespace;
            e.prefix = buffer.get((int)0).prefix;
            buffer.add(pos++, e);
            break;
        }
        buffer.forEach(x$0 -> this.pushEvent((BufferingParser.Event)x$0));
    }
}

