/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.ImmutableCollections;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.TrackableBase;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Settings
extends TrackableBase
implements Serializable {
    final String modelEncoding;
    final String localRepository;
    final boolean interactiveMode;
    final boolean usePluginRegistry;
    final boolean offline;
    final List<Proxy> proxies;
    final List<Server> servers;
    final List<Mirror> mirrors;
    final List<Profile> profiles;
    final List<String> activeProfiles;
    final List<String> pluginGroups;
    private Proxy activeProxy;
    private Map<String, Profile> profileMap;

    Settings(String modelEncoding, String localRepository, boolean interactiveMode, boolean usePluginRegistry, boolean offline, Collection<Proxy> proxies, Collection<Server> servers, Collection<Mirror> mirrors, Collection<Profile> profiles, Collection<String> activeProfiles, Collection<String> pluginGroups) {
        this.modelEncoding = modelEncoding;
        this.localRepository = localRepository;
        this.interactiveMode = interactiveMode;
        this.usePluginRegistry = usePluginRegistry;
        this.offline = offline;
        this.proxies = ImmutableCollections.copy(proxies);
        this.servers = ImmutableCollections.copy(servers);
        this.mirrors = ImmutableCollections.copy(mirrors);
        this.profiles = ImmutableCollections.copy(profiles);
        this.activeProfiles = ImmutableCollections.copy(activeProfiles);
        this.pluginGroups = ImmutableCollections.copy(pluginGroups);
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public boolean isUsePluginRegistry() {
        return this.usePluginRegistry;
    }

    public boolean isOffline() {
        return this.offline;
    }

    @Nonnull
    public List<Proxy> getProxies() {
        return this.proxies;
    }

    @Nonnull
    public List<Server> getServers() {
        return this.servers;
    }

    @Nonnull
    public List<Mirror> getMirrors() {
        return this.mirrors;
    }

    @Nonnull
    public List<Profile> getProfiles() {
        return this.profiles;
    }

    @Nonnull
    public List<String> getActiveProfiles() {
        return this.activeProfiles;
    }

    @Nonnull
    public List<String> getPluginGroups() {
        return this.pluginGroups;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Settings.newBuilder(this);
    }

    @Nonnull
    public Settings withLocalRepository(String localRepository) {
        return Settings.newBuilder(this, true).localRepository(localRepository).build();
    }

    @Nonnull
    public Settings withInteractiveMode(boolean interactiveMode) {
        return Settings.newBuilder(this, true).interactiveMode(interactiveMode).build();
    }

    @Nonnull
    public Settings withUsePluginRegistry(boolean usePluginRegistry) {
        return Settings.newBuilder(this, true).usePluginRegistry(usePluginRegistry).build();
    }

    @Nonnull
    public Settings withOffline(boolean offline) {
        return Settings.newBuilder(this, true).offline(offline).build();
    }

    @Nonnull
    public Settings withProxies(Collection<Proxy> proxies) {
        return Settings.newBuilder(this, true).proxies(proxies).build();
    }

    @Nonnull
    public Settings withServers(Collection<Server> servers) {
        return Settings.newBuilder(this, true).servers(servers).build();
    }

    @Nonnull
    public Settings withMirrors(Collection<Mirror> mirrors) {
        return Settings.newBuilder(this, true).mirrors(mirrors).build();
    }

    @Nonnull
    public Settings withProfiles(Collection<Profile> profiles) {
        return Settings.newBuilder(this, true).profiles(profiles).build();
    }

    @Nonnull
    public Settings withActiveProfiles(Collection<String> activeProfiles) {
        return Settings.newBuilder(this, true).activeProfiles(activeProfiles).build();
    }

    @Nonnull
    public Settings withPluginGroups(Collection<String> pluginGroups) {
        return Settings.newBuilder(this, true).pluginGroups(pluginGroups).build();
    }

    @Nonnull
    public static Settings newInstance() {
        return Settings.newInstance(true);
    }

    @Nonnull
    public static Settings newInstance(boolean withDefaults) {
        return Settings.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Settings.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Settings from) {
        return Settings.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Settings from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public Boolean getInteractiveMode() {
        return this.isInteractiveMode();
    }

    public void flushActiveProxy() {
        this.activeProxy = null;
    }

    public synchronized Proxy getActiveProxy() {
        List<Proxy> proxies;
        if (this.activeProxy == null && (proxies = this.getProxies()) != null && !proxies.isEmpty()) {
            for (Proxy proxy : proxies) {
                if (!proxy.isActive()) continue;
                this.activeProxy = proxy;
                break;
            }
        }
        return this.activeProxy;
    }

    public Server getServer(String serverId) {
        Server match = null;
        List<Server> servers = this.getServers();
        if (servers != null && serverId != null) {
            for (Server server : servers) {
                if (!serverId.equals(server.getId())) continue;
                match = server;
                break;
            }
        }
        return match;
    }

    @Deprecated
    public Mirror getMirrorOf(String repositoryId) {
        Mirror match = null;
        List<Mirror> mirrors = this.getMirrors();
        if (mirrors != null && repositoryId != null) {
            for (Mirror mirror : mirrors) {
                if (!repositoryId.equals(mirror.getMirrorOf())) continue;
                match = mirror;
                break;
            }
        }
        return match;
    }

    public void flushProfileMap() {
        this.profileMap = null;
    }

    public Map<String, Profile> getProfilesAsMap() {
        if (this.profileMap == null) {
            this.profileMap = new LinkedHashMap<String, Profile>();
            if (this.getProfiles() != null) {
                for (Profile profile : this.getProfiles()) {
                    this.profileMap.put(profile.getId(), profile);
                }
            }
        }
        return this.profileMap;
    }

    @NotThreadSafe
    public static class Builder
    extends TrackableBase.Builder {
        Settings base;
        String modelEncoding;
        String localRepository;
        Boolean interactiveMode;
        Boolean usePluginRegistry;
        Boolean offline;
        Collection<Proxy> proxies;
        Collection<Server> servers;
        Collection<Mirror> mirrors;
        Collection<Profile> profiles;
        Collection<String> activeProfiles;
        Collection<String> pluginGroups;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.interactiveMode = true;
                this.usePluginRegistry = false;
                this.offline = false;
            }
        }

        Builder(Settings base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.localRepository = base.localRepository;
                this.interactiveMode = base.interactiveMode;
                this.usePluginRegistry = base.usePluginRegistry;
                this.offline = base.offline;
                this.proxies = base.proxies;
                this.servers = base.servers;
                this.mirrors = base.mirrors;
                this.profiles = base.profiles;
                this.activeProfiles = base.activeProfiles;
                this.pluginGroups = base.pluginGroups;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder localRepository(String localRepository) {
            this.localRepository = localRepository;
            return this;
        }

        @Nonnull
        public Builder interactiveMode(boolean interactiveMode) {
            this.interactiveMode = interactiveMode;
            return this;
        }

        @Nonnull
        public Builder usePluginRegistry(boolean usePluginRegistry) {
            this.usePluginRegistry = usePluginRegistry;
            return this;
        }

        @Nonnull
        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        @Nonnull
        public Builder proxies(Collection<Proxy> proxies) {
            this.proxies = proxies;
            return this;
        }

        @Nonnull
        public Builder servers(Collection<Server> servers) {
            this.servers = servers;
            return this;
        }

        @Nonnull
        public Builder mirrors(Collection<Mirror> mirrors) {
            this.mirrors = mirrors;
            return this;
        }

        @Nonnull
        public Builder profiles(Collection<Profile> profiles) {
            this.profiles = profiles;
            return this;
        }

        @Nonnull
        public Builder activeProfiles(Collection<String> activeProfiles) {
            this.activeProfiles = activeProfiles;
            return this;
        }

        @Nonnull
        public Builder pluginGroups(Collection<String> pluginGroups) {
            this.pluginGroups = pluginGroups;
            return this;
        }

        @Override
        @Nonnull
        public Settings build() {
            if (!(this.base == null || this.localRepository != null && this.localRepository != this.base.localRepository || this.interactiveMode != null && this.interactiveMode != this.base.interactiveMode || this.usePluginRegistry != null && this.usePluginRegistry != this.base.usePluginRegistry || this.offline != null && this.offline != this.base.offline || this.proxies != null && this.proxies != this.base.proxies || this.servers != null && this.servers != this.base.servers || this.mirrors != null && this.mirrors != this.base.mirrors || this.profiles != null && this.profiles != this.base.profiles || this.activeProfiles != null && this.activeProfiles != this.base.activeProfiles || this.pluginGroups != null && this.pluginGroups != this.base.pluginGroups)) {
                return this.base;
            }
            return new Settings(this.modelEncoding != null ? this.modelEncoding : (this.base != null ? this.base.modelEncoding : "UTF-8"), this.localRepository != null ? this.localRepository : (this.base != null ? this.base.localRepository : null), this.interactiveMode != null ? this.interactiveMode : (this.base != null ? this.base.interactiveMode : true), this.usePluginRegistry != null ? this.usePluginRegistry : (this.base != null ? this.base.usePluginRegistry : false), this.offline != null ? this.offline : (this.base != null ? this.base.offline : false), this.proxies != null ? this.proxies : (this.base != null ? this.base.proxies : null), this.servers != null ? this.servers : (this.base != null ? this.base.servers : null), this.mirrors != null ? this.mirrors : (this.base != null ? this.base.mirrors : null), this.profiles != null ? this.profiles : (this.base != null ? this.base.profiles : null), this.activeProfiles != null ? this.activeProfiles : (this.base != null ? this.base.activeProfiles : null), this.pluginGroups != null ? this.pluginGroups : (this.base != null ? this.base.pluginGroups : null));
        }
    }
}

