/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.v4;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.ActivationProperty;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.RepositoryBase;
import org.apache.maven.api.settings.RepositoryPolicy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.api.settings.TrackableBase;
import org.apache.maven.api.xml.XmlNode;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

@Generated
public class SettingsXpp3Writer {
    private static final String NAMESPACE = null;
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, Settings settings) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(settings.getModelEncoding(), null);
        this.writeSettings("settings", settings, (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, Settings settings) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, settings.getModelEncoding());
        serializer.startDocument(settings.getModelEncoding(), null);
        this.writeSettings("settings", settings, (XmlSerializer)serializer);
        serializer.endDocument();
    }

    protected void writeDomToSerializer(XmlNode dom, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, dom.getName());
        for (Map.Entry attribute : dom.getAttributes().entrySet()) {
            serializer.attribute(NAMESPACE, (String)attribute.getKey(), (String)attribute.getValue());
        }
        for (XmlNode aChild : dom.getChildren()) {
            this.writeDomToSerializer(aChild, serializer);
        }
        String value = dom.getValue();
        if (value != null) {
            serializer.text(value);
        }
        serializer.endTag(NAMESPACE, dom.getName());
    }

    private void writeTrackableBase(String tagName, TrackableBase trackableBase, XmlSerializer serializer) throws IOException {
        if (trackableBase != null) {
            serializer.startTag(NAMESPACE, tagName);
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeIdentifiableBase(String tagName, IdentifiableBase identifiableBase, XmlSerializer serializer) throws IOException {
        if (identifiableBase != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("id", "default", identifiableBase.getId(), serializer);
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeSettings(String tagName, Settings settings, XmlSerializer serializer) throws IOException {
        if (settings != null) {
            if (this.fileComment != null) {
                serializer.comment(this.fileComment);
            }
            serializer.setPrefix("", "http://maven.apache.org/POM/4.0.0");
            serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.startTag(NAMESPACE, tagName);
            serializer.attribute("", "xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd");
            this.writeTag("localRepository", null, settings.getLocalRepository(), serializer);
            this.writeTag("interactiveMode", "true", settings.isInteractiveMode() ? null : "false", serializer);
            this.writeTag("usePluginRegistry", "false", settings.isUsePluginRegistry() ? "true" : null, serializer);
            this.writeTag("offline", "false", settings.isOffline() ? "true" : null, serializer);
            this.writeList("proxies", false, settings.getProxies(), serializer, t -> this.writeProxy("proxy", (Proxy)t, serializer));
            this.writeList("servers", false, settings.getServers(), serializer, t -> this.writeServer("server", (Server)t, serializer));
            this.writeList("mirrors", false, settings.getMirrors(), serializer, t -> this.writeMirror("mirror", (Mirror)t, serializer));
            this.writeList("profiles", false, settings.getProfiles(), serializer, t -> this.writeProfile("profile", (Profile)t, serializer));
            this.writeList("activeProfiles", settings.getActiveProfiles(), serializer, t -> this.writeTag("activeProfile", "new java.util.ArrayList/*<String>*/()", (String)t, serializer));
            this.writeList("pluginGroups", settings.getPluginGroups(), serializer, t -> this.writeTag("pluginGroup", "new java.util.ArrayList/*<String>*/()", (String)t, serializer));
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeProxy(String tagName, Proxy proxy, XmlSerializer serializer) throws IOException {
        if (proxy != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("active", "true", proxy.isActive() ? null : "false", serializer);
            this.writeTag("protocol", "http", proxy.getProtocol(), serializer);
            this.writeTag("username", null, proxy.getUsername(), serializer);
            this.writeTag("password", null, proxy.getPassword(), serializer);
            this.writeTag("port", "8080", Integer.toString(proxy.getPort()), serializer);
            this.writeTag("host", null, proxy.getHost(), serializer);
            this.writeTag("nonProxyHosts", null, proxy.getNonProxyHosts(), serializer);
            this.writeTag("id", "default", proxy.getId(), serializer);
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeServer(String tagName, Server server, XmlSerializer serializer) throws IOException {
        if (server != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("username", null, server.getUsername(), serializer);
            this.writeTag("password", null, server.getPassword(), serializer);
            this.writeTag("privateKey", null, server.getPrivateKey(), serializer);
            this.writeTag("passphrase", null, server.getPassphrase(), serializer);
            this.writeTag("filePermissions", null, server.getFilePermissions(), serializer);
            this.writeTag("directoryPermissions", null, server.getDirectoryPermissions(), serializer);
            this.writeDom(server.getConfiguration(), serializer);
            this.writeTag("id", "default", server.getId(), serializer);
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeMirror(String tagName, Mirror mirror, XmlSerializer serializer) throws IOException {
        if (mirror != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("mirrorOf", null, mirror.getMirrorOf(), serializer);
            this.writeTag("name", null, mirror.getName(), serializer);
            this.writeTag("url", null, mirror.getUrl(), serializer);
            this.writeTag("layout", "default", mirror.getLayout(), serializer);
            this.writeTag("mirrorOfLayouts", "default,legacy", mirror.getMirrorOfLayouts(), serializer);
            this.writeTag("blocked", "false", mirror.isBlocked() ? "true" : null, serializer);
            this.writeTag("id", "default", mirror.getId(), serializer);
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeProfile(String tagName, Profile profile, XmlSerializer serializer) throws IOException {
        if (profile != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeActivation("activation", profile.getActivation(), serializer);
            this.writeProperties("properties", profile.getProperties(), serializer);
            this.writeList("repositories", false, profile.getRepositories(), serializer, t -> this.writeRepository("repository", (Repository)t, serializer));
            this.writeList("pluginRepositories", false, profile.getPluginRepositories(), serializer, t -> this.writeRepository("pluginRepository", (Repository)t, serializer));
            this.writeTag("id", "default", profile.getId(), serializer);
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeActivation(String tagName, Activation activation, XmlSerializer serializer) throws IOException {
        if (activation != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("activeByDefault", "false", activation.isActiveByDefault() ? "true" : null, serializer);
            this.writeTag("jdk", null, activation.getJdk(), serializer);
            this.writeActivationOS("os", activation.getOs(), serializer);
            this.writeActivationProperty("property", activation.getProperty(), serializer);
            this.writeActivationFile("file", activation.getFile(), serializer);
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeRepositoryBase(String tagName, RepositoryBase repositoryBase, XmlSerializer serializer) throws IOException {
        if (repositoryBase != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("id", null, repositoryBase.getId(), serializer);
            this.writeTag("name", null, repositoryBase.getName(), serializer);
            this.writeTag("url", null, repositoryBase.getUrl(), serializer);
            this.writeTag("layout", "default", repositoryBase.getLayout(), serializer);
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeRepository(String tagName, Repository repository, XmlSerializer serializer) throws IOException {
        if (repository != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeRepositoryPolicy("releases", repository.getReleases(), serializer);
            this.writeRepositoryPolicy("snapshots", repository.getSnapshots(), serializer);
            this.writeTag("id", null, repository.getId(), serializer);
            this.writeTag("name", null, repository.getName(), serializer);
            this.writeTag("url", null, repository.getUrl(), serializer);
            this.writeTag("layout", "default", repository.getLayout(), serializer);
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeRepositoryPolicy(String tagName, RepositoryPolicy repositoryPolicy, XmlSerializer serializer) throws IOException {
        if (repositoryPolicy != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("enabled", "true", repositoryPolicy.isEnabled() ? null : "false", serializer);
            this.writeTag("updatePolicy", null, repositoryPolicy.getUpdatePolicy(), serializer);
            this.writeTag("checksumPolicy", null, repositoryPolicy.getChecksumPolicy(), serializer);
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeActivationProperty(String tagName, ActivationProperty activationProperty, XmlSerializer serializer) throws IOException {
        if (activationProperty != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("name", null, activationProperty.getName(), serializer);
            this.writeTag("value", null, activationProperty.getValue(), serializer);
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeActivationOS(String tagName, ActivationOS activationOS, XmlSerializer serializer) throws IOException {
        if (activationOS != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("name", null, activationOS.getName(), serializer);
            this.writeTag("family", null, activationOS.getFamily(), serializer);
            this.writeTag("arch", null, activationOS.getArch(), serializer);
            this.writeTag("version", null, activationOS.getVersion(), serializer);
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeActivationFile(String tagName, ActivationFile activationFile, XmlSerializer serializer) throws IOException {
        if (activationFile != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("missing", null, activationFile.getMissing(), serializer);
            this.writeTag("exists", null, activationFile.getExists(), serializer);
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private <T> void writeList(String tagName, List<T> list, XmlSerializer serializer, ElementWriter<T> writer) throws IOException {
        this.writeList(tagName, false, list, serializer, writer);
    }

    private <T> void writeList(String tagName, boolean flat, List<T> list, XmlSerializer serializer, ElementWriter<T> writer) throws IOException {
        if (list != null && !list.isEmpty()) {
            if (!flat) {
                serializer.startTag(NAMESPACE, tagName);
            }
            for (T t : list) {
                writer.write(t);
            }
            if (!flat) {
                serializer.endTag(NAMESPACE, tagName);
            }
        }
    }

    private <T> void writeProperties(String tagName, Map<String, String> props, XmlSerializer serializer) throws IOException {
        if (props != null && !props.isEmpty()) {
            serializer.startTag(NAMESPACE, tagName);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                this.writeTag(entry.getKey(), null, entry.getValue(), serializer);
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeDom(XmlNode dom, XmlSerializer serializer) throws IOException {
        if (dom != null) {
            serializer.startTag(NAMESPACE, dom.getName());
            for (Map.Entry attr : dom.getAttributes().entrySet()) {
                serializer.attribute(NAMESPACE, (String)attr.getKey(), (String)attr.getValue());
            }
            for (XmlNode child : dom.getChildren()) {
                this.writeDom(child, serializer);
            }
            String value = dom.getValue();
            if (value != null) {
                serializer.text(value);
            }
            serializer.endTag(NAMESPACE, dom.getName());
        }
    }

    private void writeTag(String tagName, String defaultValue, String value, XmlSerializer serializer) throws IOException {
        if (value != null && !Objects.equals(defaultValue, value)) {
            serializer.startTag(NAMESPACE, tagName).text(value).endTag(NAMESPACE, tagName);
        }
    }

    private void writeAttr(String attrName, String value, XmlSerializer serializer) throws IOException {
        if (value != null) {
            serializer.attribute(NAMESPACE, attrName, value);
        }
    }

    @FunctionalInterface
    private static interface ElementWriter<T> {
        public void write(T var1) throws IOException;
    }
}

