/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.cache.invalidating;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.DefaultPluginDescriptorCache;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.sisu.Priority;
import org.mvndaemon.mvnd.cache.Cache;
import org.mvndaemon.mvnd.cache.CacheFactory;
import org.mvndaemon.mvnd.cache.CacheRecord;

@Singleton
@Named
@Priority(value=10)
public class InvalidatingPluginDescriptorCache
extends DefaultPluginDescriptorCache {
    final Cache<PluginDescriptorCache.Key, Record> cache;

    @Inject
    public InvalidatingPluginDescriptorCache(CacheFactory cacheFactory) {
        this.cache = cacheFactory.newCache();
    }

    public PluginDescriptorCache.Key createKey(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) {
        return super.createKey(plugin, repositories, session);
    }

    public PluginDescriptor get(PluginDescriptorCache.Key key) {
        Record r = (Record)this.cache.get((Object)key);
        return r != null ? InvalidatingPluginDescriptorCache.clone((PluginDescriptor)r.descriptor) : null;
    }

    public PluginDescriptor get(PluginDescriptorCache.Key key, PluginDescriptorSupplier supplier) throws PluginDescriptorParsingException, PluginResolutionException, InvalidPluginDescriptorException {
        try {
            Record r = (Record)this.cache.computeIfAbsent((Object)key, k -> {
                try {
                    return new Record(InvalidatingPluginDescriptorCache.clone((PluginDescriptor)supplier.load()));
                }
                catch (InvalidPluginDescriptorException | PluginDescriptorParsingException | PluginResolutionException e) {
                    throw new RuntimeException(e);
                }
            });
            return InvalidatingPluginDescriptorCache.clone((PluginDescriptor)r.descriptor);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof PluginDescriptorParsingException) {
                throw (PluginDescriptorParsingException)e.getCause();
            }
            if (e.getCause() instanceof PluginResolutionException) {
                throw (PluginResolutionException)e.getCause();
            }
            if (e.getCause() instanceof InvalidPluginDescriptorException) {
                throw (InvalidPluginDescriptorException)e.getCause();
            }
            throw e;
        }
    }

    public void put(PluginDescriptorCache.Key key, PluginDescriptor descriptor) {
        this.cache.put((Object)key, (CacheRecord)new Record(InvalidatingPluginDescriptorCache.clone((PluginDescriptor)descriptor)));
    }

    public void flush() {
        this.cache.clear();
    }

    protected static class Record
    implements CacheRecord {
        private final PluginDescriptor descriptor;

        public Record(PluginDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public Stream<Path> getDependencyPaths() {
            return Optional.ofNullable(this.descriptor.getArtifacts()).orElse(Collections.emptyList()).stream().map(artifact -> artifact.getFile().toPath());
        }

        public void invalidate() {
            ClassRealm realm = this.descriptor.getClassRealm();
            try {
                realm.getWorld().disposeRealm(realm.getId());
            }
            catch (NoSuchRealmException noSuchRealmException) {
                // empty catch block
            }
        }
    }

    @FunctionalInterface
    public static interface PluginDescriptorSupplier {
        public PluginDescriptor load() throws PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException;
    }
}

