/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.CiManagement;
import org.apache.maven.api.model.Contributor;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.Developer;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.IssueManagement;
import org.apache.maven.api.model.License;
import org.apache.maven.api.model.MailingList;
import org.apache.maven.api.model.ModelBase;
import org.apache.maven.api.model.Organization;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.model.Prerequisites;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Reporting;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.Scm;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Model
extends ModelBase
implements Serializable,
InputLocationTracker {
    final String modelEncoding;
    final Path pomFile;
    final String modelVersion;
    final Parent parent;
    final String groupId;
    final String artifactId;
    final String version;
    final String packaging;
    final String name;
    final String description;
    final String url;
    final String childProjectUrlInheritAppendPath;
    final String inceptionYear;
    final Organization organization;
    final List<License> licenses;
    final List<Developer> developers;
    final List<Contributor> contributors;
    final List<MailingList> mailingLists;
    final Prerequisites prerequisites;
    final Scm scm;
    final IssueManagement issueManagement;
    final CiManagement ciManagement;
    final Build build;
    final List<Profile> profiles;

    Model(String modelEncoding, Collection<String> modules, DistributionManagement distributionManagement, Map<String, String> properties, DependencyManagement dependencyManagement, Collection<Dependency> dependencies, Collection<Repository> repositories, Collection<Repository> pluginRepositories, Reporting reporting, Path pomFile, String modelVersion, Parent parent, String groupId, String artifactId, String version, String packaging, String name, String description, String url, String childProjectUrlInheritAppendPath, String inceptionYear, Organization organization, Collection<License> licenses, Collection<Developer> developers, Collection<Contributor> contributors, Collection<MailingList> mailingLists, Prerequisites prerequisites, Scm scm, IssueManagement issueManagement, CiManagement ciManagement, Build build, Collection<Profile> profiles, Map<Object, InputLocation> locations) {
        super(modules, distributionManagement, properties, dependencyManagement, dependencies, repositories, pluginRepositories, reporting, locations);
        this.modelEncoding = modelEncoding;
        this.pomFile = pomFile;
        this.modelVersion = modelVersion;
        this.parent = parent;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.packaging = packaging;
        this.name = name;
        this.description = description;
        this.url = url;
        this.childProjectUrlInheritAppendPath = childProjectUrlInheritAppendPath;
        this.inceptionYear = inceptionYear;
        this.organization = organization;
        this.licenses = ImmutableCollections.copy(licenses);
        this.developers = ImmutableCollections.copy(developers);
        this.contributors = ImmutableCollections.copy(contributors);
        this.mailingLists = ImmutableCollections.copy(mailingLists);
        this.prerequisites = prerequisites;
        this.scm = scm;
        this.issueManagement = issueManagement;
        this.ciManagement = ciManagement;
        this.build = build;
        this.profiles = ImmutableCollections.copy(profiles);
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public Path getPomFile() {
        return this.pomFile;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public Parent getParent() {
        return this.parent;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public String getChildProjectUrlInheritAppendPath() {
        return this.childProjectUrlInheritAppendPath;
    }

    public String getInceptionYear() {
        return this.inceptionYear;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    @Nonnull
    public List<License> getLicenses() {
        return this.licenses;
    }

    @Nonnull
    public List<Developer> getDevelopers() {
        return this.developers;
    }

    @Nonnull
    public List<Contributor> getContributors() {
        return this.contributors;
    }

    @Nonnull
    public List<MailingList> getMailingLists() {
        return this.mailingLists;
    }

    public Prerequisites getPrerequisites() {
        return this.prerequisites;
    }

    public Scm getScm() {
        return this.scm;
    }

    public IssueManagement getIssueManagement() {
        return this.issueManagement;
    }

    public CiManagement getCiManagement() {
        return this.ciManagement;
    }

    public Build getBuild() {
        return this.build;
    }

    @Nonnull
    public List<Profile> getProfiles() {
        return this.profiles;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Model.newBuilder(this);
    }

    @Override
    @Nonnull
    public Model withModules(Collection<String> modules) {
        return ((Builder)Model.newBuilder(this, true).modules((Collection)modules)).build();
    }

    @Override
    @Nonnull
    public Model withDistributionManagement(DistributionManagement distributionManagement) {
        return Model.newBuilder(this, true).distributionManagement(distributionManagement).build();
    }

    @Override
    @Nonnull
    public Model withProperties(Map<String, String> properties) {
        return ((Builder)Model.newBuilder(this, true).properties((Map)properties)).build();
    }

    @Override
    @Nonnull
    public Model withDependencyManagement(DependencyManagement dependencyManagement) {
        return Model.newBuilder(this, true).dependencyManagement(dependencyManagement).build();
    }

    @Override
    @Nonnull
    public Model withDependencies(Collection<Dependency> dependencies) {
        return ((Builder)Model.newBuilder(this, true).dependencies((Collection)dependencies)).build();
    }

    @Override
    @Nonnull
    public Model withRepositories(Collection<Repository> repositories) {
        return ((Builder)Model.newBuilder(this, true).repositories((Collection)repositories)).build();
    }

    @Override
    @Nonnull
    public Model withPluginRepositories(Collection<Repository> pluginRepositories) {
        return ((Builder)Model.newBuilder(this, true).pluginRepositories((Collection)pluginRepositories)).build();
    }

    @Override
    @Nonnull
    public Model withReporting(Reporting reporting) {
        return Model.newBuilder(this, true).reporting(reporting).build();
    }

    @Nonnull
    public Model withPomFile(Path pomFile) {
        return Model.newBuilder(this, true).pomFile(pomFile).build();
    }

    @Nonnull
    public Model withModelVersion(String modelVersion) {
        return Model.newBuilder(this, true).modelVersion(modelVersion).build();
    }

    @Nonnull
    public Model withParent(Parent parent) {
        return Model.newBuilder(this, true).parent(parent).build();
    }

    @Nonnull
    public Model withGroupId(String groupId) {
        return Model.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public Model withArtifactId(String artifactId) {
        return Model.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public Model withVersion(String version) {
        return Model.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public Model withPackaging(String packaging) {
        return Model.newBuilder(this, true).packaging(packaging).build();
    }

    @Nonnull
    public Model withName(String name) {
        return Model.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public Model withDescription(String description) {
        return Model.newBuilder(this, true).description(description).build();
    }

    @Nonnull
    public Model withUrl(String url) {
        return Model.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public Model withChildProjectUrlInheritAppendPath(String childProjectUrlInheritAppendPath) {
        return Model.newBuilder(this, true).childProjectUrlInheritAppendPath(childProjectUrlInheritAppendPath).build();
    }

    @Nonnull
    public Model withInceptionYear(String inceptionYear) {
        return Model.newBuilder(this, true).inceptionYear(inceptionYear).build();
    }

    @Nonnull
    public Model withOrganization(Organization organization) {
        return Model.newBuilder(this, true).organization(organization).build();
    }

    @Nonnull
    public Model withLicenses(Collection<License> licenses) {
        return Model.newBuilder(this, true).licenses(licenses).build();
    }

    @Nonnull
    public Model withDevelopers(Collection<Developer> developers) {
        return Model.newBuilder(this, true).developers(developers).build();
    }

    @Nonnull
    public Model withContributors(Collection<Contributor> contributors) {
        return Model.newBuilder(this, true).contributors(contributors).build();
    }

    @Nonnull
    public Model withMailingLists(Collection<MailingList> mailingLists) {
        return Model.newBuilder(this, true).mailingLists(mailingLists).build();
    }

    @Nonnull
    public Model withPrerequisites(Prerequisites prerequisites) {
        return Model.newBuilder(this, true).prerequisites(prerequisites).build();
    }

    @Nonnull
    public Model withScm(Scm scm) {
        return Model.newBuilder(this, true).scm(scm).build();
    }

    @Nonnull
    public Model withIssueManagement(IssueManagement issueManagement) {
        return Model.newBuilder(this, true).issueManagement(issueManagement).build();
    }

    @Nonnull
    public Model withCiManagement(CiManagement ciManagement) {
        return Model.newBuilder(this, true).ciManagement(ciManagement).build();
    }

    @Nonnull
    public Model withBuild(Build build) {
        return Model.newBuilder(this, true).build(build).build();
    }

    @Nonnull
    public Model withProfiles(Collection<Profile> profiles) {
        return Model.newBuilder(this, true).profiles(profiles).build();
    }

    @Nonnull
    public static Model newInstance() {
        return Model.newInstance(true);
    }

    @Nonnull
    public static Model newInstance(boolean withDefaults) {
        return Model.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Model.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Model from) {
        return Model.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Model from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public Path getProjectDirectory() {
        return this.pomFile != null ? this.pomFile.getParent() : null;
    }

    public String getId() {
        StringBuilder id = new StringBuilder(64);
        id.append(this.getGroupId() == null ? "[inherited]" : this.getGroupId());
        id.append(":");
        id.append(this.getArtifactId());
        id.append(":");
        id.append(this.getPackaging());
        id.append(":");
        id.append(this.getVersion() == null ? "[inherited]" : this.getVersion());
        return id.toString();
    }

    public String toString() {
        return this.getId();
    }

    public boolean isChildProjectUrlInheritAppendPath() {
        return this.getChildProjectUrlInheritAppendPath() != null ? Boolean.parseBoolean(this.getChildProjectUrlInheritAppendPath()) : true;
    }

    @NotThreadSafe
    public static class Builder
    extends ModelBase.Builder {
        Model base;
        String modelEncoding;
        Path pomFile;
        String modelVersion;
        Parent parent;
        String groupId;
        String artifactId;
        String version;
        String packaging;
        String name;
        String description;
        String url;
        String childProjectUrlInheritAppendPath;
        String inceptionYear;
        Organization organization;
        Collection<License> licenses;
        Collection<Developer> developers;
        Collection<Contributor> contributors;
        Collection<MailingList> mailingLists;
        Prerequisites prerequisites;
        Scm scm;
        IssueManagement issueManagement;
        CiManagement ciManagement;
        Build build;
        Collection<Profile> profiles;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.packaging = "jar";
            }
        }

        Builder(Model base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.pomFile = base.pomFile;
                this.modelVersion = base.modelVersion;
                this.parent = base.parent;
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.packaging = base.packaging;
                this.name = base.name;
                this.description = base.description;
                this.url = base.url;
                this.childProjectUrlInheritAppendPath = base.childProjectUrlInheritAppendPath;
                this.inceptionYear = base.inceptionYear;
                this.organization = base.organization;
                this.licenses = base.licenses;
                this.developers = base.developers;
                this.contributors = base.contributors;
                this.mailingLists = base.mailingLists;
                this.prerequisites = base.prerequisites;
                this.scm = base.scm;
                this.issueManagement = base.issueManagement;
                this.ciManagement = base.ciManagement;
                this.build = base.build;
                this.profiles = base.profiles;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Override
        @Nonnull
        public Builder modules(Collection<String> modules) {
            this.modules = modules;
            return this;
        }

        @Override
        @Nonnull
        public Builder distributionManagement(DistributionManagement distributionManagement) {
            this.distributionManagement = distributionManagement;
            return this;
        }

        @Override
        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Override
        @Nonnull
        public Builder dependencyManagement(DependencyManagement dependencyManagement) {
            this.dependencyManagement = dependencyManagement;
            return this;
        }

        @Override
        @Nonnull
        public Builder dependencies(Collection<Dependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @Override
        @Nonnull
        public Builder repositories(Collection<Repository> repositories) {
            this.repositories = repositories;
            return this;
        }

        @Override
        @Nonnull
        public Builder pluginRepositories(Collection<Repository> pluginRepositories) {
            this.pluginRepositories = pluginRepositories;
            return this;
        }

        @Override
        @Nonnull
        public Builder reporting(Reporting reporting) {
            this.reporting = reporting;
            return this;
        }

        @Nonnull
        public Builder pomFile(Path pomFile) {
            this.pomFile = pomFile;
            return this;
        }

        @Nonnull
        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        @Nonnull
        public Builder parent(Parent parent) {
            this.parent = parent;
            return this;
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder packaging(String packaging) {
            this.packaging = packaging;
            return this;
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder childProjectUrlInheritAppendPath(String childProjectUrlInheritAppendPath) {
            this.childProjectUrlInheritAppendPath = childProjectUrlInheritAppendPath;
            return this;
        }

        @Nonnull
        public Builder inceptionYear(String inceptionYear) {
            this.inceptionYear = inceptionYear;
            return this;
        }

        @Nonnull
        public Builder organization(Organization organization) {
            this.organization = organization;
            return this;
        }

        @Nonnull
        public Builder licenses(Collection<License> licenses) {
            this.licenses = licenses;
            return this;
        }

        @Nonnull
        public Builder developers(Collection<Developer> developers) {
            this.developers = developers;
            return this;
        }

        @Nonnull
        public Builder contributors(Collection<Contributor> contributors) {
            this.contributors = contributors;
            return this;
        }

        @Nonnull
        public Builder mailingLists(Collection<MailingList> mailingLists) {
            this.mailingLists = mailingLists;
            return this;
        }

        @Nonnull
        public Builder prerequisites(Prerequisites prerequisites) {
            this.prerequisites = prerequisites;
            return this;
        }

        @Nonnull
        public Builder scm(Scm scm) {
            this.scm = scm;
            return this;
        }

        @Nonnull
        public Builder issueManagement(IssueManagement issueManagement) {
            this.issueManagement = issueManagement;
            return this;
        }

        @Nonnull
        public Builder ciManagement(CiManagement ciManagement) {
            this.ciManagement = ciManagement;
            return this;
        }

        @Nonnull
        public Builder build(Build build) {
            this.build = build;
            return this;
        }

        @Nonnull
        public Builder profiles(Collection<Profile> profiles) {
            this.profiles = profiles;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Model build() {
            if (!(this.base == null || this.modules != null && this.modules != this.base.modules || this.distributionManagement != null && this.distributionManagement != this.base.distributionManagement || this.properties != null && this.properties != this.base.properties || this.dependencyManagement != null && this.dependencyManagement != this.base.dependencyManagement || this.dependencies != null && this.dependencies != this.base.dependencies || this.repositories != null && this.repositories != this.base.repositories || this.pluginRepositories != null && this.pluginRepositories != this.base.pluginRepositories || this.reporting != null && this.reporting != this.base.reporting || this.pomFile != null && this.pomFile != this.base.pomFile || this.modelVersion != null && this.modelVersion != this.base.modelVersion || this.parent != null && this.parent != this.base.parent || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.packaging != null && this.packaging != this.base.packaging || this.name != null && this.name != this.base.name || this.description != null && this.description != this.base.description || this.url != null && this.url != this.base.url || this.childProjectUrlInheritAppendPath != null && this.childProjectUrlInheritAppendPath != this.base.childProjectUrlInheritAppendPath || this.inceptionYear != null && this.inceptionYear != this.base.inceptionYear || this.organization != null && this.organization != this.base.organization || this.licenses != null && this.licenses != this.base.licenses || this.developers != null && this.developers != this.base.developers || this.contributors != null && this.contributors != this.base.contributors || this.mailingLists != null && this.mailingLists != this.base.mailingLists || this.prerequisites != null && this.prerequisites != this.base.prerequisites || this.scm != null && this.scm != this.base.scm || this.issueManagement != null && this.issueManagement != this.base.issueManagement || this.ciManagement != null && this.ciManagement != this.base.ciManagement || this.build != null && this.build != this.base.build || this.profiles != null && this.profiles != this.base.profiles)) {
                return this.base;
            }
            Map locations = null;
            Object location = null;
            Object modulesLocation = null;
            Object distributionManagementLocation = null;
            Object propertiesLocation = null;
            Object dependencyManagementLocation = null;
            Object dependenciesLocation = null;
            Object repositoriesLocation = null;
            Object pluginRepositoriesLocation = null;
            Object reportingLocation = null;
            Object pomFileLocation = null;
            Object modelVersionLocation = null;
            Object parentLocation = null;
            Object groupIdLocation = null;
            Object artifactIdLocation = null;
            Object versionLocation = null;
            Object packagingLocation = null;
            Object nameLocation = null;
            Object descriptionLocation = null;
            Object urlLocation = null;
            Object childProjectUrlInheritAppendPathLocation = null;
            Object inceptionYearLocation = null;
            Object organizationLocation = null;
            Object licensesLocation = null;
            Object developersLocation = null;
            Object contributorsLocation = null;
            Object mailingListsLocation = null;
            Object prerequisitesLocation = null;
            Object scmLocation = null;
            Object issueManagementLocation = null;
            Object ciManagementLocation = null;
            Object buildLocation = null;
            Object profilesLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new Model(this.modelEncoding != null ? this.modelEncoding : (this.base != null ? this.base.modelEncoding : "UTF-8"), this.modules != null ? this.modules : (this.base != null ? this.base.modules : null), this.distributionManagement != null ? this.distributionManagement : (this.base != null ? this.base.distributionManagement : null), this.properties != null ? this.properties : (this.base != null ? this.base.properties : null), this.dependencyManagement != null ? this.dependencyManagement : (this.base != null ? this.base.dependencyManagement : null), this.dependencies != null ? this.dependencies : (this.base != null ? this.base.dependencies : null), this.repositories != null ? this.repositories : (this.base != null ? this.base.repositories : null), this.pluginRepositories != null ? this.pluginRepositories : (this.base != null ? this.base.pluginRepositories : null), this.reporting != null ? this.reporting : (this.base != null ? this.base.reporting : null), this.pomFile != null ? this.pomFile : (this.base != null ? this.base.pomFile : null), this.modelVersion != null ? this.modelVersion : (this.base != null ? this.base.modelVersion : null), this.parent != null ? this.parent : (this.base != null ? this.base.parent : null), this.groupId != null ? this.groupId : (this.base != null ? this.base.groupId : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), this.packaging != null ? this.packaging : (this.base != null ? this.base.packaging : null), this.name != null ? this.name : (this.base != null ? this.base.name : null), this.description != null ? this.description : (this.base != null ? this.base.description : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), this.childProjectUrlInheritAppendPath != null ? this.childProjectUrlInheritAppendPath : (this.base != null ? this.base.childProjectUrlInheritAppendPath : null), this.inceptionYear != null ? this.inceptionYear : (this.base != null ? this.base.inceptionYear : null), this.organization != null ? this.organization : (this.base != null ? this.base.organization : null), this.licenses != null ? this.licenses : (this.base != null ? this.base.licenses : null), this.developers != null ? this.developers : (this.base != null ? this.base.developers : null), this.contributors != null ? this.contributors : (this.base != null ? this.base.contributors : null), this.mailingLists != null ? this.mailingLists : (this.base != null ? this.base.mailingLists : null), this.prerequisites != null ? this.prerequisites : (this.base != null ? this.base.prerequisites : null), this.scm != null ? this.scm : (this.base != null ? this.base.scm : null), this.issueManagement != null ? this.issueManagement : (this.base != null ? this.base.issueManagement : null), this.ciManagement != null ? this.ciManagement : (this.base != null ? this.base.ciManagement : null), this.build != null ? this.build : (this.base != null ? this.base.build : null), this.profiles != null ? this.profiles : (this.base != null ? this.base.profiles : null), locations != null ? locations : (this.base != null ? this.base.locations : null));
        }
    }
}

