/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.properties.internal.SystemProperties;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named
@Singleton
public class DefaultMavenSettingsBuilder
extends AbstractLogEnabled
implements MavenSettingsBuilder {
    private final SettingsBuilder settingsBuilder;

    @Inject
    public DefaultMavenSettingsBuilder(SettingsBuilder settingsBuilder) {
        this.settingsBuilder = settingsBuilder;
    }

    @Override
    public Settings buildSettings() throws IOException, XmlPullParserException {
        File userSettingsFile = this.getFile("${user.home}/.m2/settings.xml", "user.home", "org.apache.maven.user-settings");
        return this.buildSettings(userSettingsFile);
    }

    @Override
    public Settings buildSettings(boolean useCachedSettings) throws IOException, XmlPullParserException {
        return this.buildSettings();
    }

    @Override
    public Settings buildSettings(File userSettingsFile) throws IOException, XmlPullParserException {
        File globalSettingsFile = this.getFile("${maven.conf}/settings.xml", "maven.conf", "org.apache.maven.global-settings");
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setUserSettingsFile(userSettingsFile);
        request.setGlobalSettingsFile(globalSettingsFile);
        request.setSystemProperties(SystemProperties.getSystemProperties());
        return this.build((SettingsBuildingRequest)request);
    }

    @Override
    public Settings buildSettings(File userSettingsFile, boolean useCachedSettings) throws IOException, XmlPullParserException {
        return this.buildSettings(userSettingsFile);
    }

    private Settings build(SettingsBuildingRequest request) throws IOException, XmlPullParserException {
        try {
            return this.settingsBuilder.build(request).getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public Settings buildSettings(MavenExecutionRequest request) throws IOException, XmlPullParserException {
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        settingsRequest.setUserSettingsFile(request.getUserSettingsFile());
        settingsRequest.setGlobalSettingsFile(request.getGlobalSettingsFile());
        settingsRequest.setUserProperties(request.getUserProperties());
        settingsRequest.setSystemProperties(request.getSystemProperties());
        return this.build((SettingsBuildingRequest)settingsRequest);
    }

    private File getFile(String pathPattern, String basedirSysProp, String altLocationSysProp) {
        String path = System.getProperty(altLocationSysProp);
        if (StringUtils.isEmpty((String)path)) {
            String basedir = System.getProperty(basedirSysProp);
            if (basedir == null) {
                basedir = System.getProperty("user.dir");
            }
            basedir = basedir.replace("\\", "/");
            basedir = basedir.replace("$", "\\$");
            path = pathPattern.replace("${" + basedirSysProp + "}", basedir);
            path = path.replace("\\", "/");
        }
        return new File(path).getAbsoluteFile();
    }
}

